/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Ensembl2Seq {
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("in", "ensembl file", "a plain-text Ensembl file", true, false));
            this.addOption(CLIUtils.createArgOption("out", "output file", "sequence as plain-text", true, false));
        }
    };

    public static void printUsageAndExit() {
        new HelpFormatter().printHelp("java -jar Ensembl2Seq.jar", "Ensembl Sequence Extractor by Ulrich Omasits", options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String line;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-in", "P:/33_omul/projects/ecoli_fiona/ers473442/NCTC13400_E_coli_presub_v0.1.embl", "-out", "P:/33_omul/projects/ecoli_fiona/ers473442/NCTC13400_E_coli_presub_v0.1.fna"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            Ensembl2Seq.printUsageAndExit();
        }
        File fIn = new File(cli.getOptionValue("in"));
        BufferedReader in = Utils.reader(fIn);
        File fOut = new File(cli.getOptionValue("out"));
        if (fOut.exists()) {
            System.err.println("ERROR: " + fOut.getName() + " already exists.");
            System.exit(0);
        }
        UOBufferedWriter out = new UOBufferedWriter(fOut);
        System.out.println("INFO: Parsing '" + fIn.getName() + "'...");
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("SQ   ")) continue;
            out.writeLine(">" + fIn.getName());
            while (!(line = in.readLine()).startsWith("//")) {
                out.write(line.substring(5, 70).replaceAll(" ", "").toUpperCase());
            }
            out.writeLine("");
        }
        in.close();
        out.close();
        System.out.println("INFO: Parsing '" + fIn.getName() + "' done! Sequence written to '" + fOut.getName() + "'.");
    }
}

