/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.converter.AConverter;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Genoscope2GFF
extends AConverter {
    @Override
    protected void convert_internal(File inputFile) throws Exception {
        BufferedReader in = Utils.reader(inputFile);
        List<String> consideredTypes = Arrays.asList("CDS", "fCDS");
        ArrayList<String> totalTags = new ArrayList<String>();
        String line = in.readLine();
        while ((line = in.readLine()) != null) {
            totalTags.add(line.split("\\t")[0]);
        }
        in.close();
        in = Utils.reader(inputFile);
        ArrayList<String> tags = new ArrayList<String>();
        line = in.readLine();
        while ((line = in.readLine()) != null) {
            String[] arr = line.split("\\t");
            String tag = arr[0];
            tags.add(tag);
            String type = arr[1];
            if (!consideredTypes.contains(type) && consideredTypes.size() != 0) continue;
            int start = Integer.valueOf(arr[3]);
            int end = Integer.valueOf(arr[4]);
            GenomeLocation.Strand strand = arr[2].startsWith("-") ? GenomeLocation.Strand.MINUS : GenomeLocation.Strand.PLUS;
            GenomeLocation loc = new GenomeLocation(start, end, strand, null);
            boolean pseudo = arr[7].equals("pseudo");
            GenomeFeature gff = new GenomeFeature(this.seqId, this.source, type, loc, tag, pseudo);
            if (Collections.frequency(totalTags, tag) > 1) {
                gff.setAtt("idRedundancy", String.valueOf(Collections.frequency(tags, tag)) + "of" + Collections.frequency(totalTags, tag));
            }
            this.addGenomeFeature(gff);
        }
        in.close();
    }

    @Override
    protected Color getColor() {
        return Color.GREEN;
    }
}

