/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeFeatureSet;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Version;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Gff2Protein {
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("in", "input file", "the input gff3 file", true, false));
            this.addOption(CLIUtils.createArgOption("seq", "input file", "the nucleotide sequence", true, false));
            this.addOption(CLIUtils.createArgOption("out", "output file", "the output fasta file", true, false));
        }
    };

    public static void printUsageAndExit() {
        String description = "Gff2Protein v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar Gff2Protein.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws IOException, Exception {
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-in", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/genoscope/bh.genoscope__20160309.proteins+pseudo.gff3", "-seq", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/NC_005956.fasta", "-out", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/genoscope/bh.genoscope__20160309.proteins+pseudo+fCDS.fasta"};
        }
        String prefix = "";
        Boolean includePseudo = true;
        String pseudoSuffix = "_p";
        List<String> types = Arrays.asList("CDS", "gene", "fCDS");
        boolean setInitMet = true;
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            Gff2Protein.printUsageAndExit();
        }
        File fIn = CLIUtils.getFileOption(cli, "in", false);
        File fSeq = CLIUtils.getFileOption(cli, "seq", false);
        Map<String, String> fasta = FastaReader.readFile(fSeq, FastaReader.headerComplete);
        File fOut = CLIUtils.getFileOption(cli, "out", true);
        UOBufferedWriter out = new UOBufferedWriter(fOut);
        System.out.println("INFO: Reading '" + fIn.getName() + "'...");
        GenomeFeatureSet gfs = new GenomeFeatureSet(fIn, null, includePseudo);
        int i = 0;
        StringBuilder forwardSequence = null;
        if (fasta.size() == 1) {
            forwardSequence = new StringBuilder(fasta.values().iterator().next());
        }
        for (GenomeFeature gf : gfs) {
            if (types.indexOf(gf.type) == -1) continue;
            if (fasta.size() > 1) {
                forwardSequence = new StringBuilder(fasta.get(gf.seqId));
            }
            String suffix = gf.getAtt("pseudo", "").equals("true") ? pseudoSuffix : "";
            gf.setID(String.valueOf(prefix) + gf.getID() + suffix);
            out.writeLine(gf.toFastaEntry(forwardSequence, setInitMet, true));
            ++i;
        }
        out.close();
        System.out.println("INFO: Done! " + i + " proteins written to '" + fOut.getName() + "'.");
    }
}

