/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import iptgxdb.intervaltree.Interval;
import iptgxdb.intervaltree.IntervalTree;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class GffOverlaps {
    public static void main(String[] args) throws Exception {
        String line;
        File fIn2 = new File("/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/transposon_mutagenesis/Phase3/analysis_transit/TandAsites_Fw_MQB277.gff3");
        File fIn1 = new File("/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/transposon_mutagenesis/Phase3/resultsFromBeat_05092017/Bartonella_TnSeq/MQB277_combined_Experiments/Exp_1/Results_Exp_1_MQB277_all/Results_Exp/results_tabdelimited/complex/Exp_CDS.txt.all.sorted.gff");
        File fOut = new File("/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/transposon_mutagenesis/Phase3/resultsFromBeat_05092017/Bartonella_TnSeq/MQB277_combined_Experiments/Exp_1/Results_Exp_1_MQB277_all/Results_Exp/results_tabdelimited/complex/Exp_CDS.all.sorted.perFeatureTAsites.tsv");
        boolean excludeSameIdHits = true;
        Boolean isBedFile1 = null;
        Boolean isBedFile2 = null;
        if (fIn1.getName().toLowerCase().endsWith(".bed")) {
            isBedFile1 = true;
        } else if (fIn1.getName().toLowerCase().endsWith(".gff") || fIn1.getName().toLowerCase().endsWith(".gff3")) {
            isBedFile1 = false;
        } else {
            System.err.println("ERROR: First file has to be a GFF file or a BED file!");
            System.exit(-1);
        }
        if (fIn2.getName().toLowerCase().endsWith(".bed")) {
            isBedFile2 = true;
        } else if (fIn2.getName().toLowerCase().endsWith(".gff") || fIn2.getName().toLowerCase().endsWith(".gff3")) {
            isBedFile2 = false;
        } else {
            System.err.println("ERROR: Second file has to be a GFF file or a BED file!");
            System.exit(-1);
        }
        BufferedReader in2 = Utils.reader(fIn2);
        IntervalTree<GenomeFeature> gftree = new IntervalTree<GenomeFeature>();
        while ((line = in2.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("track name=")) continue;
            GenomeFeature gf = isBedFile2 != false ? new GenomeFeature(line, fIn2.getName()) : new GenomeFeature(line);
            gftree.addInterval(gf.location.from, gf.location.to, gf);
        }
        in2.close();
        UOBufferedWriter out = new UOBufferedWriter(fOut);
        out.writeTsvLine("id - " + fIn1.getName(), "intersecting ids - " + fIn2.getName(), "intersecting ids syn - " + fIn2.getName(), "intersecting ids anti - " + fIn2.getName(), "contained ids - " + fIn2.getName(), "contained ids syn - " + fIn2.getName(), "contained ids anti - " + fIn2.getName(), "length", "length of intersected gene", "intersected length", "intersected length syn", "intersected length anti");
        BufferedReader in1 = Utils.reader(fIn1);
        while ((line = in1.readLine()) != null) {
            String match;
            if (line.startsWith("#") || line.startsWith("track name=")) continue;
            GenomeFeature gf = isBedFile1 != false ? new GenomeFeature(line, fIn1.getName()) : new GenomeFeature(line);
            LinkedHashSet<String> intersectingIDs = new LinkedHashSet<String>();
            LinkedHashSet<String> intersectingIDsSyn = new LinkedHashSet<String>();
            LinkedHashSet<String> intersectingIDsAnti = new LinkedHashSet<String>();
            HashSet<Integer> intersected = new HashSet<Integer>();
            HashSet<Integer> intersectedSyn = new HashSet<Integer>();
            HashSet<Integer> intersectedAnti = new HashSet<Integer>();
            for (Interval intersectInt : gftree.getIntervalsIntersect(gf.location.from, gf.location.to)) {
                GenomeFeature intersectGF = (GenomeFeature)intersectInt.getData();
                if (excludeSameIdHits && intersectGF.getID().equalsIgnoreCase(gf.getID())) continue;
                long i = intersectInt.intersectionLength(gf.location.from, gf.location.to);
                match = String.valueOf(intersectGF.getID()) + " (" + Utils.formatPercent(i, gf.location.length()) + ")";
                intersectingIDs.add(match);
                if (intersectGF.location.strand == gf.location.strand) {
                    intersectingIDsSyn.add(match);
                } else {
                    intersectingIDsAnti.add(match);
                }
                int p = Math.max(gf.location.from, intersectGF.location.from);
                while (p <= Math.min(gf.location.to, intersectGF.location.to)) {
                    intersected.add(p);
                    if (intersectGF.location.strand == gf.location.strand) {
                        intersectedSyn.add(p);
                    } else {
                        intersectedAnti.add(p);
                    }
                    ++p;
                }
            }
            LinkedHashSet<String> containedIDs = new LinkedHashSet<String>();
            LinkedHashSet<String> containedIDsSyn = new LinkedHashSet<String>();
            LinkedHashSet<String> containedIDsAnti = new LinkedHashSet<String>();
            for (GenomeFeature containedGF : gftree.getWithin(gf.location.from, gf.location.to)) {
                if (excludeSameIdHits && containedGF.getID().equalsIgnoreCase(gf.getID())) continue;
                match = String.valueOf(containedGF.getID()) + " (" + Utils.formatPercent(containedGF.location.length(), gf.location.length()) + ")";
                containedIDs.add(match);
                if (containedGF.location.strand == gf.location.strand) {
                    containedIDsSyn.add(match);
                    continue;
                }
                containedIDsAnti.add(match);
            }
            out.writeTsvLine(gf.getID(), Joiner.on(", ").join(intersectingIDs), Joiner.on(", ").join(intersectingIDsSyn), Joiner.on(", ").join(intersectingIDsAnti), Joiner.on(", ").join(containedIDs), Joiner.on(", ").join(containedIDsSyn), Joiner.on(", ").join(containedIDsAnti), gf.location.length(), intersected.size(), intersectedSyn.size(), intersectedAnti.size());
        }
        in1.close();
        out.close();
    }
}

