/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeFeatureSet;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import iptgxdb.utils.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Peptides2Wig {
    public static int maxSpc = 100;
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("pep", "input", "a tabular peptide file (tsv file)", true, false));
            this.addOption(CLIUtils.createArgOption("gff", "input", "the protein annotation file (gff3 file)", true, false));
            this.addOption(CLIUtils.createArgOption("seq", "input", "the nucleotide fasta file", true, false));
            this.addOption(CLIUtils.createArgOption("out", "string", "an output prefix for various annotation files", true, false));
            this.addOption(CLIUtils.createArgOption("max", "number", "maximum number of spectral counts represented in color scale (default: " + maxSpc + ")", false, false));
        }
    };

    public static void printUsageAndExit() {
        String description = "Peptides2Wig v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar Peptides2Wig.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        int i;
        String line;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            Peptides2Wig.printUsageAndExit();
        }
        File peptideFile = CLIUtils.getFileOption(cli, "pep", false);
        File gffFile = CLIUtils.getFileOption(cli, "gff", false);
        File seqFile = CLIUtils.getFileOption(cli, "seq", false);
        String outputPrefix = cli.getOptionValue("out");
        maxSpc = Integer.parseInt(cli.getOptionValue("max", Integer.toString(maxSpc)));
        File outGffFile = new File(String.valueOf(outputPrefix) + ".gff3");
        Map<String, String> seq = FastaReader.readFile(seqFile, FastaReader.headerComplete);
        System.out.println("read in " + seq.keySet().size() + " chromosome(s)");
        GenomeFeatureSet gfs = new GenomeFeatureSet(gffFile, null, true);
        System.out.println("read in " + gfs.size() + " annotations");
        HashMap<String, Chromosome> wig = new HashMap<String, Chromosome>();
        for (Map.Entry<String, String> e : seq.entrySet()) {
            wig.put(e.getKey(), new Chromosome(e.getValue().length()));
        }
        BufferedReader inPep = Utils.reader(peptideFile);
        List<String> headers = Utils.tabSplit2List(inPep.readLine());
        int i_pepSeq = headers.indexOf("peptide sequence");
        int i_prots = headers.indexOf("proteins");
        int i_pos = headers.indexOf("start pos (all)");
        int i_class = headers.indexOf("peptide class");
        int i_spc = headers.indexOf("total spectra peptide");
        int i_nprots = headers.indexOf("number of proteins");
        int i_mcs = headers.indexOf("missed cleavage sites");
        int i_ntt = headers.indexOf("tryptic termini (1st protein)");
        int i_prevAA = headers.indexOf("previous aa (1st protein)");
        int i_nextAA = headers.indexOf("next aa (1st protein)");
        if (i_pepSeq == -1) {
            i_pepSeq = headers.indexOf("peptide");
        }
        if (i_pos == -1) {
            i_pos = headers.indexOf("positions");
        }
        UOBufferedWriter outGff = new UOBufferedWriter(new FileWriter(outGffFile));
        outGff.writeLine("##gff-version 3");
        String inName = peptideFile.getName();
        outGff.writeLine("#track name=" + inName);
        Splitter protSplitter = Splitter.on(';');
        while ((line = inPep.readLine()) != null) {
            List<String> elems = Utils.tabSplit2List(line);
            String pepSeq = elems.get(i_pepSeq);
            int pepLen = pepSeq.length();
            ArrayList<String> prots = Lists.newArrayList(protSplitter.split(elems.get(i_prots)));
            ArrayList<Integer> pepPos = new ArrayList<Integer>();
            for (String pepPosStr : protSplitter.split(elems.get(i_pos))) {
                if (pepPosStr.length() > 0) {
                    pepPos.add(Integer.parseInt(pepPosStr));
                    continue;
                }
                pepPos.add(null);
            }
            String pepClass = i_class != -1 ? elems.get(i_class) : null;
            Integer spc = i_spc != -1 ? Integer.valueOf(Integer.parseInt(elems.get(i_spc))) : null;
            Integer ntt = i_ntt != -1 ? Integer.valueOf(Integer.parseInt(elems.get(i_ntt))) : null;
            Integer mcs = i_mcs != -1 ? Integer.valueOf(Integer.parseInt(elems.get(i_mcs))) : null;
            String fullSeq = i_prevAA != -1 && i_nextAA != -1 ? String.valueOf(elems.get(i_prevAA)) + "." + pepSeq + "." + elems.get(i_nextAA) : null;
            i = 0;
            while (i < prots.size()) {
                String prot = (String)prots.get(i);
                Integer pos = (Integer)pepPos.get(i);
                GenomeFeature gf = gfs.byId.get(prot);
                if (gf != null) {
                    int from = gf.location.strand == GenomeLocation.Strand.PLUS ? gf.location.from + 3 * (pos - 1) : gf.location.to - 3 * (pos - 1) - pepLen * 3 + 1;
                    int to = gf.location.strand == GenomeLocation.Strand.PLUS ? gf.location.from + 3 * (pos - 1) + pepLen * 3 - 1 : gf.location.to - 3 * (pos - 1);
                    int saturation = spc != null ? Math.round(200.0f * Math.max(0.0f, 1.0f - 1.0f * (float)spc.intValue() / (1.0f * (float)maxSpc))) : 0;
                    LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
                    attributes.put("peptide", pepSeq);
                    attributes.put("spectra", spc);
                    attributes.put("length", pepLen);
                    attributes.put("mcs", mcs);
                    attributes.put("ntt (1st protein)", ntt);
                    attributes.put("seq (1st protein)", fullSeq);
                    attributes.put("class", pepClass);
                    attributes.put("proteins", Joiner.on(',').join(prots));
                    if (pepClass == null) {
                        attributes.put("color", String.valueOf(saturation) + "," + saturation + "," + saturation);
                    } else if (pepClass.equalsIgnoreCase("CLASS1A")) {
                        attributes.put("color", String.valueOf(saturation) + ",255," + saturation);
                    } else if (pepClass.equalsIgnoreCase("CLASS3A")) {
                        attributes.put("color", String.valueOf(saturation) + "," + saturation + ",255");
                    } else {
                        attributes.put("color", "255," + saturation + "," + saturation);
                    }
                    outGff.writeTsvLine(new Object[]{gf.seqId, inName, "peptide", from, to, ".", gf.location.strand, ".", Joiner.on(';').withKeyValueSeparator("=").join(attributes), ""});
                    if (spc != null) {
                        ((Chromosome)wig.get(gf.seqId)).add(gf, from, to, spc);
                    }
                } else {
                    System.out.println("WARN: protein " + prot + " not found!");
                }
                ++i;
            }
        }
        outGff.close();
        if (i_spc != -1) {
            for (Map.Entry e : wig.entrySet()) {
                String chrName = (String)e.getKey();
                Chromosome chr = (Chromosome)e.getValue();
                int maxPlus = Integer.MIN_VALUE;
                int maxMinus = Integer.MIN_VALUE;
                int maxTotal = Integer.MIN_VALUE;
                int i2 = 0;
                while (i2 < chr.ntLen) {
                    maxPlus = Math.max(maxPlus, chr.spcPlus[i2]);
                    maxMinus = Math.max(maxMinus, chr.spcMinus[i2]);
                    maxTotal = Math.max(maxTotal, chr.spcMinus[i2] + chr.spcPlus[i2]);
                    ++i2;
                }
                UOBufferedWriter outWigMinus = new UOBufferedWriter(String.valueOf(outputPrefix) + "." + chrName + ".minus.wig", "\n");
                UOBufferedWriter outWigPlus = new UOBufferedWriter(String.valueOf(outputPrefix) + "." + chrName + ".plus.wig", "\n");
                UOBufferedWriter outWigTotal = new UOBufferedWriter(String.valueOf(outputPrefix) + "." + chrName + ".total.wig", "\n");
                outWigMinus.writeLine("track type=wiggle_0 name=\"spectral count - minus\" graphType=bar scaleType=log viewLimits=0:" + maxMinus);
                outWigMinus.writeLine("fixedStep chrom=" + chrName + " start=1 step=1 span=1");
                outWigTotal.writeLine("track type=wiggle_0 name=\"spectral count - total\" graphType=bar scaleType=log viewLimits=0:" + maxTotal);
                outWigTotal.writeLine("fixedStep chrom=" + chrName + " start=1 step=1 span=1");
                outWigPlus.writeLine("track type=wiggle_0 name=\"spectral count - plus\" graphType=bar scaleType=log viewLimits=0:" + maxPlus);
                outWigPlus.writeLine("fixedStep chrom=" + chrName + " start=1 step=1 span=1");
                i = 0;
                while (i < chr.ntLen) {
                    outWigMinus.writeLine(Integer.toString(chr.spcMinus[i]));
                    outWigPlus.writeLine(Integer.toString(chr.spcPlus[i]));
                    outWigTotal.writeLine(Integer.toString(chr.spcMinus[i] + chr.spcPlus[i]));
                    ++i;
                }
                outWigMinus.close();
                outWigPlus.close();
                outWigTotal.close();
            }
        }
        System.out.println("INFO: done!");
    }

    private static class Chromosome {
        private int[] spcPlus;
        private int[] spcMinus;
        public final int ntLen;

        public Chromosome(int ntLen) {
            this.ntLen = ntLen;
            this.spcPlus = new int[ntLen];
            this.spcMinus = new int[ntLen];
            Arrays.fill(this.spcPlus, 0);
            Arrays.fill(this.spcMinus, 0);
        }

        public void add(GenomeFeature gf, int from, int to, int spc) {
            block3: {
                block2: {
                    if (gf.location.strand != GenomeLocation.Strand.PLUS) break block2;
                    int i = from - 1;
                    while (i < to) {
                        int n = i++;
                        this.spcPlus[n] = this.spcPlus[n] + spc;
                    }
                    break block3;
                }
                if (gf.location.strand != GenomeLocation.Strand.MINUS) break block3;
                int i = from - 1;
                while (i < to) {
                    int n = i++;
                    this.spcMinus[n] = this.spcMinus[n] + spc;
                }
            }
        }
    }
}

