/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.intervaltree;

public class Interval<T>
implements Comparable<Interval<T>> {
    private long start;
    private long end;
    private T data;

    public Interval(long start, long end, T data) {
        this.start = start;
        this.end = end;
        this.data = data;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean contains(long queryPoint) {
        return queryPoint <= this.end && queryPoint >= this.start;
    }

    public boolean contains(Interval<?> other) {
        return other.getStart() >= this.start && other.getEnd() <= this.end;
    }

    public boolean intersects(Interval<?> other) {
        return other.getEnd() >= this.start && other.getStart() <= this.end;
    }

    @Override
    public int compareTo(Interval<T> other) {
        if (this.start < other.getStart()) {
            return -1;
        }
        if (this.start > other.getStart()) {
            return 1;
        }
        if (this.end < other.getEnd()) {
            return -1;
        }
        if (this.end > other.getEnd()) {
            return 1;
        }
        return 0;
    }

    public long length() {
        return this.end - this.start + 1L;
    }

    public long intersectionLength(Interval<?> other) {
        if (this.intersects(other)) {
            return (other.length() + this.length() - Math.abs(other.getEnd() - this.end) - Math.abs(other.getStart() - this.start)) / 2L;
        }
        return 0L;
    }

    public long intersectionLength(long start, long end) {
        return this.intersectionLength(new Interval<Object>(start, end, null));
    }

    public String toString() {
        return String.valueOf(this.start) + "-" + this.end;
    }
}

