/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CountMap<K extends Comparable<K>>
extends HashMap<K, Integer> {
    private static final long serialVersionUID = 7524610799892923206L;
    protected Comparator<Map.Entry<K, Integer>> comparatorAscCounts = new Comparator<Map.Entry<K, Integer>>(){

        @Override
        public int compare(Map.Entry<K, Integer> e1, Map.Entry<K, Integer> e2) {
            return e1.getValue().compareTo(e2.getValue());
        }
    };
    protected Comparator<Map.Entry<K, Integer>> comparatorAscKeys = new Comparator<Map.Entry<K, Integer>>(){

        @Override
        public int compare(Map.Entry<K, Integer> e1, Map.Entry<K, Integer> e2) {
            return ((Comparable)e1.getKey()).compareTo((Comparable)e2.getKey());
        }
    };

    public void increment(K key) {
        this.increment(key, 1);
    }

    public void increment(K key, int by) {
        if (this.containsKey(key)) {
            this.put(key, (Integer)this.get(key) + by);
        } else {
            this.put(key, by);
        }
    }

    public int getCounts(K key) {
        if (this.containsKey(key)) {
            return (Integer)this.get(key);
        }
        return 0;
    }

    public Collection<Map.Entry<K, Integer>> entrySetAscendingKeys() {
        ArrayList<Map.Entry<K, Integer>> entries = new ArrayList<Map.Entry<K, Integer>>(this.entrySet());
        Collections.sort(entries, this.comparatorAscKeys);
        return entries;
    }

    public Collection<Map.Entry<K, Integer>> entrySetAscendingCounts() {
        ArrayList<Map.Entry<K, Integer>> entries = new ArrayList<Map.Entry<K, Integer>>(this.entrySet());
        Collections.sort(entries, this.comparatorAscCounts);
        return entries;
    }

    public Collection<Map.Entry<K, Integer>> entrySetDescendingCounts() {
        ArrayList<Map.Entry<K, Integer>> entries = new ArrayList<Map.Entry<K, Integer>>(this.entrySet());
        Collections.sort(entries, Collections.reverseOrder(this.comparatorAscCounts));
        return entries;
    }
}

