/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import iptgxdb.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProteomicsUtils {
    public static List<String> cleaveSequence(String seq, String cleavagePattern, String variants) {
        if (variants == null) {
            return ProteomicsUtils.cleaveSequence(seq, cleavagePattern);
        }
        List<String> origPeps = ProteomicsUtils.cleaveSequence(seq, cleavagePattern);
        LinkedList<String> varPeps = new LinkedList<String>();
        for (String variant : Splitter.on(CharMatcher.anyOf(")(")).omitEmptyStrings().split(variants)) {
            String[] v = Utils.splitToArray(variant, Splitter.on('|'));
            int from = Integer.parseInt(v[0]);
            int to = Integer.parseInt(v[1]);
            String var = v[2];
            if (to > seq.length()) {
                System.out.println("WARN: variant (" + variant + ") out of protein sequence (length=" + seq.length() + ")");
                continue;
            }
            if (var.equals("-")) {
                var = "";
            }
            String seqNew = String.valueOf(seq.substring(0, from - 1)) + var + seq.substring(to);
            seqNew = Utils.substringUpTo(seqNew, "*");
            List<String> newPeps = ProteomicsUtils.cleaveSequence(seqNew, cleavagePattern);
            int i = 0;
            while (i < origPeps.size() && i < newPeps.size() && origPeps.get(i).equals(newPeps.get(i))) {
                ++i;
            }
            int j = 0;
            while (j < origPeps.size() && j < newPeps.size() && origPeps.get(origPeps.size() - 1 - j).equals(newPeps.get(newPeps.size() - 1 - j))) {
                ++j;
            }
            if (i >= newPeps.size() - j) continue;
            varPeps.addAll(newPeps.subList(i, newPeps.size() - j));
        }
        origPeps.addAll(varPeps);
        return origPeps;
    }

    public static List<String> cleaveSequence(String seq, String cleavagePattern) {
        Pattern pattern = Pattern.compile(cleavagePattern);
        boolean maxMC = false;
        ArrayList<String> peps = new ArrayList<String>();
        if (seq.length() == 0) {
            return peps;
        }
        Matcher m = pattern.matcher(seq);
        LinkedList<Integer> starts = new LinkedList<Integer>();
        starts.addFirst(0);
        while (m.find((Integer)starts.getFirst())) {
            int cleavageSite = m.end();
            if (m.groupCount() == 1) {
                cleavageSite = m.end(1);
            }
            int mc = 0;
            Iterator iterator = starts.iterator();
            while (iterator.hasNext()) {
                int start = (Integer)iterator.next();
                peps.add(seq.substring(start, cleavageSite));
                ++mc;
            }
            if (starts.size() == 1) {
                starts.removeLast();
            }
            starts.addFirst(cleavageSite);
        }
        int mc = 0;
        Iterator iterator = starts.iterator();
        while (iterator.hasNext()) {
            int start = (Integer)iterator.next();
            if (start >= seq.length()) continue;
            peps.add(seq.substring(start));
            ++mc;
        }
        return peps;
    }
}

