/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public boolean containsEntry(Object var1, Object var2);

    public boolean put(K var1, V var2);

    public boolean remove(Object var1, Object var2);

    public boolean putAll(K var1, Iterable<? extends V> var2);

    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    public Collection<V> replaceValues(K var1, Iterable<? extends V> var2);

    public Collection<V> removeAll(Object var1);

    public void clear();

    public Collection<V> get(K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(Object var1);

    public int hashCode();
}

