/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import iptgxdb.converter.AConverter;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class GenBank2GFF
extends AConverter {
    @Override
    protected void convert_internal(File inputFile) throws Exception {
        String line;
        BufferedReader in = Utils.reader(inputFile);
        List<String> consideredTypes = Arrays.asList("CDS", "gene");
        String idTag = "locus_tag";
        String currSeqId = null;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("LOCUS")) {
                if (this.seqId != null) {
                    currSeqId = this.seqId;
                    continue;
                }
                currSeqId = Iterators.get(Splitter.on(CharMatcher.WHITESPACE).omitEmptyStrings().split(line).iterator(), 1);
                continue;
            }
            if (!line.startsWith("FEATURES")) continue;
            String currFeature = null;
            LinkedHashMap<String, String> attributes = null;
            String currAttribute = null;
            String currValue = null;
            line = in.readLine();
            while (true) {
                String prefix = line.substring(5, 21).trim();
                String body = line.substring(21);
                if (prefix.length() > 0) {
                    if (attributes != null && ((String)attributes.get("location")).equals(body)) {
                        attributes.remove("location");
                        if (!currFeature.equalsIgnoreCase("CDS") && !prefix.equalsIgnoreCase("misc_feature")) {
                            currFeature = prefix;
                        }
                    } else {
                        attributes = new LinkedHashMap<String, String>();
                        currFeature = prefix;
                    }
                    currAttribute = "location";
                    currValue = body;
                } else if (body.startsWith("/")) {
                    String[] arr = body.substring(1).split("=");
                    currAttribute = arr[0];
                    currValue = arr.length > 1 ? arr[1] : "true";
                } else {
                    currValue = String.valueOf(currValue) + " " + body;
                }
                line = in.readLine();
                prefix = line.length() > 21 ? line.substring(5, 21).trim() : "";
                String string = body = line.length() > 21 ? line.substring(21) : "";
                if (prefix.length() <= 0 && line.startsWith("     ") && !body.startsWith("/")) continue;
                if (attributes.containsKey(currAttribute)) {
                    if (currAttribute.equalsIgnoreCase("locus_tag") || currAttribute.equalsIgnoreCase("gene")) {
                        if (!((String)attributes.get(currAttribute)).equals(currValue)) {
                            System.out.println("WARN: different " + currAttribute + " values for same location (" + (String)attributes.get("location") + "): " + (String)attributes.get(currAttribute) + " vs. " + currValue);
                        }
                    } else {
                        attributes.put(currAttribute, String.valueOf((String)attributes.get(currAttribute)) + ";" + currValue);
                    }
                } else {
                    attributes.put(currAttribute, currValue);
                }
                if (prefix.length() <= 0 && line.startsWith("     ")) continue;
                if (!(((String)attributes.get("location")).equals(body) || currFeature.equalsIgnoreCase("source") || !this.extensive && !consideredTypes.contains(currFeature) && consideredTypes.size() != 0 || !this.extensive && currFeature.equalsIgnoreCase("gene") && !attributes.containsKey("pseudo"))) {
                    String location = (String)attributes.get("location");
                    if (location.startsWith("join(") || location.startsWith("complement(join(")) {
                        if (!attributes.containsKey("pseudo")) {
                            System.err.println("ERROR: found split non-pseudo feature at " + location);
                        }
                        String[] locationParts = location.substring(location.lastIndexOf(40) + 1, location.indexOf(41)).split(",");
                        int i = 0;
                        while (i < locationParts.length) {
                            if (location.startsWith("complement(")) {
                                locationParts[i] = "complement(" + locationParts[i].trim() + ")";
                            }
                            GenomeFeature gf = new GenomeFeature(currSeqId, this.source, "fCDS", new GenomeLocation(locationParts[i], currSeqId), null, null);
                            gf.setAtt("idRedundancy", String.valueOf(i + 1) + "of" + locationParts.length);
                            if (this.extensive) {
                                gf.atts.putAll(attributes);
                            } else if (attributes.containsKey("pseudo")) {
                                gf.atts.put("pseudo", "true");
                            }
                            if (attributes.containsKey("locus_tag")) {
                                gf.setID((String)attributes.get("locus_tag"));
                            } else if (attributes.containsKey("gene")) {
                                gf.setID((String)attributes.get("gene"));
                            } else if (attributes.containsKey("ID")) {
                                gf.setID((String)attributes.get("ID"));
                            }
                            this.addGenomeFeature(gf);
                            ++i;
                        }
                    } else {
                        GenomeFeature gf = new GenomeFeature(currSeqId, this.source, currFeature, new GenomeLocation((String)attributes.get("location"), currSeqId), null, null);
                        if (this.extensive) {
                            gf.atts.putAll(attributes);
                        } else if (attributes.containsKey("pseudo")) {
                            gf.atts.put("pseudo", "true");
                        }
                        if (attributes.containsKey("locus_tag")) {
                            gf.setID((String)attributes.get("locus_tag"));
                        } else if (attributes.containsKey("gene")) {
                            gf.setID((String)attributes.get("gene"));
                        } else if (attributes.containsKey("ID")) {
                            gf.setID((String)attributes.get("ID"));
                        }
                        this.addGenomeFeature(gf);
                    }
                }
                if (!line.startsWith("     ")) break;
            }
        }
        in.close();
    }

    @Override
    protected Color getColor() {
        return Color.BLUE;
    }
}

