/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.converter.AConverter;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;

public class RepSeek2GFF
extends AConverter {
    @Override
    protected Color getColor() {
        return Color.BLUE.darker();
    }

    @Override
    protected void convert_internal(File inputFile) throws Exception {
        String line;
        BufferedReader in = Utils.reader(inputFile);
        double maxR = Double.MIN_VALUE;
        int stopPos = Integer.MIN_VALUE;
        Integer startPos = null;
        File fOutGffNew = new File(this.fOut.getParent(), String.valueOf(this.fOut.getName().substring(0, this.fOut.getName().lastIndexOf(46))) + ".connected.gff3");
        UOBufferedWriter outGffNew = new UOBufferedWriter(fOutGffNew);
        outGffNew.writeLine("##gff-version 3");
        outGffNew.writeLine("#track name=\"long repeats\" color=128,128,128");
        int dir = 0;
        int inv = 0;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("TableR")) {
                int splitPos1 = line.indexOf(32);
                int splitPos2 = line.indexOf(32, splitPos1 + 1);
                int pos = Integer.valueOf(line.substring(splitPos1 + 1, splitPos2));
                double r = Double.valueOf(line.substring(splitPos2 + 1));
                maxR = Math.max(maxR, r);
                if (startPos == null) {
                    startPos = pos;
                } else if (pos != stopPos + 1) {
                    GenomeLocation loc = new GenomeLocation(startPos, stopPos, null);
                    GenomeFeature gf = new GenomeFeature(this.seqId, this.source, "repeat_region", loc, "repeat-region", false);
                    gf.setAtt("start", "" + startPos);
                    gf.setAtt("stop", "" + stopPos);
                    gf.setAtt("length", "" + (stopPos - startPos + 1));
                    this.addGenomeFeature(gf);
                    startPos = pos;
                }
                stopPos = pos;
                continue;
            }
            if (!line.startsWith("d") && !line.startsWith("i")) continue;
            String[] arr = line.split("\t");
            int from1 = Integer.parseInt(arr[1]);
            int from2 = Integer.parseInt(arr[2]);
            int len = Integer.parseInt(arr[3]);
            if (line.startsWith("d")) {
                outGffNew.writeTsvLine(this.seqId, this.source, "exon", from1, from1 + len, ".", "+", ".", "Parent=directRepeat" + ++dir + ";length=" + len, "");
                outGffNew.writeTsvLine(this.seqId, this.source, "exon", from2, from2 + len, ".", "+", ".", "Parent=directRepeat" + dir + ";length=" + len, "");
                continue;
            }
            if (!line.startsWith("i")) continue;
            outGffNew.writeTsvLine(this.seqId, this.source, "exon", from1, from1 + len, ".", "+", ".", "Parent=invertedRepeat" + ++inv + ";length=" + len, "");
            outGffNew.writeTsvLine(this.seqId, this.source, "exon", from2, from2 + len, ".", "-", ".", "Parent=invertedRepeat" + inv + ";length=" + len, "");
        }
        if (startPos != null) {
            GenomeLocation loc = new GenomeLocation(startPos, stopPos, null);
            GenomeFeature gf = new GenomeFeature(this.seqId, this.source, "repeat_region", loc, "repeat-region", false);
            gf.setAtt("start", "" + startPos);
            gf.setAtt("stop", "" + stopPos);
            gf.setAtt("length", "" + (stopPos - startPos + 1));
            this.addGenomeFeature(gf);
        }
        in.close();
        outGffNew.close();
        File fOutWig = new File(this.fOut.getParent(), String.valueOf(this.fOut.getName().substring(0, this.fOut.getName().lastIndexOf(46))) + ".wig");
        UOBufferedWriter outWig = new UOBufferedWriter(fOutWig, "\n");
        outWig.writeLine("track type=wiggle_0 name=\"" + inputFile.getName() + "\" graphType=chart scaleType=log viewLimits=0:" + maxR);
        outWig.writeLine("fixedStep chrom=" + this.seqId + " start=1 step=1 span=1");
        in = Utils.reader(inputFile);
        int prevPos = 0;
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("TableR")) continue;
            int splitPos1 = line.indexOf(32);
            int splitPos2 = line.indexOf(32, splitPos1 + 1);
            int pos = Integer.valueOf(line.substring(splitPos1 + 1, splitPos2));
            double r = Double.valueOf(line.substring(splitPos2 + 1));
            int i = prevPos + 1;
            while (i < pos) {
                outWig.writeLine("1");
                ++i;
            }
            outWig.writeLine("" + r);
            prevPos = pos;
        }
        in.close();
        outWig.close();
    }
}

