/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeFeatureSet;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.GenomicsUtil;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Util;
import iptgxdb.utils.Utils;
import iptgxdb.utils.Version;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GffCombiner {
    static int minProteinLength = 6;
    static boolean outputPseudoProteins = false;
    static boolean readPseudo = true;
    static String enzyme = "([KR])([^P])";
    static boolean fullSeq = false;
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("id", "prefix", "the ID prefix for the organism used", true, false));
            this.addOption(CLIUtils.createArgOption("seq", "input", "the input sequence", true, false));
            this.addOption(CLIUtils.createArgOption("gff", "output", "the output gff file", true, false));
            this.addOption(CLIUtils.createArgOption("tsv", "output", "the output matching table", true, false));
            this.addOption(CLIUtils.createArgOption("fasta", "output", "the output protein database", true, false));
            this.addOption(CLIUtils.createArgOption("tab", "output", "a tab-separated output file with sequences per entry", false, false));
            this.addOption(CLIUtils.createArgOption("extend", "e", "get extension for all features 3' and 5' by <e> nucleotides in tabular output file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.REFSEQ.tag, "input", "the input refseq annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.ENSEMBL.tag, "input", "the input ensembl annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.GENOSCOPE.tag, "input", "the input genoscope annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.CHEMGENOME.tag, "input", "the input chemgenome annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.PRODIGAL.tag, "input", "the input Prodigal annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.REF.tag, "tag input", "input generic annotation gff3 file", false, true));
            this.addOption(CLIUtils.createArgOption(GenomeFeatureSet.AnnotationSource.ORF.tag, "input", "the input in-silico annotation gff3 file", false, false));
            this.addOption(CLIUtils.createArgOption("enz", "pattern", "cleavage pattern of the restriction enzyme (default: '" + enzyme + "')", false, false));
            this.addOption(CLIUtils.createArgOption("min", "length", "the minimum protein length in aa for export in protein database (default: " + minProteinLength + ")", false, false));
            this.addOption("pseudoproteins", false, "also write pseudo entries to the protein database");
            this.addOption("nopseudo", false, "ignore pseudo entries completely");
            this.addOption("fullseq", false, "output full protein sequence for extension/reduction entries");
        }
    };

    public static void printUsageAndExit() {
        String description = "Gff genome annotation combiner v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar GffCombiner.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        File fOutFasta;
        File fOutTsv;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-id", "BH", "-seq", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/NC_005956.fasta", "-gff", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/x.gff3", "-tsv", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/x.tsv", "-fasta", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/x.fasta", "-tab", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/x.tab.tsv", "-refseq", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/refseq/NC_005956_2015.proteins+pseudo.gff3", "-ref", "RS13", "-ref", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/refseq/NC_005956_2013.proteins+pseudo.gff3", "-ens", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/ensembl/Bartonella_henselae_str_houston_1.GCA_000046705.1.30.proteins+pseudo.gff3", "-geno", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/genoscope/bh.genoscope__20160309.proteins+pseudo.gff3", "-chemg", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/chemgenome/bh.chemgenome.gff3", "-prod", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/prokka_NC_005956.pDT024/NC_005956.pDT024_prodigal.gff3", "-orf", "/home/bioinf/bioinf_data/33_omul/projects/bartonella_henselae/annotations/insilico/NC_005956.pDT024.orfs_min18aa_laa.gff3", "-min", "6"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            GffCombiner.printUsageAndExit();
        }
        try {
            CLIUtils.validateOptions(cli);
        }
        catch (InvalidParameterException e) {
            System.out.println(e.getMessage());
            GffCombiner.printUsageAndExit();
        }
        GenomeFeatureSet.AnnotationSource.prefix = cli.getOptionValue("id");
        minProteinLength = Integer.parseInt(cli.getOptionValue("min", String.valueOf(minProteinLength)));
        enzyme = cli.getOptionValue("enz", enzyme);
        outputPseudoProteins = cli.hasOption("pseudoproteins");
        readPseudo = !cli.hasOption("nopseudo");
        fullSeq = cli.hasOption("fullseq");
        File fInSeq = new File(cli.getOptionValue("seq"));
        File fOutGFF = new File(cli.getOptionValue("gff"));
        if (fOutGFF.exists()) {
            System.err.println("ERROR: " + fOutGFF.getName() + " already exists.");
            System.exit(0);
        }
        if ((fOutTsv = new File(cli.getOptionValue("tsv"))).exists()) {
            System.err.println("ERROR: " + fOutTsv.getName() + " already exists.");
            System.exit(0);
        }
        if ((fOutFasta = new File(cli.getOptionValue("fasta"))).exists()) {
            System.err.println("ERROR: " + fOutFasta.getName() + " already exists.");
            System.exit(0);
        }
        File fTab = CLIUtils.getFileOption(cli, "tab", true);
        Integer extend = Integer.valueOf(cli.getOptionValue("extend", "0"));
        System.out.println("INFO: loading sequence...");
        Map<String, String> fastaMap = FastaReader.readFile(fInSeq, FastaReader.headerUpToFirstWhitespace);
        HashMap<String, StringBuilder> fastaForward = new HashMap<String, StringBuilder>();
        HashMap<String, StringBuilder> fastaReversed = new HashMap<String, StringBuilder>();
        for (Map.Entry<String, String> e : fastaMap.entrySet()) {
            fastaForward.put(e.getKey(), new StringBuilder(e.getValue()));
            fastaReversed.put(e.getKey(), GenomicsUtil.reverseNucleotides(e.getValue()));
        }
        boolean hasMultiChromosomes = fastaForward.size() > 1;
        System.out.println("INFO: loading sequence - done!");
        ArrayList<GenomeFeatureSet> featureSets = new ArrayList<GenomeFeatureSet>();
        Option[] optionArray = cli.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option opt = optionArray[n2];
            GenomeFeatureSet.AnnotationSource[] annotationSourceArray = GenomeFeatureSet.AnnotationSource.values();
            int n3 = annotationSourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GenomeFeatureSet.AnnotationSource as = annotationSourceArray[n4];
                if (opt.getOpt().equals(as.tag)) {
                    if (opt.getOpt().equals(GenomeFeatureSet.AnnotationSource.REF.tag)) {
                        String[] values = opt.getValues();
                        File fIn = new File(values[1]);
                        System.out.println("INFO: reading in Other reference feature set from '" + fIn.getName() + "'...");
                        featureSets.add(new GenomeFeatureSet(fIn, as, values[0], readPseudo));
                        System.out.println("INFO: reading in Other reference feature set from '" + fIn.getName() + "' - done!");
                    } else {
                        File fIn = new File(cli.getOptionValue(as.tag));
                        System.out.println("INFO: reading in '" + as.defaultName + "' feature set from '" + fIn.getName() + "'...");
                        featureSets.add(new GenomeFeatureSet(fIn, as, readPseudo));
                        System.out.println("INFO: reading in '" + as.defaultName + "' feature set from '" + fIn.getName() + "' - done!");
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (featureSets.size() == 0) {
            System.err.println("ERROR: no feature sets loaded");
            GffCombiner.printUsageAndExit();
        }
        UOBufferedWriter outGFF = new UOBufferedWriter(new FileWriter(fOutGFF));
        outGFF.writeLine(GenomicsUtil.createGFFheader("combined", null));
        System.out.println("INFO: matching feature sets...");
        UOBufferedWriter outTsv = new UOBufferedWriter(new FileWriter(fOutTsv));
        UOBufferedWriter outFasta = new UOBufferedWriter(new FileWriter(fOutFasta));
        ArrayList<String> tableHeaders = new ArrayList<String>(Arrays.asList("chromosome", "end", "stopCodon"));
        for (GenomeFeatureSet gfs : featureSets) {
            String name = gfs.name;
            tableHeaders.addAll(Arrays.asList(String.valueOf(name) + " ID", String.valueOf(name) + " start", String.valueOf(name) + " length (nt)", String.valueOf(name) + " type", String.valueOf(name) + " pseudo", String.valueOf(name) + " startCodon"));
        }
        tableHeaders.add("mapped IDs");
        outTsv.writeLine(Util.join(tableHeaders, "\t"));
        UOBufferedWriter outTab = null;
        if (fTab != null) {
            outTab = new UOBufferedWriter(fTab);
            outTab.writeTsvLine("id", "source", "pseudo", "chromosome", "from", "to", "strand", "startCodon", "stopCodon", "is in fasta", "sequence", extend + "nt upstream", extend + "nt downstream");
        }
        HashMap<String, Integer> c_entries = new HashMap<String, Integer>();
        HashMap<String, Integer> c_clusters = new HashMap<String, Integer>();
        HashMap<String, Integer> c_newClusters = new HashMap<String, Integer>();
        HashMap<String, Integer> c_newReductions = new HashMap<String, Integer>();
        HashMap<String, Integer> c_newExtensions = new HashMap<String, Integer>();
        int c_totalFASTAs = 0;
        int c_tooShortProteins = 0;
        int c_excludedPseudoProteins = 0;
        int c_redundantInternalStarts = 0;
        TreeSet<GenomeLocation> allEndPositions = new TreeSet<GenomeLocation>();
        for (GenomeFeatureSet gfs : featureSets) {
            allEndPositions.addAll(gfs.byEndPosition.keySet());
            c_entries.put(gfs.name, gfs.size());
            c_clusters.put(gfs.name, gfs.byEndPosition.size());
            c_newClusters.put(gfs.name, 0);
            c_newReductions.put(gfs.name, 0);
            c_newExtensions.put(gfs.name, 0);
        }
        for (GenomeLocation endLoc : allEndPositions) {
            StringBuilder seqForward = (StringBuilder)fastaForward.get(endLoc.chromosome);
            StringBuilder seqReverse = (StringBuilder)fastaReversed.get(endLoc.chromosome);
            ArrayList<String> outElements = new ArrayList<String>();
            outElements.add(endLoc.chromosome);
            Integer signedEnd = endLoc.getSignedEnd();
            outElements.add(signedEnd.toString());
            String stopCodon = "";
            stopCodon = signedEnd < 0 ? seqReverse.substring(seqForward.length() + 1 + signedEnd - 3, seqForward.length() + 1 + signedEnd) : seqForward.substring(signedEnd - 3, signedEnd).toUpperCase();
            outElements.add(stopCodon);
            LinkedHashMap<GenomeLocation, GenomeFeature> mappedFeatures = new LinkedHashMap<GenomeLocation, GenomeFeature>();
            String referenceId = null;
            Integer referenceLength = null;
            for (GenomeFeatureSet gfs : featureSets) {
                if (gfs.byEndPosition.containsKey(endLoc)) {
                    SortedSet gffs = (SortedSet)gfs.byEndPosition.get(endLoc);
                    GenomeFeature gffMain = (GenomeFeature)gffs.first();
                    outElements.add(gffMain.getID());
                    outElements.add(String.valueOf(gffMain.location.getSignedStart()));
                    outElements.add(String.valueOf(gffMain.location.length()));
                    outElements.add(gffMain.type);
                    outElements.add(gffMain.getAtt("pseudo", ""));
                    outElements.add(gffMain.location.getSequence(seqForward).substring(0, 3));
                    for (GenomeFeature gff : gffs) {
                        if (mappedFeatures.isEmpty()) {
                            referenceId = gfs.generateId(gff, false);
                            referenceLength = gff.location.length();
                            GenomeFeature mappedGff = new GenomeFeature(gff.seqId, gff.source, gff.type, gff.location, referenceId, Boolean.valueOf(gff.getAtt("pseudo")));
                            for (Map.Entry att : gff.atts.entrySet()) {
                                mappedGff.setAtt(String.valueOf(gfs.name) + "_" + (String)att.getKey(), (String)att.getValue());
                            }
                            mappedGff.setAtt(String.valueOf(gfs.name) + "_type", gff.type);
                            mappedGff.setColor(gfs.annotationSource.color);
                            mappedFeatures.put(gff.location, mappedGff);
                            c_newClusters.put(gfs.name, (Integer)c_newClusters.get(gfs.name) + 1);
                            continue;
                        }
                        if (mappedFeatures.containsKey(gff.location)) {
                            GenomeFeature mappedGff = (GenomeFeature)mappedFeatures.get(gff.location);
                            if (!gfs.annotationSource.extensionsOnly) {
                                mappedGff.setID(String.valueOf(mappedGff.getID()) + "|" + gfs.generateId(gff, true));
                                for (Map.Entry att : gff.atts.entrySet()) {
                                    mappedGff.setAtt(String.valueOf(gfs.name) + "_" + (String)att.getKey(), (String)att.getValue());
                                }
                                mappedGff.setAtt(String.valueOf(gfs.name) + "_type", gff.type);
                                if (!mappedGff.type.equals(gff.type)) {
                                    mappedGff.type = "mixedType";
                                }
                                if (!mappedGff.source.equals(gff.source)) {
                                    mappedGff.source = "mixedSource";
                                }
                                mappedGff.setColor(Color.GRAY.darker());
                            }
                            if (mappedGff.getAtt("pseudo").equals(gff.getAtt("pseudo"))) continue;
                            mappedGff.setAtt("pseudo", "mixed");
                            continue;
                        }
                        int diff = gff.location.length() - referenceLength;
                        GenomeFeature refGff = (GenomeFeature)mappedFeatures.values().iterator().next();
                        if (gfs.annotationSource.extensionsOnly && diff <= 0 && (!refGff.getAtt("pseudo").equals("true") || !gfs.annotationSource.extensionsOnly || diff >= 0)) continue;
                        String id = String.valueOf(referenceId) + "_" + Utils.signedString(diff / 3) + "aa" + "_" + gfs.generateId(gff, true);
                        GenomeFeature mappedGff = new GenomeFeature(gff.seqId, gff.source, gff.type, gff.location, id, Boolean.valueOf(gff.getAtt("pseudo")));
                        for (Map.Entry att : gff.atts.entrySet()) {
                            mappedGff.setAtt(String.valueOf(gfs.name) + "_" + (String)att.getKey(), (String)att.getValue());
                        }
                        mappedGff.setAtt(String.valueOf(gfs.name) + "_type", gff.type);
                        mappedGff.setAtt("extensionOf", referenceId);
                        mappedGff.setAtt("extensionBy", String.valueOf(Utils.signedString(diff)) + "nt");
                        mappedGff.setColor(gfs.annotationSource.color);
                        mappedFeatures.put(gff.location, mappedGff);
                        if (diff > 0) {
                            c_newExtensions.put(gfs.name, (Integer)c_newExtensions.get(gfs.name) + 1);
                        } else if (diff < 0) {
                            c_newReductions.put(gfs.name, (Integer)c_newReductions.get(gfs.name) + 1);
                        }
                        if (gfs.annotationSource.extensionsOnly) continue;
                        refGff.setID(String.valueOf(refGff.getID()) + "|" + Utils.signedString(diff / 3) + "aa" + "_" + gfs.generateId(gff, true));
                    }
                    continue;
                }
                outElements.addAll(Arrays.asList("", "", "", "", "", ""));
            }
            Integer firstFullSequenceOutputLocationLength = null;
            for (Map.Entry mappedFeature : mappedFeatures.entrySet()) {
                GenomeFeature gff;
                GenomeLocation loc = (GenomeLocation)mappedFeature.getKey();
                gff = (GenomeFeature)mappedFeature.getValue();
                String seqNT = loc.getSequence(seqForward);
                String startC = seqNT.substring(0, 3);
                String stopC = seqNT.substring(seqNT.length() - seqNT.length() % 3 - 3, seqNT.length() - seqNT.length() % 3);
                StringBuilder seqAA = GenomicsUtil.translate(seqNT);
                seqAA.setCharAt(0, 'M');
                boolean nostopWarning = false;
                if (seqAA.charAt(seqAA.length() - 1) == '*') {
                    seqAA.deleteCharAt(seqAA.length() - 1);
                } else {
                    nostopWarning = true;
                }
                String lenAA = String.valueOf(seqAA.length());
                String strChromosome = hasMultiChromosomes ? String.valueOf(loc.chromosome) + "_" : String.valueOf(loc.chromosome) + "_";
                String fullTag = String.valueOf(gff.getID()) + "|" + strChromosome + loc.getStart() + "_" + loc.getEnd() + "_" + Utils.signedString(loc.getFrame(seqForward.length())) + "_" + startC + "_" + lenAA;
                gff.setID(fullTag);
                outElements.add(fullTag);
                outGFF.writeLine(gff.toGFFentry());
                String fastaOutputStatus = null;
                if (!outputPseudoProteins && gff.getAtt("pseudo").equals("true")) {
                    System.out.println("INFO: no fasta output for all-pseudo entry " + fullTag);
                    ++c_excludedPseudoProteins;
                    fastaOutputStatus = "no - all pseudo entry";
                } else {
                    if (firstFullSequenceOutputLocationLength == null) {
                        firstFullSequenceOutputLocationLength = loc.length();
                    }
                    if (nostopWarning) {
                        System.out.println("WARN: no stop codon for " + fullTag);
                    }
                    if (seqAA.indexOf("*") > 0) {
                        System.out.println("WARN: " + Util.countChar(seqAA, '*') + " internal stop codon(s) for " + fullTag);
                        seqAA.setLength(seqAA.indexOf("*"));
                    }
                    String processedAA = null;
                    int diffAA = loc.length() / 3 - firstFullSequenceOutputLocationLength / 3;
                    if (diffAA > 0) {
                        Util.rx(seqAA, enzyme);
                        processedAA = seqAA.length() > diffAA && Util.rxMatcher.find(diffAA - 1) ? seqAA.substring(0, Util.rxMatcher.end(1)) : seqAA.toString();
                    } else if (diffAA < 0) {
                        if (!seqNT.startsWith("ATG")) {
                            Util.rx(seqAA, enzyme);
                            processedAA = Util.rxMatcher.find(0) ? seqAA.substring(0, Util.rxMatcher.end(1)) : seqAA.toString();
                        } else {
                            ++c_redundantInternalStarts;
                            fastaOutputStatus = "no - indistinguishable internal start site of longer entry";
                        }
                    } else {
                        processedAA = seqAA.toString();
                    }
                    if (processedAA != null) {
                        if (processedAA.length() >= minProteinLength) {
                            outFasta.writeLine(">" + fullTag + Util.nl + (fullSeq ? seqAA : processedAA));
                            ++c_totalFASTAs;
                            fastaOutputStatus = "yes";
                        } else {
                            ++c_tooShortProteins;
                            fastaOutputStatus = "no - too short";
                        }
                    }
                }
                if (outTab == null) continue;
                GenomeLocation upstream = null;
                GenomeLocation downstream = null;
                if (extend > 0) {
                    if (gff.location.strand == GenomeLocation.Strand.PLUS) {
                        if (gff.location.from > 1) {
                            upstream = new GenomeLocation(Math.max(gff.location.from - extend, 1), gff.location.from - 1, gff.location.strand, gff.location.chromosome);
                        }
                        downstream = new GenomeLocation(gff.location.to + 1, gff.location.to + extend, gff.location.strand, gff.location.chromosome);
                    } else if (gff.location.strand == GenomeLocation.Strand.MINUS) {
                        upstream = new GenomeLocation(gff.location.to + 1, gff.location.to + extend, gff.location.strand, gff.location.chromosome);
                        downstream = new GenomeLocation(gff.location.from - extend, gff.location.from - 1, gff.location.strand, gff.location.chromosome);
                    }
                }
                outTab.writeTsvLine(new Object[]{gff.getID(), gff.source, gff.getAtt("pseudo"), gff.location.chromosome, gff.location.from, gff.location.to, gff.location.strand, startC, stopC, fastaOutputStatus, gff.location.getSequence(seqForward), upstream != null ? upstream.getSequence(seqForward) : "", downstream != null ? downstream.getSequence(seqForward) : ""});
            }
            outTsv.writeLine(Util.join(outElements, "\t"));
        }
        System.out.println("INFO: matching feature sets - done!");
        System.out.println("");
        System.out.println("Summary:");
        System.out.println("name\tannotations\tclusters\tnew clusters\tnew reductions\tnew extensions\ttotal clusters\ttotal ids");
        int c_totalClusters = 0;
        int c_totalIDs = 0;
        for (GenomeFeatureSet gfs : featureSets) {
            System.out.println(String.valueOf(gfs.name) + " (" + gfs.annotationSource.tag + ")" + "\t" + c_entries.get(gfs.name) + "\t" + c_clusters.get(gfs.name) + "\t" + c_newClusters.get(gfs.name) + "\t" + c_newReductions.get(gfs.name) + "\t" + c_newExtensions.get(gfs.name) + "\t" + (c_totalClusters += ((Integer)c_newClusters.get(gfs.name)).intValue()) + "\t" + (c_totalIDs += (Integer)c_newClusters.get(gfs.name) + (Integer)c_newReductions.get(gfs.name) + (Integer)c_newExtensions.get(gfs.name)));
        }
        System.out.println("Generated protein database with " + c_totalFASTAs + " proteins.");
        System.out.println(String.valueOf(c_tooShortProteins) + " proteins were smaller than " + minProteinLength + " aa and excluded.");
        if (c_excludedPseudoProteins > 0) {
            System.out.println(String.valueOf(c_excludedPseudoProteins) + " entries were all-pseudo annotated and excluded from the protein database.");
        }
        if (c_redundantInternalStarts > 0) {
            System.out.println(String.valueOf(c_redundantInternalStarts) + " entries were indistinguishable internal start sites and excluded from the protein database.");
        }
        outTsv.close();
        outGFF.close();
        outFasta.close();
        if (outTab != null) {
            outTab.close();
        }
    }
}

