/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class PeptideClassifier {
    static BufferedWriter out = new BufferedWriter(new PrintWriter(System.out));
    String interactCSVFile;
    String geneProteinFile;
    String fastaAnalysisFile;
    String decoyPrefix;
    String contPrefix;
    Map<String, String> proteinGeneMap = new HashMap<String, String>();
    Map<String, Integer> geneCountMap = new HashMap<String, Integer>();
    Map<String, Integer> fastaAnalysisMap = new HashMap<String, Integer>();

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"/home/bioinf/bioinf_data/30_vaad/peptideClassifier/proteins2peptides.tsv", "/home/bioinf/bioinf_data/30_vaad/peptideClassifier/Gene_Protein_Map_TAIR10", "/home/bioinf/bioinf_data/30_vaad/peptideClassifier/distinct_accessions_arabidopsis_tair10", "Decoy", "Contaminant"};
            out = new BufferedWriter(new FileWriter("distinct_accessions_arabidopsis_tair10/tair10.peptides.classified.tsv"));
        }
        if (args.length != 4) {
            PeptideClassifier.displayHelp("PeptideClassifier");
        } else {
            PeptideClassifier pc = new PeptideClassifier(args[0], args[1], args[2], args[3], args[4]);
            pc.parseAndClassify();
            out.close();
        }
    }

    public String getInteractCSVFile() {
        return this.interactCSVFile;
    }

    public void setInteractCSVFile(String interactCSVFile) {
        this.interactCSVFile = interactCSVFile;
    }

    public String getGeneProteinFile() {
        return this.geneProteinFile;
    }

    public void setGeneProteinFile(String geneProteinFile) {
        this.geneProteinFile = geneProteinFile;
    }

    public String getFastaAnalysisFile() {
        return this.fastaAnalysisFile;
    }

    public void setFastaAnalysisFile(String fastaAnalysisFile) {
        this.fastaAnalysisFile = fastaAnalysisFile;
    }

    public PeptideClassifier(String interactCSVFile, String geneProteinFile, String fastaAnalysisFile, String decoyPrefix, String contPrefix) {
        this.setInteractCSVFile(interactCSVFile);
        this.setGeneProteinFile(geneProteinFile);
        this.setFastaAnalysisFile(fastaAnalysisFile);
        this.decoyPrefix = decoyPrefix;
        this.contPrefix = contPrefix;
    }

    public static void displayHelp(String name) {
        String buffer = "";
        buffer = String.valueOf(buffer) + name + " by Ermir Qeli <ermir.qeli@molbio.uzh.ch>\n";
        buffer = String.valueOf(buffer) + "Usage: " + name + " <parsed_pepxml_file> <Gene_Protein_Mapping_File> <FastaAnalysis_Result_File> <DecoyPrefix> <ContPrefix>\n";
        System.out.print(buffer);
        System.exit(1);
    }

    public void parseAndClassify() {
        Vector<String> alternativeProteins = new Vector<String>();
        Vector<String> currentGeneModels = new Vector<String>();
        if (!(this.interactCSVFile == null || this.interactCSVFile.equals("") || this.geneProteinFile == null || this.geneProteinFile.equals("") || this.fastaAnalysisFile == null || this.fastaAnalysisFile.equals(""))) {
            try {
                int delimiterIndex;
                String tempStr;
                FileReader fin = new FileReader(this.geneProteinFile);
                BufferedReader bin = new BufferedReader(fin);
                while ((tempStr = bin.readLine()) != null) {
                    delimiterIndex = tempStr.indexOf(9);
                    String proteinID = tempStr.substring(delimiterIndex + 1);
                    String geneID = tempStr.substring(0, delimiterIndex);
                    this.proteinGeneMap.put(proteinID, geneID);
                    if (!this.geneCountMap.containsKey(geneID)) {
                        this.geneCountMap.put(geneID, new Integer(1));
                        continue;
                    }
                    int countP = this.geneCountMap.get(geneID);
                    this.geneCountMap.put(geneID, countP + 1);
                }
                fin = new FileReader(this.fastaAnalysisFile);
                bin = new BufferedReader(fin);
                while ((tempStr = bin.readLine()) != null) {
                    this.fastaAnalysisMap.put(tempStr, 1);
                }
                fin = new FileReader(this.interactCSVFile);
                bin = new BufferedReader(fin);
                while ((tempStr = bin.readLine()) != null) {
                    int countP;
                    String geneModel;
                    delimiterIndex = tempStr.indexOf(9);
                    StringTokenizer st = new StringTokenizer(tempStr.substring(0, delimiterIndex), ",");
                    alternativeProteins.removeAllElements();
                    currentGeneModels.removeAllElements();
                    while (st.hasMoreTokens()) {
                        String currentProtein = st.nextToken();
                        String geneModel2 = this.proteinGeneMap.get(currentProtein);
                        if (!alternativeProteins.contains(currentProtein)) {
                            alternativeProteins.addElement(currentProtein);
                        }
                        if (currentGeneModels.contains(geneModel2)) continue;
                        currentGeneModels.addElement(geneModel2);
                    }
                    Collections.sort(alternativeProteins, new AccessionComparator());
                    String sortedProteins = (String)alternativeProteins.elementAt(0);
                    int i = 1;
                    while (i < alternativeProteins.size()) {
                        sortedProteins = String.valueOf(sortedProteins) + "," + (String)alternativeProteins.elementAt(i);
                        ++i;
                    }
                    String peptideClass = "";
                    if (tempStr.startsWith(this.decoyPrefix)) {
                        peptideClass = "REV";
                    } else if (tempStr.startsWith(this.contPrefix)) {
                        peptideClass = "CONT";
                    } else if (alternativeProteins.size() == 1) {
                        peptideClass = "1a";
                    } else if (this.fastaAnalysisMap.containsKey(sortedProteins)) {
                        if (currentGeneModels.size() == 1) {
                            peptideClass = "1b";
                            geneModel = (String)currentGeneModels.elementAt(0);
                            countP = this.geneCountMap.get(geneModel);
                            if (countP != alternativeProteins.size()) {
                                peptideClass = "2a";
                            }
                        } else {
                            peptideClass = "3a";
                        }
                    } else if (currentGeneModels.size() > 1) {
                        peptideClass = "3b";
                    } else {
                        peptideClass = "2a";
                        geneModel = (String)currentGeneModels.elementAt(0);
                        countP = this.geneCountMap.get(geneModel);
                        if (countP == alternativeProteins.size()) {
                            peptideClass = "2b";
                        }
                    }
                    out.write(String.valueOf(tempStr) + "\t" + peptideClass + "\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class AccessionComparator
    implements Comparator {
        AccessionComparator() {
        }

        public int compare(Object aa, Object bb) {
            String a = (String)aa;
            String b = (String)bb;
            int idx1_2 = a.indexOf("-");
            int idx2_2 = b.indexOf("-");
            if (idx1_2 == -1 || idx2_2 == -1) {
                return a.compareTo(b);
            }
            if (a.length() == b.length()) {
                return a.compareTo(b);
            }
            if (!a.startsWith("CG") || !b.startsWith("CG")) {
                return a.compareTo(b);
            }
            int middlepart_a = Integer.parseInt(a.substring(2, idx1_2));
            String suffix_a = a.substring(idx1_2 + 1);
            int middlepart_b = Integer.parseInt(b.substring(2, idx2_2));
            String suffix_b = b.substring(idx2_2 + 1);
            if (middlepart_a == middlepart_b) {
                return suffix_a.compareTo(suffix_b);
            }
            return middlepart_a == middlepart_b ? 0 : (middlepart_a < middlepart_b ? -1 : 1);
        }
    }
}

