/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.UOPeptideClassifier;
import iptgxdb.utils.Utils;
import iptgxdb.utils.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ProteomicsCombiner {
    public static double fdrCutoff = 0.01;
    public static boolean all = false;
    public static boolean noproteinsort = false;
    public static File summaryFile;
    public static Options options;

    static {
        options = new Options(){
            {
                this.addOption(CLIUtils.createArgOption("in", "input files", "processed Mascot results (tsv files)", true, true));
                this.addOption(CLIUtils.createArgOption("out", "output file", "tsv file of peptides with significant PSMs (FDR controlled)", false, false));
                this.addOption(CLIUtils.createArgOption("sig", "method", "set calculation method used for PSM significance: 'ionscore' (default) or 'percolator' (will use q-values) or 'percscore' (will use percolator score) or 'prophet' (for peptide prophet results) or 'msgf' (for msgf results) or 'probabilityBased' (will use the first probability based score that is found)", false, false));
                this.addOption(CLIUtils.createArgOption("fdr", "cutoff", "set false discovery rate on PSM level (default: " + fdrCutoff + ")", false, false));
                this.addOption(CLIUtils.createArgOption("dec", "output file", "tsv file of DECOY peptides with significant PSMs (FDR controlled)", false, false));
                this.addOption(CLIUtils.createArgOption("fasta", "fasta file", "fasta file to classify peptides (currently class 1a,3a,3b only!)", false, false));
                this.addOption(CLIUtils.createArgOption("sum", "output file", "write summary to given file, not on the screen", false, false));
                this.addOption("noproteinsort", false, "do not sort protein ids, use if proteins are already sorted by some means");
                this.addOption("all", false, "print summaries also for all the individual raw files (automatically enabled if only one input file is given)");
            }
        };
    }

    public static void printUsageAndExit() {
        String description = "ProteomicsCombiner v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar ProteomicsCombiner.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-in", "/home/bioinf/bioinf_data/49_scch/Projects/SPP2002_SIHUMI/PTX/single_culture_MSGF/03_msgf/A.c/GelFree/processed.29-07-2019-AC2-GF-F4.tsv.psm", "-all", "-noproteinsort", "-sig", "probabilityBased", "-fdr", "0.001", "-out", "x.tsv", "-sum", "xSum.tsv", "-dec", "xDecoy.tsv", "-fasta", "/home/bioinf/bioinf_data/49_scch/Projects/SPP2002_SIHUMI/PTX/iPtgxDBs/Trypsin/A.c/Acaccae_iPtgxDB_crapome.fasta"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ProteomicsCombiner.printUsageAndExit();
        }
        ArrayList<File> inFiles = new ArrayList<File>();
        String[] stringArray = cli.getOptionValues("in");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strFile = stringArray[n2];
            inFiles.add(new File(strFile));
            ++n2;
        }
        File outFile = null;
        if (cli.hasOption("out") && (outFile = new File(cli.getOptionValue("out"))).exists()) {
            System.err.println("ERROR: " + outFile.getName() + " already exists.");
            System.exit(0);
        }
        File decoyFile = CLIUtils.getFileOption(cli, "dec", true);
        FDRMethod fdrMethod = FDRMethod.ionscore;
        if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("percolator")) {
            fdrMethod = FDRMethod.percolator;
        } else if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("percscore")) {
            fdrMethod = FDRMethod.percscore;
        } else if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("prophet")) {
            fdrMethod = FDRMethod.prophet;
        } else if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("msgf")) {
            fdrMethod = FDRMethod.msgf;
        } else if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("msgf_pnnl")) {
            fdrMethod = FDRMethod.msgf_pnnl;
        } else if (cli.hasOption("sig") && cli.getOptionValue("sig").equalsIgnoreCase("probabilityBased")) {
            fdrMethod = FDRMethod.probabilityBased;
        }
        fdrCutoff = Double.parseDouble(cli.getOptionValue("fdr", Double.toString(fdrCutoff)));
        File fastaFile = CLIUtils.getFileOption(cli, "fasta", false);
        UOPeptideClassifier peptideClassifier = fastaFile != null ? new UOPeptideClassifier(fastaFile) : null;
        all = cli.hasOption("all");
        if (inFiles.size() == 1) {
            all = true;
        }
        noproteinsort = cli.hasOption("noproteinsort");
        summaryFile = CLIUtils.getFileOption(cli, "sum", true);
        new ProteomicsCombiner(inFiles, outFile, decoyFile, fdrMethod, peptideClassifier);
    }

    public ProteomicsCombiner(List<File> inputFiles, File outPepTable, File outDecoyTable, FDRMethod fdrMethodForPeptideTable, UOPeptideClassifier peptideClassifier) throws Exception {
        ArrayList<String> header;
        String[] headerPeptide;
        UOBufferedWriter out;
        Map<Peptide, PeptideInfo> sigPeptides;
        LinkedHashSet<String> globalVarMods = new LinkedHashSet<String>();
        LinkedHashMap<String, Summary> summaries = new LinkedHashMap<String, Summary>();
        TreeMap<Peptide, Integer> c_totalSpectraPeptide = new TreeMap<Peptide, Integer>();
        TreeMap<Peptide, Integer> c_totalPSMPeptide = new TreeMap<Peptide, Integer>();
        HashMap<SortedSet<String>, Integer> c_totalSpectraProtein = new HashMap<SortedSet<String>, Integer>();
        HashMultimap<SortedSet<String>, String> c_totalPeptideProtein = HashMultimap.create();
        TreeMap<Peptide, Integer> c_totalSpectraPeptideDecoy = new TreeMap<Peptide, Integer>();
        TreeMap<Peptide, Integer> c_totalPSMPeptideDecoy = new TreeMap<Peptide, Integer>();
        HashMap<SortedSet<String>, Integer> c_totalSpectraProteinDecoy = new HashMap<SortedSet<String>, Integer>();
        HashMultimap<SortedSet<String>, String> c_totalPeptideProteinDecoy = HashMultimap.create();
        ArrayList<List<String>> outCols = new ArrayList<List<String>>();
        outCols.add(new ArrayList<String>(Arrays.asList("filename", "raw files", "spectra", "queries", "queries assigned target", "queries assigned decoy", String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - threshold", String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - spectra", String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - PSMs")));
        MascotSummary totalSummary = null;
        for (File file : inputFiles) {
            PeptideInfo pi;
            String string;
            System.out.println("INFO: reading file " + file.getName() + "...");
            BufferedReader in = Utils.reader(file);
            String string2 = in.readLine();
            List<String> headers = Arrays.asList(string2.split("\t"));
            MascotSummary fileSummary = null;
            int i_rawFile = headers.indexOf("query source");
            if (totalSummary == null) {
                totalSummary = new MascotSummary(fdrMethodForPeptideTable, false);
            }
            if (i_rawFile == -1 && (fdrMethodForPeptideTable.equals((Object)FDRMethod.percolator) || fdrMethodForPeptideTable.equals((Object)FDRMethod.percscore))) {
                throw new Exception("the tsv file (processed mascot file) is in the old format. please reprocess the dat files using MascotParser.jar");
            }
            fileSummary = new MascotSummary(headers, fdrMethodForPeptideTable, true);
            TreeMap<String, MascotSummary> currentSummaries = new TreeMap<String, MascotSummary>();
            currentSummaries.put("all", fileSummary);
            ((Summary)totalSummary).setHeaders(headers);
            while ((string = in.readLine()) != null) {
                String[] arr = Utils.splitString(string, "\t");
                ((Summary)totalSummary).addQuery(arr);
                ((Summary)fileSummary).addQuery(arr);
                if (!all || i_rawFile == -1) continue;
                if (!currentSummaries.containsKey(arr[i_rawFile])) {
                    currentSummaries.put(arr[i_rawFile], new MascotSummary(headers, fdrMethodForPeptideTable, false));
                }
                ((Summary)currentSummaries.get(arr[i_rawFile])).addQuery(arr);
            }
            if (file.equals(inputFiles.get(inputFiles.size() - 1))) {
                currentSummaries.put("total", totalSummary);
            }
            ArrayList currentSummaryNames = new ArrayList(currentSummaries.keySet());
            currentSummaryNames.remove("all");
            currentSummaryNames.add(0, "all");
            for (String rawFile : currentSummaryNames) {
                Summary s = (Summary)currentSummaries.get(rawFile);
                String filename = file.getName();
                int outColInd = outCols.size();
                if (rawFile.equals("total")) {
                    if (inputFiles.size() == 1) continue;
                    filename = "total";
                    outColInd = 1;
                }
                String summaryname = String.valueOf(filename) + " - " + rawFile;
                System.out.println("INFO: compiling peptide summary '" + summaryname + "'");
                outCols.add(outColInd, Utils.stringList("", filename, rawFile, s.c_spectra, s.c_queries, Utils.formatValAndPercent(s.c_queries_assigned_target, s.c_queries), Utils.formatValAndPercent(s.c_queries_assigned_decoy, s.c_queries), Utils.format(s.getScoreThreshold(), "#.#####"), Utils.formatValAndPercent(s.get_c_spectra_sig(), s.c_spectra), Utils.formatValAndPercent(s.get_c_psm_sig(), s.c_queries_assigned_target)));
                ((List)outCols.get(outColInd)).addAll(Utils.stringList("", s.c_sigpeptides, Utils.formatValAndPercent(s.c_sigpeptides_unique, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_0tt, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_1tt, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_2tt, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_0mcs, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_1mcs, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_2mcs, s.c_sigpeptides), Utils.formatValAndPercent(s.c_sigpeptides_3orMore_mcs, s.c_sigpeptides), s.c_sigpeptidesDecoy, Utils.formatPercent(s.c_sigpeptidesDecoy, s.c_sigpeptides)));
                Map<String, HashSet<String>> c_sigmodSites = s.c_sigmodSites;
                globalVarMods.addAll(s.varMods);
                for (String varMod : globalVarMods) {
                    if (c_sigmodSites.containsKey(varMod)) {
                        ((List)outCols.get(outColInd)).add("" + c_sigmodSites.get(varMod).size());
                        continue;
                    }
                    ((List)outCols.get(outColInd)).add("");
                }
                if (rawFile.equals("total")) continue;
                summaries.put(summaryname, s);
            }
            sigPeptides = fileSummary.peptidesSig;
            Map<Peptide, PeptideInfo> sigPeptidesDecoy = fileSummary.peptidesSigDecoy;
            for (Map.Entry<Peptide, PeptideInfo> e : sigPeptides.entrySet()) {
                Peptide pep = e.getKey();
                pi = e.getValue();
                if (!c_totalSpectraPeptide.containsKey(pep)) {
                    c_totalSpectraPeptide.put(pep, pi.c_spectra);
                } else {
                    c_totalSpectraPeptide.put(pep, (Integer)c_totalSpectraPeptide.get(pep) + pi.c_spectra);
                }
                if (!c_totalPSMPeptide.containsKey(pep)) {
                    c_totalPSMPeptide.put(pep, pi.c_psm);
                } else {
                    c_totalPSMPeptide.put(pep, (Integer)c_totalPSMPeptide.get(pep) + pi.c_psm);
                }
                if (!c_totalSpectraProtein.containsKey(pep.proteinSet)) {
                    c_totalSpectraProtein.put(pep.proteinSet, pi.c_spectra);
                } else {
                    c_totalSpectraProtein.put(pep.proteinSet, (Integer)c_totalSpectraProtein.get(pep.proteinSet) + pi.c_spectra);
                }
                c_totalPeptideProtein.put(pep.proteinSet, pep.sequence);
            }
            for (Map.Entry<Peptide, PeptideInfo> e : sigPeptidesDecoy.entrySet()) {
                Peptide pep = e.getKey();
                pi = e.getValue();
                if (!c_totalSpectraPeptideDecoy.containsKey(pep)) {
                    c_totalSpectraPeptideDecoy.put(pep, pi.c_spectra);
                } else {
                    c_totalSpectraPeptideDecoy.put(pep, (Integer)c_totalSpectraPeptideDecoy.get(pep) + pi.c_spectra);
                }
                if (!c_totalPSMPeptideDecoy.containsKey(pep)) {
                    c_totalPSMPeptideDecoy.put(pep, pi.c_psm);
                } else {
                    c_totalPSMPeptideDecoy.put(pep, (Integer)c_totalPSMPeptideDecoy.get(pep) + pi.c_psm);
                }
                if (!c_totalSpectraProteinDecoy.containsKey(pep.proteinSet)) {
                    c_totalSpectraProteinDecoy.put(pep.proteinSet, pi.c_spectra);
                } else {
                    c_totalSpectraProteinDecoy.put(pep.proteinSet, (Integer)c_totalSpectraProteinDecoy.get(pep.proteinSet) + pi.c_spectra);
                }
                c_totalPeptideProteinDecoy.put(pep.proteinSet, pep.sequence);
            }
        }
        System.out.println("INFO: writing summary table...");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 1 protein");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 0 tryptic termini");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 1 tryptic termini");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 2 tryptic termini");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 0 missed cleavage sites");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 1 missed cleavage sites");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 2 missed cleavage sites");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides with 3 or more missed cleavage sites");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptides decoy");
        ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - peptide level FDR");
        for (String varMod : globalVarMods) {
            ((List)outCols.get(0)).add(String.valueOf(fdrCutoff * 100.0) + "% FDR " + (Object)((Object)fdrMethodForPeptideTable) + " - count " + varMod + " sites");
        }
        if (summaryFile != null) {
            BufferedWriter summary = new BufferedWriter(new FileWriter(summaryFile));
            summary.write(Utils.joinToColumns(outCols, "\t", ""));
            summary.close();
        } else {
            System.out.println(Utils.joinToColumns(outCols, "\t", ""));
        }
        if (outPepTable != null) {
            System.out.println("INFO: writing peptide table...");
            out = new UOBufferedWriter(new FileWriter(outPepTable));
            headerPeptide = new String[]{"peptide sequence", "missed cleavage sites", "number of proteins", "proteins", "tryptic termini (1st protein)", "start pos (1st protein)", "start pos (all)", "previous aa (1st protein)", "next aa (1st protein)", "n-term class", "c-term class", "peptide class"};
            header = new ArrayList<String>(Arrays.asList(headerPeptide));
            header.add("total spectra peptide");
            header.add("total PSM peptide");
            header.add("total peptides protein");
            header.add("total spectra protein");
            for (String string : summaries.keySet()) {
                header.add(String.valueOf(string) + " - spectra");
            }
            for (String string : summaries.keySet()) {
                header.add(String.valueOf(string) + " - psms");
            }
            out.writeLine(Utils.join(header, "\t"));
            for (Peptide peptide : c_totalSpectraPeptide.keySet()) {
                UOPeptideClassifier.PeptideClass pepClass = null;
                if (peptideClassifier != null) {
                    pepClass = peptideClassifier.classify(peptide.proteinSet);
                }
                ArrayList<Object> o = new ArrayList<Object>();
                o.addAll(Arrays.asList(new Serializable[]{peptide.sequence, Integer.valueOf(peptide.mcs), Integer.valueOf(peptide.c_proteins), peptide.getProteinString(), Integer.valueOf(peptide.ntt), peptide.startPos, peptide.startPosAll, Character.valueOf(peptide.ntermAA), Character.valueOf(peptide.ctermAA), peptide.ntermClass, peptide.ctermClass, pepClass, (Serializable)c_totalSpectraPeptide.get(peptide), (Serializable)c_totalPSMPeptide.get(peptide), Integer.valueOf(c_totalPeptideProtein.get(peptide.proteinSet).size()), (Serializable)c_totalSpectraProtein.get(peptide.proteinSet)}));
                for (Summary s : summaries.values()) {
                    sigPeptides = s.peptidesSig;
                    if (sigPeptides.containsKey(peptide)) {
                        PeptideInfo pi = sigPeptides.get(peptide);
                        o.add(pi.c_spectra);
                        continue;
                    }
                    int i = 0;
                    while (i < 1) {
                        o.add("");
                        ++i;
                    }
                }
                for (Summary s : summaries.values()) {
                    sigPeptides = s.peptidesSig;
                    if (sigPeptides.containsKey(peptide)) {
                        o.add(sigPeptides.get((Object)peptide).c_psm);
                        continue;
                    }
                    o.add("");
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
        }
        if (outDecoyTable != null) {
            out = new UOBufferedWriter(new FileWriter(outDecoyTable));
            headerPeptide = new String[]{"peptide sequence", "missed cleavage sites", "number of proteins", "proteins", "tryptic termini (1st protein)"};
            header = new ArrayList<String>(Arrays.asList(headerPeptide));
            header.add("total spectra peptide");
            header.add("total PSM peptide");
            header.add("total peptides protein");
            header.add("total spectra protein");
            for (String string : summaries.keySet()) {
                header.add(String.valueOf(string) + " - spectra");
            }
            for (String string : summaries.keySet()) {
                header.add(String.valueOf(string) + " - psms");
            }
            out.writeLine(Utils.join(header, "\t"));
            for (Map.Entry entry : c_totalSpectraPeptideDecoy.entrySet()) {
                Map<Peptide, PeptideInfo> sigPeptidesDecoy;
                Peptide pep = (Peptide)entry.getKey();
                ArrayList<Object> o = new ArrayList<Object>();
                o.addAll(Arrays.asList(pep.sequence, pep.mcs, pep.c_proteins, pep.getProteinString(), pep.ntt, (Serializable)c_totalSpectraPeptideDecoy.get(pep), (Serializable)c_totalPSMPeptideDecoy.get(pep), c_totalPeptideProteinDecoy.get(pep.proteinSet).size(), (Serializable)c_totalSpectraProteinDecoy.get(pep.proteinSet)));
                for (Summary s : summaries.values()) {
                    sigPeptidesDecoy = s.peptidesSigDecoy;
                    if (sigPeptidesDecoy.containsKey(pep)) {
                        PeptideInfo pi = sigPeptidesDecoy.get(pep);
                        o.add(pi.c_spectra);
                        continue;
                    }
                    o.add("");
                }
                for (Summary s : summaries.values()) {
                    sigPeptidesDecoy = s.peptidesSigDecoy;
                    if (sigPeptidesDecoy.containsKey(pep)) {
                        o.add(sigPeptidesDecoy.get((Object)pep).c_psm);
                        continue;
                    }
                    o.add("");
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
        }
        System.out.println("INFO: done!");
    }

    public static enum FDRMethod {
        ionscore,
        percolator,
        percscore,
        prophet,
        msgf,
        msgf_pnnl,
        probabilityBased;

    }

    public static class MascotSummary
    extends Summary {
        int i_ntt;
        int i_pepseq;
        int i_startpos;
        int i_mcs;
        int i_prots;
        int i_cprots;
        int i_qspectra;
        int i_ionscore;
        int i_ionscoreDecoy;
        int i_percscore;
        int i_ionqval;
        int i_ionqvalDecoy;
        int i_percqval;
        int i_percqvalSimple;
        int i_percqvalDecoy;
        int i_percqvalDecoySimple;
        int i_mods;
        int i_pepseqDecoy;
        int i_nttDecoy;
        int i_mcsDecoy;
        int i_protsDecoy;
        int i_cprotsDecoy;
        int i_ntermini;
        int i_ctermini;
        int i_prophetprob;
        int i_prophetprobDecoy;
        int i_prophetqval;
        int i_prophetqvalDecoy;
        int i_msgfprob_pnnl;
        int i_msgfprobDecoy_pnnl;
        int i_msgfqval_pnnl;
        int i_msgfqvalDecoy_pnnl;
        int i_msgfprob;
        int i_msgfprobDecoy;
        int i_msgfqval;
        int i_msgfqvalDecoy;

        public MascotSummary(FDRMethod fdrMethod, boolean reportThresholds) {
            super(fdrMethod, reportThresholds);
        }

        public MascotSummary(List<String> headers, FDRMethod fdrMethod, boolean reportThresholds) {
            super(headers, fdrMethod, reportThresholds);
        }

        @Override
        public void setHeaders(List<String> headers) {
            this.i_ntt = headers.indexOf("psm tryptic termini");
            this.i_pepseq = headers.indexOf("psm sequence");
            this.i_startpos = headers.indexOf("psm start positions");
            this.i_mcs = headers.indexOf("psm missed cleavage sites");
            this.i_prots = headers.indexOf("psm proteins");
            this.i_cprots = headers.indexOf("psm count proteins");
            this.i_qspectra = headers.indexOf("query scans");
            this.i_ionscore = headers.indexOf("psm ionscore");
            this.i_ionscoreDecoy = headers.indexOf("psm decoy ionscore");
            this.i_percscore = headers.indexOf("psm percolatorscore");
            this.i_ionqval = headers.indexOf("psm qvalue");
            this.i_ionqvalDecoy = headers.indexOf("psm decoy qvalue");
            this.i_percqval = headers.indexOf("psm percolator qvalue");
            this.i_percqvalSimple = headers.indexOf("psm percolator qvalue simple");
            this.i_percqvalDecoy = headers.indexOf("psm decoy percolator qvalue");
            this.i_percqvalDecoySimple = headers.indexOf("psm decoy percolator qvalue simple");
            this.i_mods = headers.indexOf("psm modifications");
            this.i_pepseqDecoy = headers.indexOf("psm decoy sequence");
            this.i_nttDecoy = headers.indexOf("psm decoy ntt");
            this.i_mcsDecoy = headers.indexOf("psm decoy mcs");
            this.i_protsDecoy = headers.indexOf("psm decoy proteins");
            this.i_cprotsDecoy = headers.indexOf("psm decoy count proteins");
            this.i_ntermini = headers.indexOf("psm n-termini");
            this.i_ctermini = headers.indexOf("psm c-termini");
            this.i_prophetprob = headers.indexOf("psm prophet prob");
            this.i_prophetprobDecoy = headers.indexOf("psm decoy prophet prob");
            this.i_prophetqval = headers.indexOf("psm prophet qvalue");
            this.i_prophetqvalDecoy = headers.indexOf("psm decoy prophet qvalue");
            this.i_msgfprob_pnnl = headers.indexOf("psm msgf score");
            this.i_msgfprobDecoy_pnnl = headers.indexOf("psm decoy msgf score");
            this.i_msgfqval_pnnl = headers.indexOf("psm msgf qvalue");
            this.i_msgfqvalDecoy_pnnl = headers.indexOf("psm decoy msgf qvalue");
            this.i_msgfprob = headers.indexOf("psm msgfSpecProb score");
            this.i_msgfprobDecoy = headers.indexOf("psm decoy msgfSpecProb score");
            this.i_msgfqval = headers.indexOf("psm msgfSpecProb qvalue");
            this.i_msgfqvalDecoy = headers.indexOf("psm decoy msgfSpecProb qvalue");
        }

        @Override
        public void addQuery(String[] arr) {
            PeptideInfo pepInfo;
            Peptide pep;
            this.c_spectra = this.c_spectra + Integer.parseInt(arr[this.i_qspectra]);
            this.c_queries = this.c_queries + 1;
            if (this.i_ionscore >= 0) {
                if (arr[this.i_ionscore].length() > 0) {
                    this.c_queries_assigned_target = this.c_queries_assigned_target + 1;
                }
                if (arr[this.i_ionscoreDecoy].length() > 0) {
                    this.c_queries_assigned_decoy = this.c_queries_assigned_decoy + 1;
                }
            } else if (this.i_pepseq >= 0) {
                if (arr[this.i_pepseq].length() > 0) {
                    this.c_queries_assigned_target = this.c_queries_assigned_target + 1;
                }
                if (arr[this.i_pepseqDecoy].length() > 0) {
                    this.c_queries_assigned_decoy = this.c_queries_assigned_decoy + 1;
                }
            }
            String score = null;
            String qval = null;
            String qvalDecoy = null;
            FDRMethod selectedFDRmethod = this.fdrMethod;
            if (selectedFDRmethod == FDRMethod.probabilityBased) {
                if (this.i_percscore >= 0) {
                    selectedFDRmethod = FDRMethod.percolator;
                } else if (this.i_prophetprob >= 0) {
                    selectedFDRmethod = FDRMethod.prophet;
                } else if (this.i_msgfprob >= 0) {
                    selectedFDRmethod = FDRMethod.msgf;
                } else if (this.i_msgfprob_pnnl >= 0) {
                    selectedFDRmethod = FDRMethod.msgf_pnnl;
                } else {
                    System.err.println("no suitable probability score found...");
                    return;
                }
            }
            if (selectedFDRmethod == FDRMethod.ionscore) {
                score = arr[this.i_ionscore];
                qval = arr[this.i_ionqval];
                qvalDecoy = arr[this.i_ionqvalDecoy];
            } else if (selectedFDRmethod == FDRMethod.percolator) {
                score = arr[this.i_percscore];
                qval = arr[this.i_percqval];
                qvalDecoy = arr[this.i_percqvalDecoy];
            } else if (selectedFDRmethod == FDRMethod.percscore) {
                score = arr[this.i_percscore];
                qval = arr[this.i_percqvalSimple];
                qvalDecoy = arr[this.i_percqvalDecoySimple];
            } else if (selectedFDRmethod == FDRMethod.prophet) {
                score = arr[this.i_prophetprob];
                qval = arr[this.i_prophetqval];
                qvalDecoy = arr[this.i_prophetqvalDecoy];
            } else if (selectedFDRmethod == FDRMethod.msgf) {
                score = arr[this.i_msgfprob];
                qval = arr[this.i_msgfqval];
                qvalDecoy = arr[this.i_msgfqvalDecoy];
            } else if (selectedFDRmethod == FDRMethod.msgf_pnnl) {
                score = arr[this.i_msgfprob_pnnl];
                qval = arr[this.i_msgfqval_pnnl];
                qvalDecoy = arr[this.i_msgfqvalDecoy_pnnl];
            }
            if (qval.length() > 0 && Double.parseDouble(qval) <= fdrCutoff) {
                this.c_psm_sig = this.c_psm_sig + 1;
                this.c_spectra_sig = this.c_spectra_sig + Integer.parseInt(arr[this.i_qspectra]);
                this.scoreThreshold = Math.min(this.scoreThreshold, Double.parseDouble(score));
                pep = new Peptide(arr[this.i_pepseq], Integer.parseInt(arr[this.i_mcs]), arr[this.i_prots], Integer.parseInt(arr[this.i_cprots]), arr[this.i_ntt], arr[this.i_startpos], arr[this.i_ntermini], arr[this.i_ctermini]);
                if (!this.peptidesSig.containsKey(pep)) {
                    this.peptidesSig.put(pep, new PeptideInfo());
                    ++this.c_sigpeptides;
                    if (arr[this.i_cprots].equals("1")) {
                        ++this.c_sigpeptides_unique;
                    }
                    switch (Integer.parseInt(arr[this.i_mcs])) {
                        case 0: {
                            ++this.c_sigpeptides_0mcs;
                            break;
                        }
                        case 1: {
                            ++this.c_sigpeptides_1mcs;
                            break;
                        }
                        case 2: {
                            ++this.c_sigpeptides_2mcs;
                            break;
                        }
                        default: {
                            if (Integer.parseInt(arr[this.i_mcs]) >= 3) {
                                ++this.c_sigpeptides_3orMore_mcs;
                                break;
                            }
                            System.err.println("unkown mcs info: " + Utils.join("\t", arr));
                        }
                    }
                    switch (pep.ntt) {
                        case 0: {
                            ++this.c_sigpeptides_0tt;
                            break;
                        }
                        case 1: {
                            ++this.c_sigpeptides_1tt;
                            break;
                        }
                        case 2: {
                            ++this.c_sigpeptides_2tt;
                            break;
                        }
                        default: {
                            System.err.println("unkown ntt info: " + Utils.join("\t", arr));
                        }
                    }
                }
                if (arr[this.i_mods].length() > 0) {
                    String[] stringArray = arr[this.i_mods].split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String e = stringArray[n2];
                        String pos = e.split(":")[0];
                        String mod = e.split(":")[1];
                        this.varMods.add(mod);
                        if (!this.c_sigmodSites.containsKey(mod)) {
                            this.c_sigmodSites.put(mod, new HashSet());
                        }
                        ((HashSet)this.c_sigmodSites.get(mod)).add(pep.proteinSet + pep.sequence + pos);
                        ++n2;
                    }
                }
                pepInfo = (PeptideInfo)this.peptidesSig.get(pep);
                ++pepInfo.c_psm;
                pepInfo.c_spectra += Integer.parseInt(arr[this.i_qspectra]);
            }
            if (qvalDecoy.length() > 0 && Double.parseDouble(qvalDecoy) <= fdrCutoff) {
                pep = new Peptide(arr[this.i_pepseqDecoy], Integer.parseInt(arr[this.i_mcsDecoy]), arr[this.i_protsDecoy], Integer.parseInt(arr[this.i_cprotsDecoy]), arr[this.i_nttDecoy], null, null, null);
                if (!this.peptidesSigDecoy.containsKey(pep)) {
                    this.peptidesSigDecoy.put(pep, new PeptideInfo());
                    ++this.c_sigpeptidesDecoy;
                }
                pepInfo = (PeptideInfo)this.peptidesSigDecoy.get(pep);
                ++pepInfo.c_psm;
                pepInfo.c_spectra += Integer.parseInt(arr[this.i_qspectra]);
            }
        }
    }

    public static class Peptide
    implements Comparable<Peptide> {
        String sequence;
        int mcs;
        SortedSet<String> proteinSet;
        List<String> proteinList;
        private static Splitter proteinSplitter = Splitter.on(';');
        private static Joiner proteinJoiner = Joiner.on(';');
        int c_proteins;
        int ntt;
        Integer startPos;
        String startPosAll;
        char ntermAA;
        char ctermAA;
        TermClass ntermClass;
        TermClass ctermClass;

        public Peptide(String sequence, int mcs, String proteins, int c_proteins, String ntts, String startPositions, String ntermAAs, String ctermAAs) {
            this.sequence = sequence;
            this.mcs = mcs;
            this.proteinList = Lists.newArrayList(proteinSplitter.split(proteins));
            Comparator<String> cmp = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.startsWith("XXX") && o2.startsWith("XXX")) {
                        return 0;
                    }
                    if (o1.startsWith("XXX")) {
                        return 1;
                    }
                    if (o2.startsWith("XXX")) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            };
            this.proteinSet = Sets.newTreeSet(cmp);
            this.proteinSet.addAll(this.proteinList);
            int firstProteinIndex = 0;
            if (!noproteinsort) {
                firstProteinIndex = this.proteinList.indexOf(this.proteinSet.first());
                Collections.sort(this.proteinList, cmp);
            }
            this.c_proteins = c_proteins;
            this.ntt = ntts.length() > 1 ? Integer.parseInt(Iterables.get(proteinSplitter.split(ntts), firstProteinIndex)) : Integer.parseInt(ntts);
            if (startPositions != null && startPositions.length() > 0) {
                this.startPos = Integer.parseInt(Iterables.get(proteinSplitter.split(startPositions), firstProteinIndex));
                ArrayList<String> startPositionList = Lists.newArrayList(proteinSplitter.split(startPositions));
                if (noproteinsort) {
                    this.startPosAll = proteinJoiner.join(startPositionList);
                } else {
                    ArrayList<String> startPositionListTmp = new ArrayList<String>();
                    ArrayList<String> startPositionListSorted = new ArrayList<String>();
                    ArrayList<String> proteinListOrig = Lists.newArrayList(proteinSplitter.split(proteins));
                    int i = 0;
                    while (i < proteinListOrig.size()) {
                        startPositionListTmp.add(String.valueOf((String)proteinListOrig.get(i)) + " " + (String)startPositionList.get(i));
                        ++i;
                    }
                    Collections.sort(startPositionListTmp, cmp);
                    for (String str : startPositionListTmp) {
                        startPositionListSorted.add(Lists.newArrayList(Splitter.on(' ').split(str)).get(1));
                    }
                    this.startPosAll = proteinJoiner.join(startPositionListSorted);
                }
            } else {
                this.startPos = null;
                this.startPosAll = null;
            }
            if (ntermAAs != null && ctermAAs != null) {
                this.ntermAA = Iterables.get(proteinSplitter.split(ntermAAs), firstProteinIndex).charAt(0);
                this.ctermAA = Iterables.get(proteinSplitter.split(ctermAAs), firstProteinIndex).charAt(0);
                if (this.startPos != null) {
                    this.ntermClass = this.classifyTerm(this.ntermAA, sequence.charAt(0), this.startPos);
                    this.ctermClass = this.classifyTerm(sequence.charAt(sequence.length() - 1), this.ctermAA, -1);
                }
            } else {
                this.ntermAA = (char)45;
                this.ctermAA = (char)45;
            }
        }

        private TermClass classifyTerm(char pre, char post, int position) {
            if (pre == '-' || post == '-') {
                return TermClass.PROTEIN_TERM;
            }
            if (pre == 'M' && position == 2) {
                return TermClass.PROTEIN_TERM_INIT_MET;
            }
            if (pre == 'R' || pre == 'K') {
                if (post == 'P') {
                    return TermClass.TRYPTIC_BEFORE_P;
                }
                return TermClass.TRYPTIC;
            }
            if (post != 'P' && (pre == 'W' && post != 'M' || pre == 'Y' || pre == 'F' || pre == 'L' || pre == 'M' && post != 'Y' || pre == 'H' && post != 'D' && post != 'M' && post != 'W')) {
                if (pre == 'W' || pre == 'Y' || pre == 'F') {
                    return TermClass.CHYMOTRYPTIC;
                }
                return TermClass.CHYMOTRYPTIC_LOW_ONLY;
            }
            return TermClass.UNKOWN;
        }

        public String getProteinString() {
            return proteinJoiner.join(this.proteinList);
        }

        @Override
        public int compareTo(Peptide that) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)proteinJoiner.join(this.proteinSet)), (Comparable<?>)((Object)proteinJoiner.join(that.proteinSet))).compare(this.sequence.length(), that.sequence.length()).compare((Comparable<?>)((Object)this.sequence), (Comparable<?>)((Object)that.sequence)).compare(this.ntermAA, that.ntermAA).compare(this.ctermAA, that.ctermAA).result();
        }

        public int hashCode() {
            return Objects.hashCode(this.c_proteins, this.proteinSet, this.sequence, Character.valueOf(this.ntermAA), Character.valueOf(this.ctermAA));
        }

        public boolean equals(Object obj) {
            if (obj instanceof Peptide) {
                Peptide that = (Peptide)obj;
                return Objects.equal(this.sequence, that.sequence) && this.c_proteins == that.c_proteins && Objects.equal(this.proteinSet, that.proteinSet) && this.ntermAA == that.ntermAA && this.ctermAA == that.ctermAA;
            }
            return false;
        }

        public static enum TermClass {
            PROTEIN_TERM,
            PROTEIN_TERM_INIT_MET,
            TRYPTIC,
            TRYPTIC_BEFORE_P,
            CHYMOTRYPTIC,
            CHYMOTRYPTIC_LOW_ONLY,
            UNKOWN;

        }
    }

    public static class PeptideInfo {
        int c_psm = 0;
        int c_spectra = 0;
    }

    public static abstract class Summary {
        boolean reportThresholds;
        FDRMethod fdrMethod;
        Integer c_spectra = 0;
        Integer c_queries = 0;
        Integer c_queries_assigned_target = 0;
        Integer c_queries_assigned_decoy = 0;
        Integer c_psm_sig = 0;
        Integer c_spectra_sig = 0;
        Double scoreThreshold = Double.MAX_VALUE;
        int c_sigpeptides;
        int c_sigpeptides_unique;
        int c_sigpeptidesDecoy;
        int c_sigpeptides_0tt;
        int c_sigpeptides_1tt;
        int c_sigpeptides_2tt;
        int c_sigpeptides_0mcs;
        int c_sigpeptides_1mcs;
        int c_sigpeptides_2mcs;
        int c_sigpeptides_3orMore_mcs;
        Map<String, HashSet<String>> c_sigmodSites;
        Map<Peptide, PeptideInfo> peptidesSig;
        Map<Peptide, PeptideInfo> peptidesSigDecoy;
        Set<String> varMods;

        public Summary(FDRMethod fdrMethod, boolean reportThresholds) {
            this.reportThresholds = reportThresholds;
            this.fdrMethod = fdrMethod;
            this.peptidesSig = new HashMap<Peptide, PeptideInfo>();
            this.peptidesSigDecoy = new HashMap<Peptide, PeptideInfo>();
            this.c_sigmodSites = new HashMap<String, HashSet<String>>();
            this.varMods = new HashSet<String>();
        }

        public Summary(List<String> headers, FDRMethod fdrMethod, boolean reportThresholds) {
            this(fdrMethod, reportThresholds);
            this.setHeaders(headers);
        }

        public Double getScoreThreshold() {
            return this.scoreThreshold.equals(Double.MAX_VALUE) || !this.reportThresholds ? null : this.scoreThreshold;
        }

        public Integer get_c_psm_sig() {
            return this.scoreThreshold.equals(Double.MAX_VALUE) ? null : this.c_psm_sig;
        }

        public Integer get_c_spectra_sig() {
            return this.scoreThreshold.equals(Double.MAX_VALUE) ? null : this.c_spectra_sig;
        }

        public abstract void setHeaders(List<String> var1);

        public abstract void addQuery(String[] var1);
    }
}

