/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.CountMap;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.QValueCalculator;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import iptgxdb.utils.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ProteomicsParser {
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("dat", "input", "Mascot .dat file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("xls", "input", "PeptideProphet xls file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("xml", "input", "PeptideProphet pep.xml file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("msgf", "input", "MSGF tsv file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("msgfplus", "input", "MSGFplus tsv file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("msgfPNNL", "input", "MSGF tsv file from PNNL (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("index", "input", "to recover the spectrum source for MSGF analysis, you can provide a MGF index file", false, false));
            this.addOption(CLIUtils.createArgOption("pop", "input", "Percolator .pop file (can be gzipped)", false, false));
            this.addOption(CLIUtils.createArgOption("out", "output", "tab-separated-values file", true, false));
            this.addOption(CLIUtils.createArgOption("maxrank", "r", "keep up to rank <r> hits (default: keep all hits)", false, false));
            this.addOption(CLIUtils.createArgOption("decoy", "prefix", "use the protein name prefix <prefix> to identify decoy hits, a separate decoy search will be ignored", false, false));
            this.addOption(CLIUtils.createArgOption("fasta", "input", "the fasta database used for searching, this is only needed for processing PeptideProphet or MSGF files. If supplied for Mascot searches, the peptide sequences will be researched in the database (very slow).", false, false));
            this.addOption("pp", false, "use peptide prophet scores for MSGF files");
        }
    };

    public static void printUsageAndExit() {
        String description = "ProteomicsParser v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar ProteomicsParser.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-fasta", "/home/bioinf/bioinf_data/30_vaad/proteogenomics/Bacillus_subtilis_strain_168/database/iPtgxDB_BSU168_cont_iRT.fasta", "-msgfplus", "/home/bioinf/bioinf_data/30_vaad/proteogenomics/Bacillus_subtilis_strain_168/search_msgf/20ppm_inst1_maxCharge4/180610_VE1_PM4_ToK_SPP_BSubt_intracell_ArgC_a3D.tsv", "-decoy", "XXX", "-out", "/home/bioinf/bioinf_data/proteogenomics/Bacillus_subtilis_strain_168/search_msgf/test.psm"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            ProteomicsParser.printUsageAndExit();
        }
        File popFile = null;
        File outFile = new File(cli.getOptionValue("out"));
        if (cli.hasOption("pop")) {
            popFile = new File(cli.getOptionValue("pop"));
        }
        if (outFile.exists()) {
            System.err.println("ERROR: " + outFile.getName() + " already exists.");
            System.exit(0);
        }
        int maxRank = Integer.parseInt(cli.getOptionValue("maxrank", "0"));
        String decoyPrefix = cli.getOptionValue("decoy", null);
        File fastaFile = CLIUtils.getFileOption(cli, "fasta", false);
        if (cli.hasOption("dat")) {
            File datFile = new File(cli.getOptionValue("dat"));
            new ProteomicsParser(datFile, popFile, outFile, maxRank, decoyPrefix, fastaFile);
        } else if (cli.hasOption("xls")) {
            if (!cli.hasOption("decoy")) {
                System.err.println("you have to specifiy the decoy prefix for PeptideProphet input!");
                ProteomicsParser.printUsageAndExit();
            }
            File xlsFile = new File(cli.getOptionValue("xls"));
            new PeptideProphetParser(xlsFile, outFile, decoyPrefix, fastaFile);
        } else if (cli.hasOption("xml")) {
            File xmlFile = new File(cli.getOptionValue("xml"));
            new PeptideProphetXMLParser(xmlFile, outFile, decoyPrefix, fastaFile);
        } else if (cli.hasOption("msgf")) {
            File msgfFile = new File(cli.getOptionValue("msgf"));
            File indexFile = null;
            if (cli.hasOption("index")) {
                indexFile = new File(cli.getOptionValue("index"));
            }
            new MSGFParser(msgfFile, outFile, fastaFile, indexFile);
        } else if (cli.hasOption("msgfplus")) {
            File msgfplusFile = new File(cli.getOptionValue("msgfplus"));
            new MSGFPlusParser(msgfplusFile, outFile, fastaFile);
        } else if (cli.hasOption("msgfPNNL")) {
            File msgfFile = new File(cli.getOptionValue("msgfPNNL"));
            boolean usePeptideProphet = cli.hasOption("pp");
            new MSGFPNNLParser(msgfFile, outFile, decoyPrefix, fastaFile, usePeptideProphet);
        } else {
            System.err.println("you have to specifiy at least one input file!");
            ProteomicsParser.printUsageAndExit();
        }
    }

    public ProteomicsParser(File inDatFile, File inPopFile, File outQueryFile, int maxRank, String decoyPrefix, File fastaFile) throws Exception {
        int n;
        String line;
        HashMap<String, String> fasta_ItoL = new HashMap<String, String>();
        Map<Object, Object> fasta = new HashMap();
        if (fastaFile != null) {
            fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
            for (Map.Entry<Object, Object> e : fasta.entrySet()) {
                fasta_ItoL.put((String)e.getKey(), ((String)e.getValue()).replace('I', 'L'));
            }
        }
        System.out.println("INFO: starting to read " + inDatFile.getName());
        BufferedReader in = Utils.reader(inDatFile);
        String boundary = null;
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("Content-Type: multipart/mixed; boundary=")) continue;
            boundary = "--" + Utils.substringAfter(line, "=");
            break;
        }
        if (boundary == null) {
            throw new Exception("no boundary found");
        }
        int c_queries = 0;
        boolean hasDecoy = decoyPrefix != null;
        boolean hasErrTol = false;
        String[] varMods = null;
        String jobid = StringUtils.substringBetween(inDatFile.getName(), "__F", ".");
        String date = null;
        Query[] queries = null;
        ArrayList<Double> targetRank1Scores = new ArrayList<Double>();
        ArrayList<Double> decoyRank1Scores = new ArrayList<Double>();
        CountMap<String> rawFileSummary = new CountMap<String>();
        while ((line = in.readLine()) != null) {
            if (line.equals("Content-Type: application/x-Mascot; name=\"parameters\"")) {
                while (!(line = in.readLine()).equals(boundary)) {
                    if (line.equalsIgnoreCase("DECOY=1")) {
                        hasDecoy = true;
                        continue;
                    }
                    if (line.startsWith("IT_MODS=")) {
                        varMods = Utils.splitString(Utils.splitString(line, "=")[1], ",");
                        continue;
                    }
                    if (!line.equalsIgnoreCase("ERRORTOLERANT=")) continue;
                    hasErrTol = true;
                }
                continue;
            }
            if (line.equals("Content-Type: application/x-Mascot; name=\"header\"")) {
                while (!(line = in.readLine()).equals(boundary)) {
                    if (line.startsWith("queries=")) {
                        c_queries = Integer.valueOf(Utils.substringAfter(line, "="));
                    }
                    if (!line.startsWith("date=")) continue;
                    String strDate = StringUtils.substringAfter(line, "=");
                    date = new SimpleDateFormat("yyyyMMdd").format(new Date(Long.parseLong(strDate) * 1000L));
                }
                if (c_queries == 0) {
                    throw new Exception("no queries found");
                }
                queries = new Query[c_queries];
                System.out.println("INFO: parsing results for " + c_queries + " queries");
                continue;
            }
            if (line.equals("Content-Type: application/x-Mascot; name=\"summary\"")) {
                while (!(line = in.readLine()).equals(boundary)) {
                    if (!line.startsWith("qmass")) continue;
                    int queryID = Integer.valueOf(Utils.substringBetween(line, "qmass", "=")) - 1;
                    double mass = Double.parseDouble(Utils.substringAfter(line, "="));
                    Double mz = null;
                    Integer charge = null;
                    Double intensity = null;
                    line = in.readLine();
                    if (line.startsWith("qexp")) {
                        mz = Double.valueOf(Utils.substringBetween(line, "=", ","));
                        if (line.endsWith("+")) {
                            charge = Integer.valueOf(Utils.substringBetween(line, ",", "+"));
                        } else if (line.endsWith("-")) {
                            charge = -Integer.valueOf(Utils.substringBetween(line, ",", "-")).intValue();
                        } else {
                            throw new Exception("unkown charge state in line '" + line + "'");
                        }
                    }
                    if ((line = in.readLine()).startsWith("qintensity")) {
                        intensity = Double.parseDouble(Utils.substringAfter(line, "="));
                    }
                    queries[queryID] = new Query(queryID, mass, mz, charge, intensity);
                }
                continue;
            }
            if (line.equals("Content-Type: application/x-Mascot; name=\"peptides\"") || line.equals("Content-Type: application/x-Mascot; name=\"decoy_peptides\"") || line.equals("Content-Type: application/x-Mascot; name=\"et_peptides\"")) {
                boolean isDecoy = line.endsWith("decoy_peptides\"");
                if (isDecoy && decoyPrefix != null) continue;
                boolean isErrTol = line.endsWith("et_peptides\"");
                line = in.readLine();
                while (!line.equals(boundary)) {
                    PSM psm;
                    if (!line.startsWith("q")) {
                        line = in.readLine();
                        continue;
                    }
                    String[] arr = line.split("=")[0].split("_");
                    int qid = Integer.parseInt(arr[0].substring(1));
                    int rank = Integer.parseInt(arr[1].substring(1));
                    if (maxRank > 0 && rank > maxRank) {
                        line = in.readLine();
                        continue;
                    }
                    if (line.endsWith("=-1")) {
                        line = in.readLine();
                        continue;
                    }
                    String psmPrefix = "q" + qid + "_p" + rank;
                    String termsLine = null;
                    String substLine = null;
                    String psmLine = null;
                    String etmodsLine = null;
                    do {
                        String prefix = line.split("=")[0];
                        String value = line.split("=")[1];
                        if (prefix.endsWith("_db")) continue;
                        if (prefix.endsWith("_terms")) {
                            termsLine = value;
                            continue;
                        }
                        if (prefix.endsWith("_primary_nl")) continue;
                        if (prefix.endsWith("_subst")) {
                            substLine = value;
                            continue;
                        }
                        if (prefix.endsWith("_et_mods")) {
                            etmodsLine = value;
                            continue;
                        }
                        if (prefix.equals(psmPrefix)) {
                            psmLine = value;
                            continue;
                        }
                        System.out.println("WARN: ignored unkown line '" + line + "'");
                    } while ((line = in.readLine()).startsWith(psmPrefix));
                    Query query = queries[qid - 1];
                    if (decoyPrefix != null) {
                        psm = new PSM(psmLine, termsLine, substLine, null, fasta, fasta_ItoL);
                        isDecoy = true;
                        String[] stringArray = psm.proteins;
                        int n2 = psm.proteins.length;
                        n = 0;
                        while (n < n2) {
                            String protein = stringArray[n];
                            if (!protein.startsWith(decoyPrefix)) {
                                isDecoy = false;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (isDecoy) {
                        psm = new PSM(psmLine, termsLine, substLine, null, fasta, fasta_ItoL);
                        query.addDecoyMatch(psm);
                        if (rank != 1) continue;
                        decoyRank1Scores.add(psm.score);
                        continue;
                    }
                    if (isErrTol) {
                        String etMod = etmodsLine != null ? etmodsLine.split(",")[2] : null;
                        PSM psm2 = new PSM(psmLine, termsLine, substLine, etMod, fasta, fasta_ItoL);
                        query.addEtMatch(psm2);
                        continue;
                    }
                    psm = new PSM(psmLine, termsLine, substLine, null, fasta, fasta_ItoL);
                    query.addMatch(psm);
                    if (rank != 1) continue;
                    targetRank1Scores.add(psm.score);
                }
                continue;
            }
            if (!line.startsWith("Content-Type: application/x-Mascot; name=\"query")) continue;
            int q = Integer.parseInt(line.substring(47, line.length() - 1)) - 1;
            while (!(line = in.readLine()).startsWith(boundary)) {
                if (line.startsWith("title=")) {
                    String title = URLDecoder.decode(line, "UTF-8");
                    queries[q].c_scans = Utils.rx(title, "Sum of (\\d+) scans") ? Integer.parseInt(Utils.rxMatcher.group(1)) : 1;
                    if (title.endsWith("]")) {
                        queries[q].rawFile = title.substring(1 + Math.max(title.lastIndexOf(47), title.lastIndexOf(92)), title.length() - 1);
                    } else if (title.startsWith("title=File:")) {
                        queries[q].rawFile = title.substring(11, title.indexOf(" Scans:"));
                    }
                    if (queries[q].rawFile == null) continue;
                    rawFileSummary.increment(queries[q].rawFile);
                    continue;
                }
                if (!line.startsWith("rtinseconds=")) continue;
                String strRt = line.substring(12);
                int sep = strRt.indexOf(45);
                double rt = sep >= 0 ? (Double.parseDouble(strRt.substring(0, sep)) + Double.parseDouble(strRt.substring(sep + 1))) / 2.0 : Double.parseDouble(strRt);
                queries[q].rt = rt;
            }
        }
        in.close();
        int c = 0;
        for (Map.Entry e : rawFileSummary.entrySetAscendingKeys()) {
            System.out.println("  rawfile " + ++c + ": '" + (String)e.getKey() + "' with " + e.getValue() + " queries");
        }
        QValueCalculator qvalCalc = null;
        if (hasDecoy) {
            System.out.println("INFO: calculating q-values");
            qvalCalc = new QValueCalculator(targetRank1Scores, decoyRank1Scores);
        }
        QValueCalculator qvalCalcPercolator = null;
        if (inPopFile != null) {
            System.out.println("INFO: loading percolator results from " + inPopFile.getName());
            ArrayList<Double> targetPercScores = new ArrayList<Double>();
            ArrayList<Double> decoyPercScores = new ArrayList<Double>();
            BufferedReader inPop = Utils.reader(inPopFile);
            boolean isDecoy = false;
            while ((line = inPop.readLine()) != null) {
                if (!line.startsWith("PSMId\t")) continue;
                while ((line = inPop.readLine()).startsWith("query:")) {
                    String[] arr = Utils.splitString(line, "\t");
                    int qid = Integer.parseInt(arr[0].split(";")[0].split(":")[1]) - 1;
                    int rank = Integer.parseInt(arr[0].split(";")[1].split(":")[1]);
                    double score = Double.parseDouble(arr[1]);
                    double qval = Double.parseDouble(arr[2]);
                    double pep = Double.parseDouble(arr[3]);
                    if (rank > 1) {
                        throw new Exception("Only rank 1 percolator hits are allowed!");
                    }
                    if (isDecoy) {
                        queries[qid].percolatorScoreDecoy = score;
                        queries[qid].percolatorQvalDecoy = qval;
                        decoyPercScores.add(score);
                        continue;
                    }
                    String pepSeq = arr[4].replaceAll("\\d", "");
                    if (pepSeq.startsWith("X.") && pepSeq.endsWith(".X")) {
                        pepSeq = pepSeq.substring(2, pepSeq.length() - 2);
                    }
                    pepSeq.equals(queries[qid].matches.get((int)0).sequence);
                    queries[qid].percolatorScoreTarget = score;
                    queries[qid].percolatorPEP = pep;
                    queries[qid].percolatorQval = qval;
                    targetPercScores.add(score);
                }
                isDecoy = true;
            }
            inPop.close();
            System.out.println("INFO: calculating percolator q-values");
            qvalCalcPercolator = new QValueCalculator(targetPercScores, decoyPercScores);
        }
        System.out.println("INFO: writing results to " + outQueryFile.getName());
        UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outQueryFile));
        ArrayList<String> headers = new ArrayList<String>();
        String[] headerQuery = new String[]{"query id", "query source", "query search", "query scans", "query mass", "query charge", "query m/z", "query intensity", "query rt", "psm rank"};
        headers.addAll(Arrays.asList(headerQuery));
        String[] headerPSM = new String[]{"psm sequence", "psm substitutions", "psm missed cleavage sites", "psm count proteins", "psm proteins", "psm n-termini", "psm c-termini", "psm tryptic termini", "psm start positions", "psm modificationString", "psm modifications", "psm mass", "psm delta mass ppm", "psm ionscore", "psm qvalue"};
        headers.addAll(Arrays.asList(headerPSM));
        String[] headerPSMDecoy = new String[]{"psm decoy ionscore", "psm decoy qvalue", "psm decoy mcs", "psm decoy ntt", "psm decoy delta mass ppm", "psm decoy sequence", "psm decoy count proteins", "psm decoy proteins"};
        headers.addAll(Arrays.asList(headerPSMDecoy));
        String[] headerPercolator = new String[]{"psm percolatorscore", "psm percolator pep", "psm percolator qvalue", "psm percolator qvalue simple", "psm decoy percolatorscore", "psm decoy percolator qvalue", "psm decoy percolator qvalue simple"};
        headers.addAll(Arrays.asList(headerPercolator));
        String[] headerErrorTolerant = new String[]{"psm errtol sequence", "psm errtol mcs", "psm errtol proteins", "psm errtol tryptic termini", "psm errtol modificationString", "psm errtol modifications", "psm errtol x-mod", "psm errtol mass", "psm errtol delta mass ppm", "psm errtol ionscore"};
        headers.addAll(Arrays.asList(headerErrorTolerant));
        out.writeLine(Utils.join(headers, "\t"));
        String searchPath = date != null && jobid != null ? String.valueOf(date) + "/F" + jobid + ".dat" : null;
        Query[] queryArray = queries;
        n = queries.length;
        int n3 = 0;
        while (n3 < n) {
            Query q = queryArray[n3];
            int r = 0;
            while (r < Utils.max(1, q.matches.size(), q.decoyMatches.size(), q.etMatches.size())) {
                PSM psm;
                ArrayList<Object> o = new ArrayList<Object>();
                o.add(q.id + 1);
                o.add(q.rawFile);
                o.add(searchPath);
                o.add(q.c_scans);
                o.add(q.mass);
                o.add(q.charge);
                o.add(q.mz);
                o.add(q.intensity);
                o.add(q.rt);
                if (q.matches.size() + q.decoyMatches.size() + q.etMatches.size() > 0) {
                    o.add(r + 1);
                } else {
                    o.add("");
                }
                if (r < q.matches.size()) {
                    psm = q.matches.get(r);
                    o.add(psm.sequence);
                    o.add(psm.substitutions);
                    o.add(psm.mcs);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                    o.add(Utils.join(";", psm.nterms));
                    o.add(Utils.join(";", psm.cterms));
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(Utils.join(";", psm.startPositions));
                    o.add(psm.modificationString);
                    o.add(Utils.join(psm.getModifications(varMods), ";"));
                    o.add(psm.mass);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.score);
                    o.add(qvalCalc != null ? qvalCalc.getQvalue(psm.score) : "");
                } else {
                    int i = 0;
                    while (i < headerPSM.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (r < q.decoyMatches.size()) {
                    psm = q.decoyMatches.get(r);
                    o.add(psm.score);
                    o.add(qvalCalc != null ? qvalCalc.getQvalue(psm.score) : "");
                    o.add(psm.mcs);
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.sequence);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                } else {
                    int i = 0;
                    while (i < headerPSMDecoy.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (r == 0 && inPopFile != null) {
                    o.add(q.percolatorScoreTarget);
                    o.add(q.percolatorPEP);
                    o.add(q.percolatorQval);
                    o.add(qvalCalcPercolator.getQvalue(q.percolatorScoreTarget));
                    o.add(q.percolatorScoreDecoy);
                    o.add(q.percolatorQvalDecoy);
                    o.add(qvalCalcPercolator.getQvalue(q.percolatorScoreDecoy));
                } else {
                    int i = 0;
                    while (i < headerPercolator.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (r < q.etMatches.size()) {
                    PSM psm3 = q.etMatches.get(r);
                    o.add(psm3.sequence);
                    o.add(psm3.mcs);
                    o.add(Utils.join(";", psm3.proteins));
                    o.add(Utils.join(";", psm3.getNTTs()));
                    o.add(psm3.modificationString);
                    o.add(Utils.join(psm3.getModifications(varMods), ";"));
                    o.add(psm3.xMod);
                    o.add(psm3.mass);
                    o.add(psm3.getDeltaMassPPM());
                    o.add(psm3.score);
                } else {
                    int i = 0;
                    while (i < headerErrorTolerant.length) {
                        o.add("");
                        ++i;
                    }
                }
                out.writeLine(Utils.join(o, "\t"));
                ++r;
            }
            ++n3;
        }
        out.close();
        System.out.println("INFO: done!");
    }

    public static class MSGFPNNLParser {
        public MSGFPNNLParser(File inTsvFile, File outQueryFile, String decoyPrefix, File fastaFile, boolean usePepProphetScores) throws Exception {
            int i_prophet;
            Map<String, String> fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
            System.out.println("INFO: starting to read " + inTsvFile.getName());
            BufferedReader in = Utils.reader(inTsvFile);
            ArrayList<Query> queries = new ArrayList<Query>();
            ArrayList<Double> targetProbScores = new ArrayList<Double>();
            ArrayList<Double> decoyProbScores = new ArrayList<Double>();
            String line = in.readLine();
            ArrayList<String> header = Lists.newArrayList(Splitter.on('\t').split(line));
            int i_experiment = header.indexOf("Experiment");
            if (i_experiment == -1) {
                i_experiment = header.indexOf("Dataset_ID");
            }
            int i_scannr = header.indexOf("ScanNum");
            int i_job = header.indexOf("Job");
            int i_prob = header.indexOf("MSGF_SpecProb");
            if (i_prob == -1) {
                i_prob = header.indexOf("SpecProb");
            }
            if ((i_prophet = header.indexOf("PeptideProphet Probability")) == -1) {
                i_prophet = header.indexOf("Expr1");
            }
            int i_peptide = header.indexOf("Peptide");
            int i_protein = header.indexOf("Reference");
            int i_proteinCount = header.indexOf("MultiProtein");
            int i_ntt = header.indexOf("NumTrypticEnds");
            int i_peptidemass = header.indexOf("MH");
            int i_deltam = header.indexOf("DelM");
            if (i_deltam == -1) {
                i_deltam = header.indexOf("DelM_PPM");
            }
            int i_charge = header.indexOf("ChargeState");
            int i_cScans = header.indexOf("ScanCount");
            int i_xcorr = header.indexOf("XCorr");
            int i_passFilt = header.indexOf("PassFilt");
            while ((line = in.readLine()) != null) {
                int passFilt;
                double probScore;
                String[] arr = Iterables.toArray(Splitter.on('\t').split(line), String.class);
                String job = i_job >= 0 ? arr[i_job] : "";
                String experiment = arr[i_experiment];
                int scanNr = Integer.parseInt(arr[i_scannr]);
                if (usePepProphetScores) {
                    if (arr[i_prophet].equals("NULL") || arr[i_prophet].equals("-1")) continue;
                    probScore = Double.parseDouble(arr[i_prophet]);
                } else {
                    if (arr[i_prob].equals("") || arr[i_prob].equals("0")) continue;
                    probScore = -1.0 * Math.log10(Double.parseDouble(arr[i_prob]));
                }
                String pepSeqMod = arr[i_peptide];
                String refProt = arr[i_protein];
                int protCount = Integer.parseInt(arr[i_proteinCount].replace("+", "")) + 1;
                int ntt = Integer.parseInt(arr[i_ntt]);
                double peptidemass = Double.parseDouble(arr[i_peptidemass]);
                double deltam = Double.parseDouble(arr[i_deltam]);
                int charge = Integer.parseInt(arr[i_charge]);
                int cScans = Integer.parseInt(arr[i_cScans]);
                double xcorr = Double.parseDouble(arr[i_xcorr]);
                if (i_passFilt >= 0 && (passFilt = Integer.parseInt(arr[i_passFilt])) == 0) continue;
                double precMass = peptidemass + deltam;
                double mz = precMass / (double)charge;
                Query q = new Query(scanNr, precMass, mz, charge, null);
                q.c_scans = cScans;
                q.rawFile = experiment;
                boolean isDecoy = refProt.startsWith(decoyPrefix);
                String protSeq1 = fasta.get(refProt);
                PSM psm = new PSM(peptidemass, deltam, pepSeqMod, xcorr, protSeq1);
                String[] proteins = new String[]{refProt};
                if (protSeq1 == null) {
                    for (Map.Entry<String, String> e : fasta.entrySet()) {
                        if (!e.getValue().contains(psm.sequence)) continue;
                        proteins = new String[]{e.getKey()};
                        break;
                    }
                    if (proteins[0].equals(refProt)) {
                        System.out.println("WARN: protein '" + refProt + "' not found.");
                    } else {
                        System.out.println("WARN: protein '" + refProt + "' not found, using '" + proteins[0] + "' instead.");
                    }
                    psm = new PSM(peptidemass, deltam, pepSeqMod, xcorr, fasta.get(proteins[0]));
                }
                psm.proteins = proteins;
                if (queries.contains(q)) {
                    q = (Query)queries.get(queries.indexOf(q));
                    PSM savedPSM = null;
                    if (q.matches.size() == 1) {
                        if (isDecoy) continue;
                        savedPSM = q.matches.get(0);
                    } else if (q.decoyMatches.size() == 1) {
                        savedPSM = q.decoyMatches.get(0);
                    } else {
                        throw new Exception();
                    }
                    savedPSM.proteins = ArrayUtils.add(savedPSM.proteins, psm.proteins[0]);
                    savedPSM.startPositions = ArrayUtils.add(savedPSM.startPositions, psm.startPositions[0]);
                    savedPSM.cterms = ArrayUtils.add(savedPSM.cterms, psm.cterms[0]);
                    savedPSM.nterms = ArrayUtils.add(savedPSM.nterms, psm.nterms[0]);
                    continue;
                }
                if (isDecoy) {
                    q.addDecoyMatch(psm);
                    q.probabilityScoreDecoy = probScore;
                    decoyProbScores.add(probScore);
                } else {
                    q.addMatch(psm);
                    q.probabilityScoreTarget = probScore;
                    targetProbScores.add(probScore);
                }
                queries.add(q);
            }
            in.close();
            System.out.println("INFO: calculating q-values");
            QValueCalculator qvalCalcProb = new QValueCalculator(targetProbScores, decoyProbScores);
            System.out.println("INFO: writing results to " + outQueryFile.getName());
            UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outQueryFile));
            ArrayList<String> headers = new ArrayList<String>();
            String[] headerQuery = new String[]{"query source", "query scans", "query mass", "query charge", "query m/z"};
            headers.addAll(Arrays.asList(headerQuery));
            String[] headerPSM = new String[]{"psm sequence", "psm missed cleavage sites", "psm count proteins", "psm proteins", "psm n-termini", "psm c-termini", "psm tryptic termini", "psm start positions", "psm modificationString", "psm modifications", "psm mass", "psm delta mass ppm", usePepProphetScores ? "psm prophet prob" : "psm msgf score", usePepProphetScores ? "psm prophet qvalue" : "psm msgf qvalue"};
            headers.addAll(Arrays.asList(headerPSM));
            String[] headerPSMDecoy = new String[]{usePepProphetScores ? "psm decoy prophet prob" : "psm decoy msgf score", usePepProphetScores ? "psm decoy prophet qvalue" : "psm decoy msgf qvalue", "psm decoy mcs", "psm decoy ntt", "psm decoy delta mass ppm", "psm decoy sequence", "psm decoy count proteins", "psm decoy proteins"};
            headers.addAll(Arrays.asList(headerPSMDecoy));
            out.writeLine(Utils.join(headers, "\t"));
            for (Query q : queries) {
                ArrayList<Object> o = new ArrayList<Object>();
                o.add(q.rawFile);
                o.add(q.c_scans);
                o.add(q.mass);
                o.add(q.charge);
                o.add(q.mz);
                if (q.matches.size() == 1) {
                    PSM psm = q.matches.get(0);
                    o.add(psm.sequence);
                    o.add(psm.mcs);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                    o.add(Utils.join(";", psm.nterms));
                    o.add(Utils.join(";", psm.cterms));
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(Utils.join(";", psm.startPositions));
                    o.add(psm.modificationString);
                    o.add(Utils.join(psm.getModifications(null), ";"));
                    o.add(psm.mass);
                    o.add(psm.getDeltaMassPPM());
                    o.add(q.probabilityScoreTarget);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreTarget) : "");
                } else {
                    int i = 0;
                    while (i < headerPSM.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (q.decoyMatches.size() == 1) {
                    PSM psm = q.decoyMatches.get(0);
                    o.add(q.probabilityScoreDecoy);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreDecoy) : "");
                    o.add(psm.mcs);
                    o.add(psm.getNTTs()[0]);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.sequence);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                } else {
                    int i = 0;
                    while (i < headerPSMDecoy.length) {
                        o.add("");
                        ++i;
                    }
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
            System.out.println("INFO: done!");
        }
    }

    public static class MSGFParser {
        public MSGFParser(File inTsvFile, File outQueryFile, File fastaFile, File indexFile) throws Exception {
            BufferedReader in;
            HashMap<String, String> fasta_ItoL = new HashMap<String, String>();
            Map<Object, Object> fasta = new HashMap();
            if (fastaFile != null) {
                fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
                for (Map.Entry<Object, Object> e : fasta.entrySet()) {
                    fasta_ItoL.put((String)e.getKey(), ((String)e.getValue()).replace('I', 'L'));
                }
            }
            HashMap<Integer, String> index2filename = new HashMap<Integer, String>();
            if (indexFile != null) {
                in = Utils.reader(indexFile);
                String line = in.readLine();
                ArrayList<String> header = Lists.newArrayList(Splitter.on('\t').split(line));
                int i_index = header.indexOf("index");
                int i_title_file = header.indexOf("title_file");
                while ((line = in.readLine()) != null) {
                    String[] arr = Iterables.toArray(Splitter.on('\t').split(line), String.class);
                    index2filename.put(Integer.parseInt(arr[i_index]), arr[i_title_file]);
                }
            }
            System.out.println("INFO: starting to read " + inTsvFile.getName());
            in = Utils.reader(inTsvFile);
            ArrayList<Query> queries = new ArrayList<Query>();
            ArrayList<Double> targetProbScores = new ArrayList<Double>();
            ArrayList<Double> decoyProbScores = new ArrayList<Double>();
            String line = in.readLine();
            ArrayList<String> header = Lists.newArrayList(Splitter.on('\t').split(line));
            int i_specfile = header.indexOf("#SpecFile");
            int i_specindex = header.indexOf("SpecIndex");
            int i_scannr = header.indexOf("Scan#");
            int i_fragmethod = header.indexOf("FragMethod");
            int i_precursormz = header.indexOf("Precursor");
            int i_precursormasserror = header.indexOf("PMError(ppm)");
            int i_charge = header.indexOf("Charge");
            int i_peptide = header.indexOf("Peptide");
            int i_protein = header.indexOf("Protein");
            int i_denovoscore = header.indexOf("DeNovoScore");
            int i_msgfscore = header.indexOf("MSGFScore");
            int i_specprob = header.indexOf("SpecProb");
            int i_pvalue = header.indexOf("P-value");
            while ((line = in.readLine()) != null) {
                String[] arr = Iterables.toArray(Splitter.on('\t').split(line), String.class);
                String experiment = arr[i_specfile];
                int scanIndex = Integer.parseInt(arr[i_specindex]);
                double probScore = -1.0 * Math.log10(Double.parseDouble(arr[i_specprob]));
                String pepSeqMod = arr[i_peptide];
                String refProt = arr[i_protein];
                double msgfscore = Double.parseDouble(arr[i_msgfscore]);
                double deltam = Double.parseDouble(arr[i_precursormasserror]);
                int charge = Integer.parseInt(arr[i_charge]);
                double precMz = Double.parseDouble(arr[i_precursormz]);
                double precMass = (double)charge * precMz;
                Query q = new Query(scanIndex, precMass, precMz, charge, null);
                q.c_scans = 1;
                q.rawFile = indexFile != null ? (String)index2filename.get(scanIndex) : experiment;
                boolean isDecoy = refProt.startsWith("REV_");
                PSM psm = new PSM(precMass, deltam, msgfscore, pepSeqMod, refProt, fasta, fasta_ItoL);
                if (queries.contains(q)) {
                    q = (Query)queries.get(queries.indexOf(q));
                    PSM savedPSM = null;
                    if (q.matches.size() == 1) {
                        if (isDecoy) continue;
                        savedPSM = q.matches.get(0);
                    } else if (q.decoyMatches.size() == 1) {
                        savedPSM = q.decoyMatches.get(0);
                    } else {
                        throw new Exception();
                    }
                    savedPSM.proteins = ArrayUtils.add(savedPSM.proteins, psm.proteins[0]);
                    savedPSM.startPositions = ArrayUtils.add(savedPSM.startPositions, psm.startPositions[0]);
                    savedPSM.cterms = ArrayUtils.add(savedPSM.cterms, psm.cterms[0]);
                    savedPSM.nterms = ArrayUtils.add(savedPSM.nterms, psm.nterms[0]);
                    continue;
                }
                if (isDecoy) {
                    q.addDecoyMatch(psm);
                    q.probabilityScoreDecoy = probScore;
                    decoyProbScores.add(probScore);
                } else {
                    q.addMatch(psm);
                    q.probabilityScoreTarget = probScore;
                    targetProbScores.add(probScore);
                }
                queries.add(q);
            }
            in.close();
            System.out.println("INFO: calculating q-values");
            QValueCalculator qvalCalcProb = new QValueCalculator(targetProbScores, decoyProbScores);
            System.out.println("INFO: writing results to " + outQueryFile.getName());
            UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outQueryFile));
            ArrayList<String> headers = new ArrayList<String>();
            String[] headerQuery = new String[]{"query source", "query scans", "query mass", "query charge", "query m/z"};
            headers.addAll(Arrays.asList(headerQuery));
            String[] headerPSM = new String[]{"psm sequence", "psm missed cleavage sites", "psm count proteins", "psm proteins", "psm n-termini", "psm c-termini", "psm tryptic termini", "psm start positions", "psm modificationString", "psm modifications", "psm mass", "psm delta mass ppm", "psm msgfSpecProb score", "psm msgfSpecProb qvalue"};
            headers.addAll(Arrays.asList(headerPSM));
            String[] headerPSMDecoy = new String[]{"psm decoy msgfSpecProb score", "psm decoy msgfSpecProb qvalue", "psm decoy mcs", "psm decoy ntt", "psm decoy delta mass ppm", "psm decoy sequence", "psm decoy count proteins", "psm decoy proteins"};
            headers.addAll(Arrays.asList(headerPSMDecoy));
            out.writeLine(Utils.join(headers, "\t"));
            for (Query q : queries) {
                ArrayList<Object> o = new ArrayList<Object>();
                o.add(q.rawFile);
                o.add(q.c_scans);
                o.add(q.mass);
                o.add(q.charge);
                o.add(q.mz);
                if (q.matches.size() == 1) {
                    PSM psm = q.matches.get(0);
                    o.add(psm.sequence);
                    o.add(psm.mcs);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                    o.add(Utils.join(";", psm.nterms));
                    o.add(Utils.join(";", psm.cterms));
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(Utils.join(";", psm.startPositions));
                    o.add(psm.modificationString);
                    o.add(Utils.join(psm.getModifications(null), ";"));
                    o.add(psm.mass);
                    o.add(psm.getDeltaMassPPM());
                    o.add(q.probabilityScoreTarget);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreTarget) : "");
                } else {
                    int i = 0;
                    while (i < headerPSM.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (q.decoyMatches.size() == 1) {
                    PSM psm = q.decoyMatches.get(0);
                    o.add(q.probabilityScoreDecoy);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreDecoy) : "");
                    o.add(psm.mcs);
                    o.add(psm.getNTTs()[0]);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.sequence);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                } else {
                    int i = 0;
                    while (i < headerPSMDecoy.length) {
                        o.add("");
                        ++i;
                    }
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
            System.out.println("INFO: done!");
        }
    }

    public static class MSGFPlusParser {
        public MSGFPlusParser(File inTsvFile, File outQueryFile, File fastaFile) throws Exception {
            HashMap<String, String> fasta = new HashMap();
            if (fastaFile != null) {
                fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
            }
            System.out.println("INFO: starting to read " + inTsvFile.getName());
            BufferedReader in = Utils.reader(inTsvFile);
            ArrayList<Query> queries = new ArrayList<Query>();
            ArrayList<Double> targetProbScores = new ArrayList<Double>();
            ArrayList<Double> decoyProbScores = new ArrayList<Double>();
            String line = in.readLine();
            ArrayList<String> header = Lists.newArrayList(Splitter.on('\t').split(line));
            int i_specfile = header.indexOf("#SpecFile");
            int i_specID = header.indexOf("SpecID");
            int i_title = header.indexOf("Title");
            int i_fragmethod = header.indexOf("FragMethod");
            int i_precursormz = header.indexOf("Precursor");
            int i_isotopeerror = header.indexOf("IsotopeError");
            int i_precursormasserrorPPM = header.indexOf("PrecursorError(ppm)");
            int i_precursormasserrorMZ = header.indexOf("PrecursorError(Da)");
            int i_charge = header.indexOf("Charge");
            int i_peptide = header.indexOf("Peptide");
            int i_protein = header.indexOf("Protein");
            int i_denovoscore = header.indexOf("DeNovoScore");
            int i_msgfscore = header.indexOf("MSGFScore");
            int i_specevalue = header.indexOf("SpecEValue");
            int i_evalue = header.indexOf("EValue");
            int i_specprob = header.indexOf("SpecProb");
            int i_qvalue = header.indexOf("QValue");
            int i_pepqvalue = header.indexOf("PepQValue");
            while ((line = in.readLine()) != null) {
                String[] arr = Iterables.toArray(Splitter.on('\t').split(line), String.class);
                String experiment = arr[i_specfile];
                int scanIndex = -1;
                if (arr[i_specID].startsWith("index=")) {
                    scanIndex = Integer.parseInt(arr[i_specID].substring(6));
                } else if (arr[i_specID].startsWith("controllerType=0 controllerNumber=1 scan=")) {
                    scanIndex = Integer.parseInt(arr[i_specID].substring(41));
                }
                double probScore = -1.0 * Math.log10(Double.parseDouble(arr[i_specevalue]));
                String pepSeqMod = arr[i_peptide];
                String prots = arr[i_protein];
                double msgfscore = Double.parseDouble(arr[i_msgfscore]);
                int charge = Integer.parseInt(arr[i_charge]);
                double precMz = Double.parseDouble(arr[i_precursormz]);
                double precMass = (double)charge * precMz;
                double deltam = i_precursormasserrorPPM > -1 ? Double.parseDouble(arr[i_precursormasserrorPPM]) : Double.parseDouble(arr[i_precursormasserrorMZ]) / precMz * 1000000.0;
                Query q = new Query(scanIndex, precMass, precMz, charge, null);
                q.c_scans = 1;
                q.rawFile = experiment;
                boolean isDecoy = prots.startsWith("XXX_");
                PSM psm = new PSM(precMass, deltam, msgfscore, pepSeqMod, prots, fasta);
                if (queries.contains(q)) {
                    q = (Query)queries.get(queries.indexOf(q));
                    PSM savedPSM = null;
                    if (q.matches.size() == 1) {
                        if (isDecoy) continue;
                        savedPSM = q.matches.get(0);
                    } else if (q.decoyMatches.size() == 1) {
                        savedPSM = q.decoyMatches.get(0);
                    } else {
                        throw new Exception();
                    }
                    if (!savedPSM.sequence.replace('I', 'L').equals(psm.sequence.replace('I', 'L'))) {
                        System.out.println("WARN: there is an additional peptide matched for spectrum " + q.id + ":\t" + savedPSM.sequence + "\t" + psm.sequence + "\t" + Joiner.on(';').join(savedPSM.proteins) + "\t" + Joiner.on(';').join(psm.proteins));
                    }
                    savedPSM.proteins = ArrayUtils.addAll(savedPSM.proteins, psm.proteins);
                    savedPSM.startPositions = ArrayUtils.addAll(savedPSM.startPositions, psm.startPositions);
                    savedPSM.cterms = ArrayUtils.addAll(savedPSM.cterms, psm.cterms);
                    savedPSM.nterms = ArrayUtils.addAll(savedPSM.nterms, psm.nterms);
                    continue;
                }
                if (isDecoy) {
                    q.addDecoyMatch(psm);
                    q.probabilityScoreDecoy = probScore;
                    decoyProbScores.add(probScore);
                } else {
                    q.addMatch(psm);
                    q.probabilityScoreTarget = probScore;
                    targetProbScores.add(probScore);
                }
                queries.add(q);
            }
            in.close();
            System.out.println("INFO: calculating q-values");
            QValueCalculator qvalCalcProb = new QValueCalculator(targetProbScores, decoyProbScores);
            System.out.println("INFO: writing results to " + outQueryFile.getName());
            UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outQueryFile));
            ArrayList<String> headers = new ArrayList<String>();
            String[] headerQuery = new String[]{"query source", "query scans", "query mass", "query charge", "query m/z"};
            headers.addAll(Arrays.asList(headerQuery));
            String[] headerPSM = new String[]{"psm sequence", "psm missed cleavage sites", "psm count proteins", "psm proteins", "psm n-termini", "psm c-termini", "psm tryptic termini", "psm start positions", "psm modificationString", "psm modifications", "psm mass", "psm delta mass ppm", "psm msgfSpecProb score", "psm msgfSpecProb qvalue"};
            headers.addAll(Arrays.asList(headerPSM));
            String[] headerPSMDecoy = new String[]{"psm decoy msgfSpecProb score", "psm decoy msgfSpecProb qvalue", "psm decoy mcs", "psm decoy ntt", "psm decoy delta mass ppm", "psm decoy sequence", "psm decoy count proteins", "psm decoy proteins"};
            headers.addAll(Arrays.asList(headerPSMDecoy));
            out.writeLine(Utils.join(headers, "\t"));
            for (Query q : queries) {
                ArrayList<Object> o = new ArrayList<Object>();
                o.add(q.rawFile);
                o.add(q.c_scans);
                o.add(q.mass);
                o.add(q.charge);
                o.add(q.mz);
                if (q.matches.size() == 1) {
                    PSM psm = q.matches.get(0);
                    o.add(psm.sequence);
                    o.add(psm.mcs);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                    o.add(Utils.join(";", psm.nterms));
                    o.add(Utils.join(";", psm.cterms));
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(Utils.join(";", psm.startPositions));
                    o.add(psm.modificationString);
                    o.add(Utils.join(psm.getModifications(null), ";"));
                    o.add(psm.mass);
                    o.add(psm.getDeltaMassPPM());
                    o.add(q.probabilityScoreTarget);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreTarget) : "");
                } else {
                    int i = 0;
                    while (i < headerPSM.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (q.decoyMatches.size() == 1) {
                    PSM psm = q.decoyMatches.get(0);
                    o.add(q.probabilityScoreDecoy);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.probabilityScoreDecoy) : "");
                    o.add(psm.mcs);
                    o.add(psm.getNTTs()[0]);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.sequence);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                } else {
                    int i = 0;
                    while (i < headerPSMDecoy.length) {
                        o.add("");
                        ++i;
                    }
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
            System.out.println("INFO: done!");
        }
    }

    public static class PSM {
        int rank;
        double mass;
        double deltaMass;
        String sequence;
        String[] nterms;
        String[] cterms;
        String substitutions;
        int mcs;
        String modificationString;
        double score;
        String[] proteins;
        Integer[] startPositions;
        String xMod;
        public InputType inputType;

        public PSM(double mass, double deltaMass, String sequenceAndMod, int mcs, double score, String[] proteins, String[] protSeqs) {
            this.inputType = InputType.PROPHET;
            this.mass = mass;
            this.deltaMass = deltaMass;
            this.modificationString = sequenceAndMod.substring(2, sequenceAndMod.length() - 2);
            this.sequence = this.modificationString.replaceAll("\\[\\d+\\.?\\d*\\]", "");
            this.sequence = this.sequence.replaceAll("n", "");
            this.sequence = this.sequence.replaceAll("c", "");
            ArrayList<Integer> lstStartPositions = new ArrayList<Integer>();
            ArrayList<String> lstNterms = new ArrayList<String>();
            ArrayList<String> lstCterms = new ArrayList<String>();
            String[] stringArray = protSeqs;
            int n = protSeqs.length;
            int n2 = 0;
            while (n2 < n) {
                String protSeq = stringArray[n2];
                if (protSeq != null) {
                    int startPos = protSeq.replace('I', 'L').indexOf(this.sequence.replace('I', 'L')) + 1;
                    lstStartPositions.add(startPos);
                    lstNterms.add(startPos == 1 ? "-" : protSeq.substring(startPos - 2, startPos - 1));
                    lstCterms.add(startPos + this.sequence.length() == protSeq.length() + 1 ? "-" : protSeq.substring(startPos + this.sequence.length() - 1, startPos + this.sequence.length()));
                }
                ++n2;
            }
            this.mcs = 0;
            Matcher m = Pattern.compile("[RK][^P]").matcher(this.sequence);
            int pos = 0;
            while (m.find(pos)) {
                pos = m.start() + 1;
                ++this.mcs;
            }
            if (this.mcs != mcs) {
                System.out.println("WARN: in peptide " + this.sequence + " prophet claims " + mcs + " missed cleavage sites while I believe there are " + this.mcs + " missed cleavage sites.");
            }
            this.score = score;
            this.proteins = proteins;
            this.startPositions = lstStartPositions.toArray(new Integer[0]);
            this.nterms = lstNterms.toArray(new String[0]);
            this.cterms = lstCterms.toArray(new String[0]);
            if (protSeqs[0] == null & protSeqs.length == 1) {
                this.nterms = new String[]{sequenceAndMod.substring(0, 1)};
                this.cterms = new String[]{sequenceAndMod.substring(sequenceAndMod.length() - 1, sequenceAndMod.length())};
            }
        }

        public PSM(double precursorMass, double deltamPPM, double score, String sequenceAndMod, String refProt, Map<String, String> fasta, Map<String, String> fasta_ItoL) {
            this.inputType = InputType.MSGF;
            this.deltaMass = precursorMass * deltamPPM / 1000000.0;
            this.mass = precursorMass - this.deltaMass;
            this.modificationString = sequenceAndMod.substring(2, sequenceAndMod.length() - 2);
            this.sequence = this.modificationString.replaceAll("[\\d\\.+-]", "");
            this.nterms = new String[]{sequenceAndMod.substring(0, 1)};
            this.cterms = new String[]{sequenceAndMod.substring(sequenceAndMod.length() - 1, sequenceAndMod.length())};
            this.mcs = 0;
            Matcher m = Pattern.compile("[RK][^P]").matcher(this.sequence);
            int pos = 0;
            while (m.find(pos)) {
                pos = m.start() + 1;
                ++this.mcs;
            }
            this.score = score;
            this.proteins = new String[]{refProt};
            if (fasta != null) {
                String seq_ItoL = this.sequence.replace('I', 'L');
                ArrayList<String> matchedProteins = new ArrayList<String>();
                ArrayList<String> matchedProteinSequences = new ArrayList<String>();
                for (Map.Entry<String, String> e : fasta_ItoL.entrySet()) {
                    if (!e.getValue().contains(seq_ItoL)) continue;
                    matchedProteins.add(e.getKey());
                    matchedProteinSequences.add(fasta.get(e.getKey()));
                }
                ArrayList<Integer> lstStartPositions = new ArrayList<Integer>();
                ArrayList<String> lstNterms = new ArrayList<String>();
                ArrayList<String> lstCterms = new ArrayList<String>();
                for (String protSeq : matchedProteinSequences) {
                    if (protSeq == null) continue;
                    int startPos = protSeq.replace('I', 'L').indexOf(seq_ItoL) + 1;
                    lstStartPositions.add(startPos);
                    lstNterms.add(startPos == 1 ? "-" : protSeq.substring(startPos - 2, startPos - 1));
                    lstCterms.add(startPos + this.sequence.length() == protSeq.length() + 1 ? "-" : protSeq.substring(startPos + this.sequence.length() - 1, startPos + this.sequence.length()));
                }
                if (matchedProteins.size() > 0) {
                    this.proteins = matchedProteins.toArray(new String[0]);
                    this.startPositions = lstStartPositions.toArray(new Integer[0]);
                    this.nterms = lstNterms.toArray(new String[0]);
                    this.cterms = lstCterms.toArray(new String[0]);
                }
            }
        }

        public PSM(double precursorMass, double deltamPPM, double score, String sequenceAndMod, String proteinHits, Map<String, String> fasta) {
            this.inputType = InputType.MSGFPLUS;
            this.deltaMass = precursorMass * deltamPPM / 1000000.0;
            this.mass = precursorMass - this.deltaMass;
            this.modificationString = sequenceAndMod;
            this.sequence = this.modificationString.replaceAll("[\\d\\.+-]", "");
            this.mcs = 0;
            Matcher m = Pattern.compile("[RK][^P]").matcher(this.sequence);
            int pos = 0;
            while (m.find(pos)) {
                pos = m.start() + 1;
                ++this.mcs;
            }
            this.score = score;
            String[] arrProteinHits = proteinHits.split(";");
            this.proteins = new String[arrProteinHits.length];
            this.nterms = new String[arrProteinHits.length];
            this.cterms = new String[arrProteinHits.length];
            int i = 0;
            while (i < arrProteinHits.length) {
                int s = arrProteinHits[i].indexOf("(pre=");
                this.proteins[i] = arrProteinHits[i].substring(0, s);
                this.nterms[i] = arrProteinHits[i].substring(s + 5, s + 6);
                this.cterms[i] = arrProteinHits[i].substring(s + 12, s + 13);
                ++i;
            }
            if (fasta != null) {
                String seq_ItoL = this.sequence.replace('I', 'L');
                ArrayList<Integer> lstStartPositions = new ArrayList<Integer>();
                String[] stringArray = this.proteins;
                int n = this.proteins.length;
                int n2 = 0;
                while (n2 < n) {
                    String prot = stringArray[n2];
                    if (fasta.containsKey(prot)) {
                        int startPos = fasta.get(prot).replace('I', 'L').indexOf(seq_ItoL) + 1;
                        if (startPos == -1) {
                            lstStartPositions.add(null);
                        } else {
                            lstStartPositions.add(startPos);
                        }
                    } else {
                        lstStartPositions.add(null);
                    }
                    ++n2;
                }
                this.startPositions = lstStartPositions.toArray(new Integer[0]);
            }
        }

        public PSM(double peptideMass, double deltam, String sequenceAndMod, double score, String protSeq1) {
            int startPos1;
            this.inputType = InputType.MSGF_PNNL;
            this.mass = peptideMass;
            this.deltaMass = deltam;
            this.modificationString = sequenceAndMod.substring(2, sequenceAndMod.length() - 2);
            this.sequence = this.modificationString.replace("*", "");
            this.nterms = new String[]{sequenceAndMod.substring(0, 1)};
            this.cterms = new String[]{sequenceAndMod.substring(sequenceAndMod.length() - 1, sequenceAndMod.length())};
            this.mcs = 0;
            Matcher m = Pattern.compile("[RK][^P]").matcher(this.sequence);
            int pos = 0;
            while (m.find(pos)) {
                pos = m.start() + 1;
                ++this.mcs;
            }
            this.score = score;
            if (protSeq1 != null && (startPos1 = protSeq1.indexOf(this.sequence) + 1) >= 0) {
                this.startPositions = new Integer[]{startPos1};
            }
        }

        public PSM(String psmLine, String termsLine, String substLine, String xMod, Map<String, String> fasta, Map<String, String> fasta_ItoL) {
            this.inputType = InputType.MASCOT;
            String[] arrPSM = psmLine.split(",");
            this.mcs = Integer.valueOf(arrPSM[0]);
            this.mass = Double.valueOf(arrPSM[1]);
            this.deltaMass = Double.valueOf(arrPSM[2]);
            this.sequence = arrPSM[4];
            this.modificationString = arrPSM[6];
            this.score = Double.valueOf(arrPSM[7]);
            String seq_ItoL = this.sequence.replace('I', 'L');
            ArrayList<String> matchedProteins = new ArrayList<String>();
            ArrayList<String> matchedProteinSequences = new ArrayList<String>();
            for (Map.Entry<String, String> e : fasta_ItoL.entrySet()) {
                if (!e.getValue().contains(seq_ItoL)) continue;
                matchedProteins.add(e.getKey());
                matchedProteinSequences.add(fasta.get(e.getKey()));
            }
            ArrayList<Integer> lstStartPositions = new ArrayList<Integer>();
            ArrayList<String> lstNterms = new ArrayList<String>();
            ArrayList<String> lstCterms = new ArrayList<String>();
            for (String protSeq : matchedProteinSequences) {
                if (protSeq == null) continue;
                int startPos = protSeq.replace('I', 'L').indexOf(seq_ItoL) + 1;
                lstStartPositions.add(startPos);
                lstNterms.add(startPos == 1 ? "-" : protSeq.substring(startPos - 2, startPos - 1));
                lstCterms.add(startPos + this.sequence.length() == protSeq.length() + 1 ? "-" : protSeq.substring(startPos + this.sequence.length() - 1, startPos + this.sequence.length()));
            }
            if (matchedProteins.size() > 0) {
                this.proteins = matchedProteins.toArray(new String[0]);
                this.startPositions = lstStartPositions.toArray(new Integer[0]);
                this.nterms = lstNterms.toArray(new String[0]);
                this.cterms = lstCterms.toArray(new String[0]);
            } else {
                int c_proteins = arrPSM.length - 10;
                this.proteins = new String[c_proteins];
                this.nterms = new String[c_proteins];
                this.cterms = new String[c_proteins];
                this.startPositions = new Integer[c_proteins];
                int i = 0;
                while (i < c_proteins) {
                    int start = arrPSM[10 + i].indexOf("\"") + 1;
                    this.proteins[i] = arrPSM[10 + i].substring(start, arrPSM[10 + i].indexOf("\"", start));
                    String[] arrProt = arrPSM[10 + i].split(":");
                    this.startPositions[i] = Integer.parseInt(arrProt[2]);
                    ++i;
                }
                String[] termPairs = termsLine.split(":");
                int i2 = 0;
                while (i2 < termPairs.length) {
                    String[] termPair = termPairs[i2].split(",");
                    this.nterms[i2] = termPair[0];
                    this.cterms[i2] = termPair[1];
                    ++i2;
                }
            }
            this.substitutions = substLine;
            this.xMod = xMod;
        }

        public List<String> getModifications(String[] varMods) {
            ArrayList<String> modifications;
            block7: {
                block9: {
                    block8: {
                        block6: {
                            modifications = new ArrayList<String>();
                            if (!this.inputType.equals((Object)InputType.MASCOT)) break block6;
                            int i = 0;
                            char[] cArray = this.modificationString.toCharArray();
                            int n = cArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char c = cArray[n2];
                                if (c != '0' && c != 'X') {
                                    String pos = i == 0 ? "N" : (i == this.modificationString.length() - 1 ? "C" : String.valueOf(i));
                                    int mod = Integer.parseInt(String.valueOf(c)) - 1;
                                    modifications.add(String.valueOf(pos) + ":" + varMods[mod]);
                                }
                                ++i;
                                ++n2;
                            }
                            break block7;
                        }
                        if (!this.inputType.equals((Object)InputType.PROPHET)) break block8;
                        int i = 0;
                        int c = 0;
                        while ((i = this.modificationString.indexOf(91, i) + 1) > 0) {
                            int abspos = i - c - 1;
                            String pos = abspos == 0 ? "N" : String.valueOf(abspos);
                            int j = this.modificationString.indexOf(93, i);
                            if (j < 0) {
                                j = this.modificationString.length();
                                pos = "C";
                            }
                            modifications.add(String.valueOf(pos) + ":" + this.modificationString.substring(i, j));
                            c = c + (j - i) + 2;
                        }
                        break block7;
                    }
                    if (!this.inputType.equals((Object)InputType.MSGF_PNNL)) break block9;
                    int i = -1;
                    int c = 0;
                    while ((i = this.modificationString.indexOf(42, i + 1)) >= 0) {
                        int abspos = i - c;
                        String mod = abspos <= 0 ? "N" : String.valueOf(abspos) + ":" + this.modificationString.substring(i - 1, i);
                        modifications.add(mod);
                        ++c;
                    }
                    break block7;
                }
                if (!this.inputType.equals((Object)InputType.MSGF) && !this.inputType.equals((Object)InputType.MSGFPLUS)) break block7;
                Matcher mm = Pattern.compile("[+-][0-9\\.]+").matcher(this.modificationString);
                int i = 0;
                int j = 0;
                while (mm.find(i)) {
                    int abspos = mm.start() - j;
                    String mod = (abspos <= 0 ? "N" : Integer.valueOf(abspos)) + ":" + mm.group();
                    modifications.add(mod);
                    j += mm.group().length();
                    i = mm.end();
                }
            }
            return modifications;
        }

        public Integer[] getNTTs() {
            Integer[] ntt = new Integer[this.proteins.length];
            int i = 0;
            while (i < this.proteins.length) {
                ntt[i] = 0;
                if (i >= this.nterms.length) {
                    ntt[i] = null;
                } else if (this.nterms[i].equals("-")) {
                    int n = i;
                    ntt[n] = ntt[n] + 1;
                } else if ((this.nterms[i].equals("K") || this.nterms[i].equals("R")) && !this.sequence.startsWith("P")) {
                    int n = i;
                    ntt[n] = ntt[n] + 1;
                }
                if (i >= this.cterms.length) {
                    ntt[i] = null;
                } else if (this.cterms[i].equals("-")) {
                    int n = i;
                    ntt[n] = ntt[n] + 1;
                } else if ((this.sequence.endsWith("K") || this.sequence.endsWith("R")) && !this.cterms[i].equals("P")) {
                    int n = i;
                    ntt[n] = ntt[n] + 1;
                }
                ++i;
            }
            return ntt;
        }

        public double getDeltaMassPPM() {
            return this.deltaMass / this.mass * 1000000.0;
        }

        public static enum InputType {
            MASCOT,
            PROPHET,
            MSGF_PNNL,
            MSGF,
            MSGFPLUS;

        }
    }

    public static class PeptideProphetParser {
        public PeptideProphetParser(File inXlsFile, File outQueryFile, String decoyPrefix, File fastaFile) throws FileNotFoundException, IOException {
            Map<String, String> fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
            HashMap<String, String> fasta_ItoL = new HashMap<String, String>();
            for (Map.Entry<String, String> e : fasta.entrySet()) {
                fasta_ItoL.put(e.getKey(), e.getValue().replace('I', 'L'));
            }
            System.out.println("INFO: starting to read " + inXlsFile.getName());
            BufferedReader in = Utils.reader(inXlsFile);
            ArrayList<Query> queries = new ArrayList<Query>();
            ArrayList<Double> targetScores = new ArrayList<Double>();
            ArrayList<Double> decoyScores = new ArrayList<Double>();
            ArrayList<Double> targetProbs = new ArrayList<Double>();
            ArrayList<Double> decoyProbs = new ArrayList<Double>();
            String line = in.readLine();
            ArrayList<String> header = Lists.newArrayList(Splitter.on('\t').split(line));
            int i_prob = header.indexOf("probability");
            int i_spectrumTitle = header.indexOf("spectrum");
            int i_peptide = header.indexOf("peptide");
            int i_protein = header.indexOf("protein");
            int i_mcs = header.indexOf("num_missed_cleavages");
            int i_ntt = header.indexOf("num_tol_term");
            int i_precursormass = header.indexOf("precursor_neutral_mass");
            int i_mass = header.indexOf("calc_neutral_pep_mass");
            int i_dmass = header.indexOf("massdiff");
            int i_mz = header.indexOf("MZratio");
            int i_charge = header.indexOf("assumed_charge");
            int i_index = header.indexOf("index");
            int i_rt = header.indexOf("retention_time_sec");
            int i_xcorr = header.indexOf("xcorr");
            while ((line = in.readLine()) != null) {
                String[] arr = Iterables.toArray(Splitter.on('\t').split(line), String.class);
                if (arr[i_prob].equals("[unavailable]")) {
                    System.out.println("WARN: skipping spectrum with no probability: " + arr[i_spectrumTitle]);
                    continue;
                }
                double prob = Double.parseDouble(arr[i_prob]);
                double precursormass = Double.parseDouble(arr[i_precursormass]);
                double mass = Double.parseDouble(arr[i_mass]);
                double mz = Double.parseDouble(arr[i_mz]);
                double dmass = Double.parseDouble(arr[i_dmass]);
                Integer charge = Integer.parseInt(arr[i_charge]);
                String pepSeqAndMod = arr[i_peptide];
                Object[] prots = arr[i_protein].split(",");
                int mcs = Integer.parseInt(arr[i_mcs]);
                int index = Integer.parseInt(arr[i_index]);
                Double rt = arr[i_rt].equals("[unavailable]") ? null : Double.valueOf(Double.parseDouble(arr[i_rt]));
                double xcorr = Double.parseDouble(arr[i_xcorr]);
                String spectrumTitle = arr[i_spectrumTitle];
                Query q = new Query(index, precursormass, mz, charge, null);
                q.rt = rt;
                if (Utils.rx(spectrumTitle, "(\\w+)\\.\\d+\\.\\d+\\.\\d+")) {
                    q.rawFile = Utils.rxMatcher.group(1);
                }
                boolean isDecoy = prots[0].startsWith(decoyPrefix);
                String pepSeq = pepSeqAndMod.substring(2, pepSeqAndMod.length() - 2).replaceAll("\\[\\d+\\.?\\d*\\]", "");
                String pepSeq_ItoL = pepSeq.replace('I', 'L');
                for (Map.Entry e : fasta_ItoL.entrySet()) {
                    if (!((String)e.getValue()).contains(pepSeq_ItoL) || ArrayUtils.contains(prots, e.getKey())) continue;
                    prots = ArrayUtils.add(prots, (String)e.getKey());
                }
                ArrayList<String> protSeqs = new ArrayList<String>();
                Object[] objectArray = prots;
                int n = prots.length;
                int n2 = 0;
                while (n2 < n) {
                    Object prot = objectArray[n2];
                    protSeqs.add(fasta.get(prot));
                    ++n2;
                }
                PSM psm = new PSM(mass, dmass, pepSeqAndMod, mcs, xcorr, (String[])prots, protSeqs.toArray(new String[0]));
                if (isDecoy) {
                    q.addDecoyMatch(psm);
                    decoyScores.add(psm.score);
                    q.percolatorScoreDecoy = prob;
                    decoyProbs.add(prob);
                } else {
                    q.addMatch(psm);
                    targetScores.add(psm.score);
                    q.percolatorScoreTarget = prob;
                    targetProbs.add(prob);
                }
                queries.add(q);
            }
            in.close();
            System.out.println("INFO: calculating q-values");
            QValueCalculator qvalCalcXcorr = new QValueCalculator(targetScores, decoyScores);
            QValueCalculator qvalCalcProb = new QValueCalculator(targetProbs, decoyProbs);
            System.out.println("INFO: writing results to " + outQueryFile.getName());
            UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outQueryFile));
            ArrayList<String> headers = new ArrayList<String>();
            String[] headerQuery = new String[]{"query id", "query source", "query scans", "query mass", "query charge", "query m/z", "query rt"};
            headers.addAll(Arrays.asList(headerQuery));
            String[] headerPSM = new String[]{"psm sequence", "psm missed cleavage sites", "psm count proteins", "psm proteins", "psm n-termini", "psm c-termini", "psm tryptic termini", "psm start positions", "psm modificationString", "psm modifications", "psm mass", "psm delta mass ppm", "psm ionscore", "psm qvalue", "psm prophet prob", "psm prophet qvalue"};
            headers.addAll(Arrays.asList(headerPSM));
            String[] headerPSMDecoy = new String[]{"psm decoy ionscore", "psm decoy qvalue", "psm decoy prophet prob", "psm decoy prophet qvalue", "psm decoy mcs", "psm decoy ntt", "psm decoy delta mass ppm", "psm decoy sequence", "psm decoy count proteins", "psm decoy proteins"};
            headers.addAll(Arrays.asList(headerPSMDecoy));
            out.writeLine(Utils.join(headers, "\t"));
            for (Query q : queries) {
                PSM psm;
                ArrayList<Object> o = new ArrayList<Object>();
                o.add(q.id);
                o.add(q.rawFile);
                o.add(1);
                o.add(q.mass);
                o.add(q.charge);
                o.add(q.mz);
                o.add(q.rt);
                if (q.matches.size() == 1) {
                    psm = q.matches.get(0);
                    o.add(psm.sequence);
                    o.add(psm.mcs);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                    o.add(Utils.join(";", psm.nterms));
                    o.add(Utils.join(";", psm.cterms));
                    o.add(Utils.join(";", psm.getNTTs()));
                    o.add(Utils.join(";", psm.startPositions));
                    o.add(psm.modificationString);
                    o.add(Utils.join(psm.getModifications(null), ";"));
                    o.add(psm.mass);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.score);
                    o.add(qvalCalcXcorr != null ? qvalCalcXcorr.getQvalue(psm.score) : "");
                    o.add(q.percolatorScoreTarget);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.percolatorScoreTarget) : "");
                } else {
                    int i = 0;
                    while (i < headerPSM.length) {
                        o.add("");
                        ++i;
                    }
                }
                if (q.decoyMatches.size() == 1) {
                    psm = q.decoyMatches.get(0);
                    o.add(psm.score);
                    o.add(qvalCalcXcorr != null ? qvalCalcXcorr.getQvalue(psm.score) : "");
                    o.add(q.percolatorScoreDecoy);
                    o.add(qvalCalcProb != null ? qvalCalcProb.getQvalue(q.percolatorScoreDecoy) : "");
                    o.add(psm.mcs);
                    o.add(psm.getNTTs()[0]);
                    o.add(psm.getDeltaMassPPM());
                    o.add(psm.sequence);
                    o.add(Utils.uniqueSet(psm.proteins).size());
                    o.add(Utils.join(";", psm.proteins));
                } else {
                    int i = 0;
                    while (i < headerPSMDecoy.length) {
                        o.add("");
                        ++i;
                    }
                }
                out.writeLine(Utils.join(o, "\t"));
            }
            out.close();
            System.out.println("INFO: done!");
        }
    }

    public static class PeptideProphetXMLParser {
        public PeptideProphetXMLParser(File inXmlFile, File outQueryFile, String decoyPrefix, File fastaFile) throws FileNotFoundException, IOException {
            System.err.println("ERROR: PepXML parser not yet implemented!");
        }
    }

    public static class Query {
        int id;
        double mass;
        Double mz;
        Integer charge;
        Double intensity;
        List<PSM> matches;
        List<PSM> decoyMatches;
        List<PSM> etMatches;
        Double percolatorScoreTarget;
        Double percolatorScoreDecoy;
        Double percolatorPEP;
        Double percolatorQval;
        Double percolatorQvalDecoy;
        Double probabilityScoreTarget;
        Double probabilityScoreDecoy;
        int c_scans;
        Double rt;
        String rawFile;

        public Query(int id, double mass, Double mz, Integer charge, Double intensity) {
            this.id = id;
            this.mass = mass;
            this.mz = mz;
            this.charge = charge;
            this.intensity = intensity;
            this.matches = new ArrayList<PSM>();
            this.decoyMatches = new ArrayList<PSM>();
            this.etMatches = new ArrayList<PSM>();
        }

        public void addMatch(PSM match) {
            this.matches.add(match);
        }

        public void addDecoyMatch(PSM decoyMatch) {
            this.decoyMatches.add(decoyMatch);
        }

        public void addEtMatch(PSM etMatch) {
            this.etMatches.add(etMatch);
        }

        public int hashCode() {
            return Objects.hashCode(this.id, this.mass, this.mz, this.charge, this.intensity, this.rt, this.rawFile);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Query) {
                Query that = (Query)obj;
                return Objects.equal(this.id, that.id) && Objects.equal(this.mass, that.mass) && Objects.equal(this.mz, that.mz) && Objects.equal(this.mass, that.mass) && Objects.equal(this.charge, that.charge) && Objects.equal(this.intensity, that.intensity) && Objects.equal(this.rt, that.rt) && Objects.equal(this.rawFile, that.rawFile);
            }
            return false;
        }
    }
}

