/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.intervaltree;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import iptgxdb.intervaltree.Interval;
import iptgxdb.intervaltree.IntervalNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IntervalTree<T>
implements Iterable<T> {
    private IntervalNode<T> head;
    private List<Interval<T>> intervalList;
    private boolean inSync;
    private int size;
    public long max = Long.MIN_VALUE;
    public long min = Long.MAX_VALUE;

    public IntervalTree() {
        this.head = new IntervalNode();
        this.intervalList = new ArrayList<Interval<T>>();
        this.inSync = true;
        this.size = 0;
    }

    public IntervalTree(List<Interval<T>> intervalList) {
        this.head = intervalList.size() > 0 ? new IntervalNode<T>(intervalList) : null;
        this.intervalList = new ArrayList<Interval<T>>();
        this.intervalList.addAll(intervalList);
        this.inSync = true;
        this.size = intervalList.size();
    }

    public List<T> get(long point) {
        List<Interval<T>> intervals = this.getIntervals(point);
        ArrayList<T> result = new ArrayList<T>();
        for (Interval<T> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<Interval<T>> getIntervals(long point) {
        this.build();
        return this.head.stab(point);
    }

    public List<T> getIntersect(long start, long end) {
        List<Interval<T>> intervals = this.getIntervalsIntersect(start, end);
        ArrayList<T> result = new ArrayList<T>();
        for (Interval<T> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<T> getWithin(long start, long end) {
        List<Interval<T>> intervals = this.getIntervalsWithin(start, end);
        ArrayList<T> result = new ArrayList<T>();
        for (Interval<T> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<Interval<T>> getIntervalsIntersect(long start, long end) {
        this.build();
        return this.head.queryIntersect(new Interval<Object>(start, end, null));
    }

    public List<Interval<T>> getIntervalsWithin(long start, long end) {
        this.build();
        return this.head.queryContained(new Interval<Object>(start, end, null));
    }

    public List<Interval<T>> getIntervalsBelow(long threshold) {
        this.build();
        return this.head.queryContained(new Interval<Object>(this.min, threshold, null));
    }

    public List<Interval<T>> getIntervalsAbove(long threshold) {
        this.build();
        return this.head.queryContained(new Interval<Object>(threshold, this.max, null));
    }

    public void addInterval(Interval<T> interval) {
        this.intervalList.add(interval);
        this.min = Math.min(this.min, interval.getStart());
        this.max = Math.max(this.max, interval.getEnd());
        this.inSync = false;
    }

    public void addInterval(long begin, long end, T data) {
        this.addInterval(new Interval<T>(begin, end, data));
    }

    public void removeInterval(Interval<T> interval) {
        this.intervalList.remove(interval);
        if (interval.getStart() == this.min) {
            this.min = Long.MAX_VALUE;
            for (Interval<T> i : this.intervalList) {
                this.min = Math.min(this.min, i.getStart());
            }
        }
        if (interval.getStart() == this.max) {
            this.max = Long.MIN_VALUE;
            for (Interval<T> i : this.intervalList) {
                this.max = Math.max(this.max, i.getEnd());
            }
        }
        this.inSync = false;
    }

    public boolean inSync() {
        return this.inSync;
    }

    public void build() {
        if (!this.inSync) {
            this.head = new IntervalNode<T>(this.intervalList);
            this.inSync = true;
            this.size = this.intervalList.size();
        }
    }

    public void buildForce() {
        this.inSync = false;
        this.build();
    }

    public int currentSize() {
        return this.size;
    }

    public int listSize() {
        return this.intervalList.size();
    }

    public String toString() {
        return this.nodeString(this.head, 0);
    }

    private String nodeString(IntervalNode<T> node, int level) {
        if (node == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < level) {
            sb.append("\t");
            ++i;
        }
        sb.append(node + "\n");
        sb.append(this.nodeString(node.getLeft(), level + 1));
        sb.append(this.nodeString(node.getRight(), level + 1));
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.intervalList.iterator(), new Function<Interval<T>, T>(){

            @Override
            public T apply(Interval<T> interval) {
                return interval.getData();
            }
        });
    }

    public List<Interval<T>> getIntervals() {
        return this.intervalList;
    }
}

