/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class UOPeptideClassifier {
    Set<Set<String>> sameSeqProts;

    public UOPeptideClassifier(File fastaFile) throws IOException {
        Map<String, String> fastaMap = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
        SetMultimap<String, String> protsBySeq = Utils.invertMapUsingSets(fastaMap);
        this.sameSeqProts = Sets.newHashSet();
        for (String key : protsBySeq.keys()) {
            this.sameSeqProts.add((Set<String>)protsBySeq.get((Object)key));
        }
    }

    public PeptideClass classify(Set<String> proteinIds) {
        if (this.sameSeqProts.contains(proteinIds)) {
            if (proteinIds.size() == 1) {
                return PeptideClass.CLASS1A;
            }
            return PeptideClass.CLASS3A;
        }
        return PeptideClass.CLASS3B;
    }

    public static enum PeptideClass {
        CLASS1A,
        CLASS1B,
        CLASS2A,
        CLASS2B,
        CLASS3A,
        CLASS3B;

    }
}

