/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import com.google.common.base.Splitter;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PositionSpecificCounts2WIG {
    public static Splitter splitter = Splitter.on('\t');
    public static boolean normalize = false;
    public static long totalReadCount = 0L;

    public static void main(String[] args) throws IOException {
        File fCounts = new File("C:/Ulrich/Studium/phd/Christian/Bartonella henselae/pacbio/p551_8Kb_jelena/positionReadCounts.p551_8Kb_jelena.tsv");
        String trackBaseName = "p551_8Kb_jelena";
        String seqId = "Bhen_NC005956.1_mod1";
        ArrayList<Integer> absTotal = new ArrayList<Integer>();
        ArrayList<Integer> absPlus = new ArrayList<Integer>();
        ArrayList<Integer> absMinus = new ArrayList<Integer>();
        ArrayList<Float> normTotal = new ArrayList<Float>();
        ArrayList<Float> normPlus = new ArrayList<Float>();
        ArrayList<Float> normMinus = new ArrayList<Float>();
        System.out.println("INFO: determining sequence length...");
        BufferedReader in = Utils.reader(fCounts);
        String line = in.readLine();
        int sequenceLength = 0;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            ++sequenceLength;
        }
        System.out.println("INFO: sequence length = " + sequenceLength);
        System.out.println("INFO: reading counts and generating wiggle files");
        in = Utils.reader(fCounts);
        line = in.readLine();
        while ((line = in.readLine()) != null) {
            Iterator<String> i = splitter.split(line).iterator();
            String pos = i.next();
            int readsTotal = Integer.valueOf(i.next());
            int readsPlus = Integer.valueOf(i.next());
            int readsMinus = Integer.valueOf(i.next());
            absTotal.add(readsTotal);
            absPlus.add(readsPlus);
            absMinus.add(readsMinus);
            if (!normalize) continue;
            normTotal.add(Float.valueOf(1.0f * (float)readsTotal / (float)totalReadCount * (float)sequenceLength));
            normPlus.add(Float.valueOf(1.0f * (float)readsPlus / (float)totalReadCount * (float)sequenceLength * 2.0f));
            normMinus.add(Float.valueOf(1.0f * (float)readsMinus / (float)totalReadCount * (float)sequenceLength * 2.0f));
        }
        UOBufferedWriter outWigAbsTotal = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".total.wig"));
        UOBufferedWriter outWigAbsPlus = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".plus.wig"));
        UOBufferedWriter outWigAbsMinus = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".minus.wig"));
        PositionSpecificCounts2WIG.writeWiggle(outWigAbsTotal, String.valueOf(trackBaseName) + ": reads tot", absTotal, seqId);
        PositionSpecificCounts2WIG.writeWiggle(outWigAbsPlus, String.valueOf(trackBaseName) + ": reads +", absPlus, seqId);
        PositionSpecificCounts2WIG.writeWiggle(outWigAbsMinus, String.valueOf(trackBaseName) + ": reads -", absMinus, seqId);
        if (normalize) {
            UOBufferedWriter outWigNormTotal = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".normalized.total.wig"));
            UOBufferedWriter outWigNormPlus = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".normalized.plus.wig"));
            UOBufferedWriter outWigNormMinus = new UOBufferedWriter(new File(fCounts.getParent(), String.valueOf(fCounts.getName()) + ".normalized.minus.wig"));
            PositionSpecificCounts2WIG.writeWiggle(outWigNormTotal, String.valueOf(trackBaseName) + ": norm.reads tot", normTotal, seqId);
            PositionSpecificCounts2WIG.writeWiggle(outWigNormPlus, String.valueOf(trackBaseName) + ": norm.reads +", normPlus, seqId);
            PositionSpecificCounts2WIG.writeWiggle(outWigNormMinus, String.valueOf(trackBaseName) + ": norm.reads -", normMinus, seqId);
        }
        System.out.println("INFO: done!");
    }

    public static void writeWiggle(UOBufferedWriter out, String name, List<? extends Comparable> track, String chromosome) throws IOException {
        Comparable max = Collections.max(track);
        out.writeLine("track type=wiggle_0 name=\"" + name + "\" graphType=chart scaleType=log viewLimits=0:" + max);
        out.writeLine("fixedStep chrom=" + chromosome + " start=1 step=1 span=1");
        for (Comparable comparable : track) {
            out.writeLine(comparable.toString());
        }
        out.close();
    }
}

