/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import iptgxdb.converter.AConverter;
import iptgxdb.converter.CMR2GFF;
import iptgxdb.converter.ChemGenome2GFF;
import iptgxdb.converter.Ensembl2GFF;
import iptgxdb.converter.GenBank2GFF;
import iptgxdb.converter.Genoscope2GFF;
import iptgxdb.converter.RepSeek2GFF;
import iptgxdb.converter.ShortORFs2GFF;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.Version;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Convert2GFF {
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("chemgenome", "file", "one or more fasta files generated by ChemGenome 2.0", false, true));
            this.addOption(CLIUtils.createArgOption("cmr", "file", "a tab-separated tabular text file from CMR", false, false));
            this.addOption(CLIUtils.createArgOption("ensembl", "file", "a plain-text Ensembl file", false, false));
            this.addOption(CLIUtils.createArgOption("genbank", "file", "a plain-text GenBank file", false, false));
            this.addOption(CLIUtils.createArgOption("prodigal", "file", "a prodigal GenBank file", false, false));
            this.addOption(CLIUtils.createArgOption("genoscope", "file", "a tab-separated tabular text file from Genoscope/MAGE", false, false));
            this.addOption(CLIUtils.createArgOption("broad", "file", "a BROAD genome summary per gene file", false, false));
            this.addOption(CLIUtils.createArgOption("short", "file", "a tab-separated short ORF file", false, false));
            this.addOption(CLIUtils.createArgOption("repseek", "file", "a repseek R-Table output file", false, false));
            this.addOption(CLIUtils.createArgOption("out", "output", "the output gff3 file", true, false));
            this.addOption(CLIUtils.createArgOption("id", "sequenceId", "the sequence id for the GFF file [default: guessed from input file]", false, false));
            this.addOption(CLIUtils.createArgOption("tab", "output", "a tab-separated output file with sequences per entry [requires seq]", false, false));
            this.addOption(CLIUtils.createArgOption("seq", "input", "the genomic sequence", false, false));
            this.addOption(CLIUtils.createArgOption("extend", "e", "extend all features 3' by <e> nucleotides or automatically if e='auto'", false, false));
            this.addOption(new Option("all", "convert exentsive, i.e. all features and attributes"));
        }
    };

    public static void printUsageAndExit() {
        String description = "Genome Annotation Converter v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar Convert2GFF.jar", description, options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            Convert2GFF.printUsageAndExit();
        }
        File fOut = CLIUtils.getFileOption(cli, "out", true);
        File fTab = CLIUtils.getFileOption(cli, "tab", true);
        String seqId = cli.getOptionValue("id", null);
        File fSeq = CLIUtils.getFileOption(cli, "seq", false);
        if (fTab != null && fSeq == null) {
            System.err.println("ERROR: provide the genome sequence using the seq parameter!");
            System.exit(-1);
        }
        AConverter converter = null;
        File[] fIn = null;
        String inputOption = null;
        if (cli.hasOption("chemgenome")) {
            inputOption = "chemgenome";
            converter = new ChemGenome2GFF();
        } else if (cli.hasOption("cmr")) {
            inputOption = "cmr";
            converter = new CMR2GFF();
        } else if (cli.hasOption("ensembl")) {
            inputOption = "ensembl";
            converter = new Ensembl2GFF();
        } else if (cli.hasOption("genbank")) {
            inputOption = "genbank";
            converter = new GenBank2GFF();
        } else if (cli.hasOption("prodigal")) {
            inputOption = "prodigal";
            converter = new GenBank2GFF();
        } else if (cli.hasOption("genoscope")) {
            inputOption = "genoscope";
            converter = new Genoscope2GFF();
        } else if (cli.hasOption("short")) {
            inputOption = "short";
            converter = new ShortORFs2GFF();
        } else if (cli.hasOption("repseek")) {
            inputOption = "repseek";
            converter = new RepSeek2GFF();
        } else {
            System.out.println("You have to specify ONE input file!");
            Convert2GFF.printUsageAndExit();
        }
        fIn = CLIUtils.getFileArray(cli, inputOption);
        boolean extensive = cli.hasOption("all");
        String extend = cli.getOptionValue("extend");
        converter.convert(seqId, fIn, fOut, fTab, fSeq, extensive, extend);
    }
}

