/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import iptgxdb.intervaltree.Interval;
import iptgxdb.intervaltree.IntervalTree;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeFeatureSet;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.GenomicsUtil;
import iptgxdb.utils.ProteomicsUtils;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import iptgxdb.utils.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ProteinSummary {
    public static boolean allProt = false;
    public static boolean allExp = false;
    public static boolean pep = false;
    public static boolean minOutput = true;
    public static boolean noproteinsort = false;
    public static Map<Integer, Double> correctionFactors = null;
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("in", "input", "a tabular peptide file (tsv file)", false, false));
            this.addOption(CLIUtils.createArgOption("fasta", "input", "the fasta file used for the search, can be a subset which you are interested in only", true, false));
            this.addOption(CLIUtils.createArgOption("exp", "input", "one or more files enumerating headers with spectral counts from the peptide.tsv file which should be grouped per protein to an 'experiment', e.g.:\nexpA.txt:\n=========\nsample1.r1.tsv - all - spectra\nsample2.r1.tsv - all - spectra", false, true));
            this.addOption(CLIUtils.createArgOption("cor", "input", "a tabular file (tsv file) with peptide length correction factors for abundance calculation", false, false));
            this.addOption(CLIUtils.createArgOption("out", "output", "a tabular protein file (tsv file)", true, false));
            this.addOption(CLIUtils.createArgOption("decpep", "input", "a tabular decoy-peptide file (tsv file)", false, false));
            this.addOption(CLIUtils.createArgOption("decprot", "output", "a tabular protein file of decoy hits (tsv file)", false, false));
            this.addOption("allProt", false, "output protein table for all database entries, not only identified (useful in combination with tmhmm and signalp, or when comparing different searches on protein level)");
            this.addOption("allExp", false, "generate protein level data for every single run (can be used instead or in addition to -exp");
            this.addOption(CLIUtils.createArgOption("tmhmm", "input", "a TMHMM 2 short output file for the input fasta database", false, false));
            this.addOption(CLIUtils.createArgOption("signalp", "input", "a SignalP 4 short output file for the input fasta database", false, false));
            this.addOption(CLIUtils.createArgOption("sum", "output", "a summary per experiment", false, false));
            this.addOption("pep", false, "output a peptide list for each experiment");
            this.addOption("min", false, "minimize output per experiment (i.e. count of spectra & psms only)");
            this.addOption(CLIUtils.createArgOption("gff", "input file", "gff3 file of protein genes - will be used for mapping identified peptides to the genome", false, false));
            this.addOption(CLIUtils.createArgOption("prot3b", "output", "a protein table with class 3b protein groups (i.e. not a single unambiguous peptide)", false, false));
            this.addOption("noproteinsort", false, "do not sort protein ids, use if proteins are already sorted by some means");
            this.addOption(CLIUtils.createArgOption("mapping", "input", "the matching table for genomic searches, as generated by GffCombiner (tsv file)", false, false));
        }
    };

    public static void printUsageAndExit() {
        String description = "ProteinSummary v" + Version.getVersion() + " by Ulrich Omasits";
        new HelpFormatter().printHelp("java -jar ProteinSummary.jar", description, options, null, true);
        System.exit(0);
    }

    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) throws Exception {
        Object e8;
        String line;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-fasta", "P:/33_omul/projects/bartonella_henselae/annotations/NC_005956.pDT024.all_fullSeq.remapped.fasta", "-in", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/peptides_fdr0.0001.remapped.tsv", "-out", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/proteins_fdr0.0001.cor.tsv", "-decpep", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/peptidesDecoy_fdr0.0001.tsv", "-decprot", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/proteinsDecoy_fdr0.0001.cor.tsv", "-sum", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/proteinsSummary0.0001.cor.tsv", "-prot3b", "P:/33_omul/projects/bartonella_henselae/proteogenomics/msgf_refseq_all/proteins3b_fdr0.0001.cor.tsv", "-cor", "P:/33_omul/projects/bartonella_henselae/analysis/spectralCountNormalization/spectral_count_correction_factors.nonlog.tsv", "-noproteinsort", "-min"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e2) {
            System.out.println(e2.getMessage());
            ProteinSummary.printUsageAndExit();
        }
        File peptideFile = CLIUtils.getFileOption(cli, "in", false);
        File fastaFile = CLIUtils.getFileOption(cli, "fasta", false);
        File outputFile = CLIUtils.getFileOption(cli, "out", true);
        File inputDecoy = CLIUtils.getFileOption(cli, "decpep", false);
        File outputDecoy = CLIUtils.getFileOption(cli, "decprot", false);
        if (outputDecoy != null && inputDecoy == null) {
            System.err.println("ERROR: need peptide-decoy table input for protein-decoy output");
            ProteinSummary.printUsageAndExit();
        }
        File outputProt3b = CLIUtils.getFileOption(cli, "prot3b", true);
        File[] expFiles = new File[]{};
        if (cli.hasOption("exp")) {
            expFiles = CLIUtils.getFileArray(cli, "exp");
        }
        File fInSignalp = CLIUtils.getFileOption(cli, "signalp", false);
        File fInTmhmm = CLIUtils.getFileOption(cli, "tmhmm", false);
        File fSummary = CLIUtils.getFileOption(cli, "sum", true);
        File fMapping = CLIUtils.getFileOption(cli, "mapping", false);
        File fCorrection = CLIUtils.getFileOption(cli, "cor", false);
        File fGffIn = CLIUtils.getFileOption(cli, "gff", false);
        int minSpectraPerPep = 0;
        int maxSpectraPerPep = Integer.MAX_VALUE;
        allProt = cli.hasOption("allProt");
        allExp = cli.hasOption("allExp");
        pep = cli.hasOption("pep");
        minOutput = cli.hasOption("min");
        noproteinsort = cli.hasOption("noproteinsort");
        HashMultiset<String> c_proteins = HashMultiset.create();
        HashMultiset<String> c_singlePepProteins = HashMultiset.create();
        HashMultiset<String> c_singlePSMProteins = HashMultiset.create();
        HashMultiset<String> c_signalProteins = HashMultiset.create();
        HashMultiset<String> c_tmProteins = HashMultiset.create();
        HashMultiset<String> c_secretedProteins = HashMultiset.create();
        TreeMap c_tmFreq = Maps.newTreeMap();
        HashMultiset<String> c_spectra_total = HashMultiset.create();
        HashMultiset<String> c_spectra_used = HashMultiset.create();
        HashMultiset<String> c_PSMs_total = HashMultiset.create();
        HashMultiset<String> c_PSMs_used = HashMultiset.create();
        HashMultiset<String> c_pepsUsed = HashMultiset.create();
        HashMultiset<String> c_pepsOmitted = HashMultiset.create();
        HashMultiset<String> c_pepsOmittedAmbiguous = HashMultiset.create();
        HashMultiset<String> c_pepsOmittedNotInDB = HashMultiset.create();
        HashMultiset<String> c_matched = HashMultiset.create();
        int c_length_total_db = 0;
        LinkedHashMap ambiguousHits = new LinkedHashMap();
        LinkedHashMap<String, List<String>> experiments = new LinkedHashMap<String, List<String>>();
        if (allExp) {
            System.out.println("INFO: peeking peptide file for experiments...");
            BufferedReader in = Utils.reader(peptideFile);
            ArrayList<String> lstHeader = Lists.newArrayList(Splitter.on('\t').split(in.readLine()));
            for (String header : lstHeader) {
                if (!header.endsWith(" - psms")) continue;
                experiments.put(header.substring(0, header.length() - " - psms".length()), Lists.newArrayList(header));
            }
        }
        System.out.println("INFO: reading experiment definitions...");
        File[] fileArray = expFiles;
        int header = expFiles.length;
        int lstHeader = 0;
        while (lstHeader < header) {
            File expFile = fileArray[lstHeader];
            String expTitle = expFile.getName().toLowerCase().endsWith(".txt") ? expFile.getName().substring(0, expFile.getName().length() - 4) : expFile.getName();
            experiments.put(expTitle, Files.readLines(expFile, Charsets.UTF_8));
            ++lstHeader;
        }
        ArrayList<String> experimentList = Lists.newArrayList("total");
        experimentList.addAll(experiments.keySet());
        System.out.println("INFO: reading FASTA file...");
        Map<String, String> fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
        HashMap<String, ProteinSeq> proteinById = Maps.newHashMap();
        HashMap<String, ProteinSeq> proteinBySeq = Maps.newHashMap();
        HashMap<String, String> alternativeIDs = Maps.newHashMap();
        for (Map.Entry<String, String> e3 : fasta.entrySet()) {
            String id = e3.getKey();
            if (!proteinBySeq.containsKey(e3.getValue())) {
                proteinBySeq.put(e3.getValue(), new ProteinSeq(e3.getValue(), experimentList));
            }
            ProteinSeq p = (ProteinSeq)proteinBySeq.get(e3.getValue());
            p.addId(id);
            proteinById.put(id, p);
            alternativeIDs.put(id.replaceAll("\\W", "_"), id);
            alternativeIDs.put(id.replaceAll("\\|", "_"), id);
        }
        LinkedHashMap mappedHierachy = null;
        HashSet unmappedIDs = null;
        if (fMapping != null) {
            System.out.println("INFO: reading in the protein identifier matching table from  " + fMapping.getName());
            BufferedReader inMapping = Utils.reader(fMapping);
            String line2 = inMapping.readLine();
            Iterator header2 = Lists.newArrayList(Splitter.on('\t').split(line2));
            LinkedHashMap<String, Integer> hierarchies = new LinkedHashMap<String, Integer>();
            Iterator iterator = header2.iterator();
            while (iterator.hasNext()) {
                String head = (String)iterator.next();
                if (!head.endsWith(" ID")) continue;
                hierarchies.put(head.substring(0, head.length() - 3), header2.indexOf(head));
            }
            int i_ids = header2.indexOf("mapped IDs");
            mappedHierachy = new LinkedHashMap();
            unmappedIDs = new HashSet(proteinById.keySet());
            for (String hierarchy : hierarchies.keySet()) {
                mappedHierachy.put(hierarchy, new TreeMap());
            }
            block7: while ((line2 = inMapping.readLine()) != null) {
                ArrayList<String> elems = Lists.newArrayList(Splitter.on('\t').split(line2));
                String majorId = (String)elems.get(i_ids);
                if (!proteinById.containsKey(majorId)) continue;
                unmappedIDs.remove(majorId);
                ArrayList<String> additionalIds = new ArrayList<String>();
                for (String additionalId : elems.subList(i_ids + 1, elems.size())) {
                    if (!proteinById.containsKey(additionalId)) continue;
                    additionalIds.add(additionalId);
                    unmappedIDs.remove(additionalId);
                }
                for (Map.Entry h : hierarchies.entrySet()) {
                    if (((String)elems.get((Integer)h.getValue())).length() <= 0) continue;
                    ((SortedMap)mappedHierachy.get(h.getKey())).put(majorId, additionalIds);
                    if (((ProteinSeq)proteinById.get((Object)majorId)).idList.get(0).equals(majorId)) {
                        ((ProteinSeq)proteinById.get((Object)majorId)).primaryProteinReferenceId = majorId;
                        ((ProteinSeq)proteinById.get((Object)majorId)).primaryProteinType = String.valueOf((String)h.getKey()) + " protein";
                    }
                    for (String additionalId : additionalIds) {
                        if (!((ProteinSeq)proteinById.get((Object)additionalId)).idList.get(0).equals(additionalId)) continue;
                        ((ProteinSeq)proteinById.get((Object)additionalId)).primaryProteinReferenceId = majorId;
                        ((ProteinSeq)proteinById.get((Object)additionalId)).primaryProteinType = "extension/reduction to " + (String)h.getKey() + " protein";
                    }
                    continue block7;
                }
            }
            inMapping.close();
        }
        System.out.println("INFO: performing in-silico digest and determining unique peptides...");
        HashMap<String, ProteinSeq> peptide2protein = new HashMap<String, ProteinSeq>();
        for (ProteinSeq prot : proteinBySeq.values()) {
            HashSet<String> peps = Sets.newHashSet(ProteomicsUtils.cleaveSequence(prot.sequence, "([KR])[^P]"));
            for (String pep : peps) {
                if (peptide2protein.containsKey(pep)) {
                    peptide2protein.put(pep, null);
                    continue;
                }
                peptide2protein.put(pep, prot);
            }
        }
        for (Map.Entry e4 : peptide2protein.entrySet()) {
            if (e4.getValue() == null) continue;
            ((ProteinSeq)e4.getValue()).insilicoUniquePeptides.add((String)e4.getKey());
        }
        for (String seq : proteinBySeq.keySet()) {
            c_length_total_db += seq.length();
        }
        c_proteins.add("db", proteinBySeq.size());
        if (fCorrection != null) {
            System.out.println("INFO: reading in the peptide-length correction factor table from  " + fCorrection.getName());
            correctionFactors = new HashMap<Integer, Double>();
            BufferedReader inCF = Utils.reader(fCorrection);
            while ((line = inCF.readLine()) != null) {
                int pepLength = Integer.parseInt(line.split("\t")[0]);
                double factor = Double.parseDouble(line.split("\t")[1]);
                correctionFactors.put(pepLength, factor);
            }
        }
        if (fInSignalp != null) {
            System.out.println("INFO: processing SignalP input...");
            BufferedReader inSignalp = Utils.reader(fInSignalp);
            while ((line = inSignalp.readLine()) != null) {
                boolean cleavage;
                if (line.startsWith("#")) continue;
                ArrayList<String> elems = Lists.newArrayList(Splitter.on(' ').omitEmptyStrings().trimResults().split(line));
                String proteinName = (String)elems.get(0);
                if (!proteinById.containsKey(proteinName)) {
                    if (alternativeIDs.containsKey(proteinName)) {
                        proteinName = (String)alternativeIDs.get(proteinName);
                    } else {
                        System.err.println("ERROR: no protein entry found for signalp entry " + proteinName);
                    }
                }
                if (!(cleavage = ((String)elems.get(9)).equals("Y"))) continue;
                int pos = Integer.parseInt((String)elems.get(6));
                ((ProteinSeq)proteinById.get((Object)proteinName)).signalPepCleavage = pos;
                c_signalProteins.add("db");
            }
            inSignalp.close();
        }
        if (fInTmhmm != null) {
            System.out.println("INFO: processing TMHMM input...");
            BufferedReader inTmhmm = Utils.reader(fInTmhmm);
            while ((line = inTmhmm.readLine()) != null) {
                Object loopExt;
                int loopTo;
                String topol;
                if (line.startsWith("#")) continue;
                ArrayList<String> elems = Lists.newArrayList(Splitter.on('\t').split(line));
                String proteinName = (String)elems.get(0);
                ProteinSeq protein = (ProteinSeq)proteinById.get(proteinName);
                int seqLen = Integer.parseInt(((String)elems.get(1)).split("=")[1]);
                if (seqLen != protein.sequence.length()) {
                    System.err.println("WARNING: conflicting protein sequence lengths in fasta file and TMHMM file for " + proteinName);
                }
                int predTms = Integer.parseInt(((String)elems.get(4)).split("=")[1]);
                protein.tmhmmPrediction = topol = ((String)elems.get(5)).split("=")[1];
                String topolExt = "0" + topol + (seqLen + 1);
                Integer sigP = protein.signalPepCleavage;
                if (sigP != null) {
                    String[] stringArray = topolExt.split("-");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String loopType;
                        String loop = stringArray[n2];
                        int loopFrom = Integer.parseInt(loop.split("[io]")[0]) + 1;
                        loopTo = Integer.parseInt(loop.split("[io]")[1]) - 1;
                        String string = loopType = loop.contains("i") ? "i" : "o";
                        if (loopTo >= sigP && (loopFrom >= sigP || loopFrom < sigP && loopTo >= sigP)) {
                            loopExt = String.valueOf(sigP - 1) + loopType + (loopTo + 1);
                            topolExt = String.valueOf(loopExt) + topolExt.substring(topolExt.indexOf(loop) + loop.length());
                            if (!loopType.equals("i")) break;
                            topolExt = topolExt.replace('i', 'O').replace('o', 'I').toLowerCase();
                            break;
                        }
                        ++n2;
                    }
                }
                protein.combinedTopology = topolExt;
                ArrayList tms = new ArrayList();
                ArrayList ins = new ArrayList();
                ArrayList outs = new ArrayList();
                Integer tmStart = null;
                loopExt = topolExt.split("-");
                int loopType = ((String[])loopExt).length;
                loopTo = 0;
                while (loopTo < loopType) {
                    String loop = loopExt[loopTo];
                    int loopFrom = Integer.parseInt(loop.split("[io]")[0]) + 1;
                    int loopTo2 = Integer.parseInt(loop.split("[io]")[1]) - 1;
                    if (tmStart != null) {
                        int tmEnd = loopFrom - 1;
                        tms.add(new Interval<Object>(tmStart.intValue(), tmEnd, null));
                    }
                    tmStart = loopTo2 + 1;
                    if (loop.contains("i")) {
                        ins.add(new Interval<Object>(loopFrom, loopTo2, null));
                    } else if (loop.contains("o")) {
                        outs.add(new Interval<Object>(loopFrom, loopTo2, null));
                    } else {
                        throw new Exception("unkown topology for protein " + proteinName + ": " + topol);
                    }
                    ++loopTo;
                }
                if (tms.size() > 0) {
                    protein.tmRegions = new IntervalTree(tms);
                    protein.inRegions = new IntervalTree(ins);
                    protein.outRegions = new IntervalTree(outs);
                }
                protein.combinedTopologyTMcount = tms.size();
                if (tms.size() > 0) {
                    protein.proteinClass = "TM";
                    c_tmProteins.add("db");
                    if (!c_tmFreq.containsKey(tms.size())) {
                        HashMultiset ms = HashMultiset.create();
                        c_tmFreq.put(tms.size(), ms);
                    }
                    ((Multiset)c_tmFreq.get(tms.size())).add("db");
                    continue;
                }
                if (sigP == null) continue;
                protein.proteinClass = "S";
                c_secretedProteins.add("db");
            }
            inTmhmm.close();
        }
        if (peptideFile != null) {
            System.out.println("INFO: reading peptide search results...");
            BufferedReader in = Utils.reader(peptideFile);
            Splitter splitter = Splitter.on('\t');
            String line3 = in.readLine();
            ArrayList<String> lstHeader2 = Lists.newArrayList(splitter.split(line3));
            int i_pep = lstHeader2.indexOf("peptide sequence");
            int i_countProts = lstHeader2.indexOf("number of proteins");
            int i_prots = lstHeader2.indexOf("proteins");
            int i_spectra_total = lstHeader2.indexOf("total spectra peptide");
            int i_psms_total = lstHeader2.indexOf("total PSM peptide");
            HashMap i_experimentsSpectra = new HashMap();
            HashMap i_experimentsPSMs = new HashMap();
            for (Map.Entry e5 : experiments.entrySet()) {
                ArrayList<Integer> expPSMsInd = new ArrayList<Integer>();
                for (String expHeader : (List)e5.getValue()) {
                    if (expHeader.length() == 0) continue;
                    if (lstHeader2.contains(expHeader)) {
                        expPSMsInd.add(lstHeader2.indexOf(expHeader));
                        continue;
                    }
                    if (lstHeader2.contains(String.valueOf(expHeader) + " - all - psms")) {
                        expPSMsInd.add(lstHeader2.indexOf(String.valueOf(expHeader) + " - all - psms"));
                        continue;
                    }
                    if (!lstHeader2.contains(String.valueOf(expHeader) + " - psms")) continue;
                    expPSMsInd.add(lstHeader2.indexOf(String.valueOf(expHeader) + " - psms"));
                }
                i_experimentsPSMs.put((String)e5.getKey(), expPSMsInd);
                ArrayList<Integer> expSpectraInd = new ArrayList<Integer>();
                for (String expHeader : (List)e5.getValue()) {
                    if (lstHeader2.contains(expHeader)) {
                        expSpectraInd.add(lstHeader2.indexOf(expHeader));
                        continue;
                    }
                    if (lstHeader2.contains(String.valueOf(expHeader) + " - all - spectra")) {
                        expSpectraInd.add(lstHeader2.indexOf(String.valueOf(expHeader) + " - all - spectra"));
                        continue;
                    }
                    if (lstHeader2.contains(String.valueOf(expHeader) + " - spectra")) {
                        expSpectraInd.add(lstHeader2.indexOf(String.valueOf(expHeader) + " - spectra"));
                        continue;
                    }
                    throw new Exception("ERROR: Header '" + expHeader + "' not found!");
                }
                i_experimentsSpectra.put((String)e5.getKey(), expSpectraInd);
            }
            while ((line3 = in.readLine()) != null) {
                Iterator elems = Lists.newArrayList(splitter.split(line3));
                String pep = (String)elems.get(i_pep);
                String strProts = (String)elems.get(i_prots);
                int countProts = Integer.parseInt((String)elems.get(i_countProts));
                int spectra_total = Integer.parseInt((String)elems.get(i_spectra_total));
                int psms_total = Integer.parseInt((String)elems.get(i_psms_total));
                if (spectra_total < minSpectraPerPep || spectra_total > maxSpectraPerPep) continue;
                ArrayList<String> proteinIdList = Lists.newArrayList(Splitter.on(';').split(strProts));
                TreeSet<String> proteinIdSet = Sets.newTreeSet(proteinIdList);
                ProteinSeq protein = (ProteinSeq)proteinById.get(proteinIdList.get(0));
                boolean validPeptide = true;
                boolean peptideNotInDB = false;
                boolean peptideAmbiguous = false;
                for (String proteinId : proteinIdList) {
                    if (!proteinById.containsKey(proteinId)) {
                        System.err.println("WARN: protein with id " + proteinId + " not in database");
                        validPeptide = false;
                        peptideNotInDB = true;
                        continue;
                    }
                    if (((ProteinSeq)proteinById.get(proteinId)).equals(protein)) continue;
                    validPeptide = false;
                    peptideAmbiguous = true;
                    if (!ambiguousHits.containsKey(proteinIdSet)) {
                        ambiguousHits.put(proteinIdSet, new HashMap());
                        for (String expTitle : experimentList) {
                            HashMultiset peps = HashMultiset.create();
                            ((HashMap)ambiguousHits.get(proteinIdSet)).put(expTitle, peps);
                        }
                    }
                    ((Multiset)((HashMap)ambiguousHits.get(proteinIdSet)).get("total")).add(pep, spectra_total);
                    for (Map.Entry e6 : i_experimentsSpectra.entrySet()) {
                        int spectra = 0;
                        boolean psms = false;
                        for (Integer i_spectra_exp : (List)e6.getValue()) {
                            if (((String)elems.get(i_spectra_exp)).length() <= 0) continue;
                            spectra += Integer.parseInt((String)elems.get(i_spectra_exp));
                        }
                        if (spectra <= 0) continue;
                        ((Multiset)((HashMap)ambiguousHits.get(proteinIdSet)).get(e6.getKey())).add(pep, spectra);
                    }
                }
                for (Map.Entry e7 : i_experimentsSpectra.entrySet()) {
                    int spectra = 0;
                    int psms = 0;
                    for (Integer i_spectra_exp : (List)e7.getValue()) {
                        if (((String)elems.get(i_spectra_exp)).length() <= 0) continue;
                        spectra += Integer.parseInt((String)elems.get(i_spectra_exp));
                    }
                    for (Integer i_psms_exp : (List)i_experimentsPSMs.get(e7.getKey())) {
                        if (((String)elems.get(i_psms_exp)).length() <= 0) continue;
                        psms += Integer.parseInt((String)elems.get(i_psms_exp));
                    }
                    if (spectra <= 0) continue;
                    c_spectra_total.add((String)e7.getKey(), spectra);
                    c_PSMs_total.add((String)e7.getKey(), psms);
                    if (!validPeptide) {
                        c_pepsOmitted.add((String)e7.getKey());
                        if (peptideNotInDB) {
                            c_pepsOmittedNotInDB.add((String)e7.getKey());
                            continue;
                        }
                        if (!peptideAmbiguous) continue;
                        c_pepsOmittedAmbiguous.add((String)e7.getKey());
                        continue;
                    }
                    protein.addPeptide(pep, psms, spectra, (String)e7.getKey());
                    c_pepsUsed.add((String)e7.getKey());
                    c_spectra_used.add((String)e7.getKey(), spectra);
                    c_PSMs_used.add((String)e7.getKey(), psms);
                }
                c_spectra_total.add("total", spectra_total);
                c_PSMs_total.add("total", psms_total);
                if (!validPeptide) {
                    c_pepsOmitted.add("total");
                    if (peptideNotInDB) {
                        c_pepsOmittedNotInDB.add("total");
                        continue;
                    }
                    if (!peptideAmbiguous) continue;
                    c_pepsOmittedAmbiguous.add("total");
                    continue;
                }
                c_pepsUsed.add("total");
                c_spectra_used.add("total", spectra_total);
                c_PSMs_used.add("total", psms_total);
                protein.c_proteins = countProts;
                protein.addPeptide(pep, psms_total, spectra_total, "total");
                protein.c_psms_total += psms_total;
            }
        }
        System.out.println("INFO: writing protein table output...");
        UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outputFile));
        ArrayList<String> outHeader = Lists.newArrayList("protein-group", "count proteins", "sequence length");
        if (fMapping != null) {
            outHeader.add("protein-type");
            outHeader.add("protein-reference-id");
        }
        if (fInTmhmm != null && fInSignalp != null) {
            outHeader.addAll(Arrays.asList("SignalP cleavage site", "TMHMM topology", "Combined Topology", "TM count", "protein class"));
        }
        outHeader.add("total - psms");
        for (String exp : experimentList) {
            outHeader.addAll(Arrays.asList(String.valueOf(exp) + " - peptides", String.valueOf(exp) + " - spectra", String.valueOf(exp) + " - psms", String.valueOf(exp) + " - abundance"));
            if (minOutput) continue;
            outHeader.addAll(Arrays.asList(String.valueOf(exp) + " - mapped aa", String.valueOf(exp) + " - coverage"));
            if (fInTmhmm != null && fInSignalp != null) {
                outHeader.addAll(Arrays.asList(String.valueOf(exp) + " - coverage - signal peptide", String.valueOf(exp) + " - spectra - signal peptide", String.valueOf(exp) + " - coverage - outside", String.valueOf(exp) + " - spectra - outside", String.valueOf(exp) + " - coverage - transmembrane", String.valueOf(exp) + " - spectra - transmembrane", String.valueOf(exp) + " - coverage - inside", String.valueOf(exp) + " - spectra - inside"));
            }
            outHeader.addAll(Arrays.asList(String.valueOf(exp) + " - peptide sequences", String.valueOf(exp) + " - mapped sequence"));
        }
        out.writeLine(Joiner.on('\t').join(outHeader));
        ArrayList<ProteinSeq> sortedProteins = new ArrayList<ProteinSeq>();
        if (mappedHierachy != null) {
            for (Map.Entry hierarchy : mappedHierachy.entrySet()) {
                for (Map.Entry groupedProteins : ((SortedMap)hierarchy.getValue()).entrySet()) {
                    sortedProteins.add((ProteinSeq)proteinById.get(groupedProteins.getKey()));
                    for (String subId : (List)groupedProteins.getValue()) {
                        sortedProteins.add((ProteinSeq)proteinById.get(subId));
                    }
                }
            }
            for (String unmappedID : unmappedIDs) {
                sortedProteins.add((ProteinSeq)proteinById.get(unmappedID));
            }
        } else {
            sortedProteins.addAll(proteinBySeq.values());
            Collections.sort(sortedProteins, new Comparator<ProteinSeq>(){

                @Override
                public int compare(ProteinSeq p1, ProteinSeq p2) {
                    return p1.idList.toString().compareTo(p2.idList.toString());
                }
            });
        }
        for (ProteinSeq protein : sortedProteins) {
            if (protein.c_psms_total <= 0 && !allProt) continue;
            ArrayList<Object> outCells = new ArrayList<Object>();
            if (noproteinsort) {
                outCells.add(Joiner.on(';').join(protein.idList));
            } else {
                outCells.add(Joiner.on(';').join(protein.idSet));
            }
            outCells.add(protein.c_proteins);
            outCells.add(protein.sequence.length());
            if (fMapping != null) {
                outCells.add(protein.primaryProteinType);
                outCells.add(protein.primaryProteinReferenceId);
            }
            if (fInTmhmm != null && fInSignalp != null) {
                outCells.add(protein.signalPepCleavage);
                outCells.add(protein.tmhmmPrediction);
                outCells.add(protein.combinedTopology);
                outCells.add(protein.combinedTopologyTMcount);
                outCells.add(protein.proteinClass);
            }
            outCells.add(protein.c_psms_total);
            for (String exp : experimentList) {
                outCells.add(protein.peptidesByExp.get(exp).elementSet().size());
                outCells.add(protein.c_spectraByExp.get(exp));
                outCells.add(protein.c_PSMsByExp.get(exp));
                outCells.add(protein.calcAbundance(exp));
                if (!minOutput) {
                    outCells.add(protein.countMapped(exp));
                    outCells.add(protein.calcCoverage(exp));
                    if (fInTmhmm != null && fInSignalp != null) {
                        outCells.add(protein.getSigPCoverage(exp));
                        outCells.add(protein.signalPepCleavage != null ? protein.c_spectraByExp_SigP.get(exp) : "");
                        outCells.add(protein.getOutCoverage(exp));
                        outCells.add(protein.outRegions != null ? protein.c_spectraByExp_Out.get(exp) : "");
                        outCells.add(protein.getTmCoverage(exp));
                        outCells.add(protein.tmRegions != null ? protein.c_spectraByExp_TM.get(exp) : "");
                        outCells.add(protein.getInCoverage(exp));
                        outCells.add(protein.inRegions != null ? protein.c_spectraByExp_In.get(exp) : "");
                    }
                    outCells.add(Joiner.on(',').join(protein.peptidesByExp.get(exp).elementSet()));
                    outCells.add(protein.getMappedSequence(exp));
                }
                if (protein.c_spectraByExp.get(exp) <= 0) continue;
                if ("TM".equals(protein.proteinClass)) {
                    c_tmProteins.add(exp);
                    if (!c_tmFreq.containsKey(protein.combinedTopologyTMcount)) {
                        HashMultiset ms = HashMultiset.create();
                        c_tmFreq.put(protein.combinedTopologyTMcount, ms);
                    }
                    ((Multiset)c_tmFreq.get(protein.combinedTopologyTMcount)).add(exp);
                } else if ("S".equals(protein.proteinClass)) {
                    c_secretedProteins.add(exp);
                }
                c_proteins.add(exp);
                c_matched.add(exp, protein.countMapped(exp));
                if (protein.peptidesByExp.get(exp).elementSet().size() == 1) {
                    c_singlePepProteins.add(exp);
                }
                if (protein.c_PSMsByExp.get(exp) != 1) continue;
                c_singlePSMProteins.add(exp);
            }
            out.writeTsvLine(outCells);
        }
        out.close();
        if (fGffIn != null) {
            System.out.println("INFO: writing peptide GFF3 file...");
            GenomeFeatureSet gfs = new GenomeFeatureSet(fGffIn, null, false);
            for (String exp : experimentList) {
                File fGffOut = new File(String.valueOf(peptideFile.getAbsolutePath()) + "." + exp + ".gff3");
                if (fGffOut.exists()) {
                    System.err.println("ERROR: cannot write " + fGffOut.getName() + ", file already exists!");
                    continue;
                }
                UOBufferedWriter outGFF = new UOBufferedWriter(new FileWriter(fGffOut));
                outGFF.writeLine(GenomicsUtil.createGFFheader(String.valueOf(peptideFile.getName()) + "." + exp, null));
                for (ProteinSeq protein : sortedProteins) {
                    if (protein.c_spectraByExp.get(exp) <= 0) continue;
                    for (Object proteinId : protein.idSet) {
                        GenomeFeature gfProt = gfs.byId.get(proteinId);
                        if (gfProt == null) {
                            System.err.println("WARNING: did not find a gff entry for '" + (String)proteinId + "'");
                            continue;
                        }
                        for (String pep : protein.peptidesByExp.get(exp).elementSet()) {
                            int sc = protein.peptidesByExp.get(exp).count(pep);
                            int i = 0;
                            while ((i = 1 + protein.sequence.indexOf(pep, i)) > 0) {
                                int start = i;
                                int end = i + pep.length() - 1;
                                GenomeLocation loc = new GenomeLocation(gfProt.location.getSignedStart() + (start - 1) * 3, gfProt.location.getSignedStart() + end * 3 - 1, gfProt.location.chromosome);
                                GenomeFeature gfPep = new GenomeFeature(gfProt.seqId, exp, "peptide", loc, String.valueOf(proteinId) + ":" + pep, false);
                                gfPep.setAtt("protein", Joiner.on(';').join(protein.idSet));
                                gfPep.setAtt("peptide", pep);
                                gfPep.setAtt("spectral count", "" + sc);
                                gfPep.score = 1.0 * (double)sc;
                                outGFF.writeLine(gfPep.toGFFentry());
                            }
                        }
                    }
                }
                outGFF.close();
            }
        }
        if (outputProt3b != null) {
            System.out.println("INFO: writing ambiguous protein group table output...");
            UOBufferedWriter out3b = new UOBufferedWriter(outputProt3b);
            ArrayList<String> header3 = Lists.newArrayList("protein group with not a single unambiguous peptide");
            for (String expTitle : experimentList) {
                header3.add(String.valueOf(expTitle) + " - peptides");
                header3.add(String.valueOf(expTitle) + " - peptide sequences");
                header3.add(String.valueOf(expTitle) + " - spectra");
            }
            out3b.writeTsvLine(header3);
            HashSet<String> proteinsWithUnambiguousEvidence = new HashSet<String>();
            for (ProteinSeq protein : sortedProteins) {
                if (protein.c_psms_total <= 0) continue;
                proteinsWithUnambiguousEvidence.addAll(protein.idSet);
            }
            for (Object e8 : ambiguousHits.entrySet()) {
                boolean hasOne = false;
                for (String id : (SortedSet)e8.getKey()) {
                    if (!proteinsWithUnambiguousEvidence.contains(id)) continue;
                    hasOne = true;
                    break;
                }
                if (hasOne) continue;
                ArrayList<String> elems = Lists.newArrayList(Joiner.on(';').join((Iterable)e8.getKey()));
                for (Object expTitle : experimentList) {
                    ArrayList<String> peps = new ArrayList<String>();
                    int c_spectra = 0;
                    for (Multiset.Entry pep : ((Multiset)((HashMap)e8.getValue()).get(expTitle)).entrySet()) {
                        peps.add((String)pep.getElement());
                        c_spectra += pep.getCount();
                    }
                    elems.add("" + peps.size());
                    elems.add(Joiner.on(';').join(peps));
                    elems.add("" + c_spectra);
                }
                out3b.writeTsvLine(elems);
            }
            out3b.close();
        }
        System.out.println("INFO: writing protein summary output...");
        ArrayList<ArrayList<String>> outCols = new ArrayList<ArrayList<String>>();
        ArrayList<String> headerCol = Lists.newArrayList("experiment", "peptides used (1a or 3a)", "peptides omitted (not in DB)", "peptides omitted (ambiguous)", "spectra total", "spectra used", "PSMs total", "PSMs used", "proteins (protein-sequence-groups)", "single PSM proteins", "single peptide proteins", "secreted proteins", "tm proteins");
        e8 = c_tmFreq.keySet().iterator();
        while (e8.hasNext()) {
            int i = (Integer)e8.next();
            headerCol.add("tm proteins - " + i + " tm domains");
        }
        headerCol.add("identified aminoacids");
        headerCol.add("database-wide coverage");
        outCols.add(headerCol);
        experimentList.add(0, "db");
        c_matched.add("db", c_length_total_db);
        for (String exp : experimentList) {
            String expTitle = exp.equals("db") ? fastaFile.getName() : exp;
            ArrayList<String> outCol = Lists.newArrayList(expTitle, "" + c_pepsUsed.count(exp), "" + c_pepsOmittedNotInDB.count(exp), "" + c_pepsOmittedAmbiguous.count(exp), "" + c_spectra_total.count(exp), "" + c_spectra_used.count(exp), "" + c_PSMs_total.count(exp), "" + c_PSMs_used.count(exp), "" + c_proteins.count(exp), "" + c_singlePSMProteins.count(exp), "" + c_singlePepProteins.count(exp), "" + c_secretedProteins.count(exp), "" + c_tmProteins.count(exp));
            for (Multiset m : c_tmFreq.values()) {
                outCol.add("" + m.count(exp));
            }
            outCol.add("" + c_matched.count(exp));
            outCol.add("" + 1.0 * (double)c_matched.count(exp) / (double)c_length_total_db);
            outCols.add(outCol);
        }
        if (fSummary != null) {
            BufferedWriter summary = new BufferedWriter(new FileWriter(fSummary));
            summary.write(Utils.joinToColumns(outCols, "\t", ""));
            summary.close();
        } else {
            System.out.println(Utils.joinToColumns(outCols, "\t", ""));
        }
        if (pep) {
            System.out.println("INFO: writing a peptide list output for every experiment...");
            for (String exp : experimentList) {
                String expTitle = exp.equals("db") ? fastaFile.getName() : exp;
                File pepFile = new File(String.valueOf(peptideFile.getAbsolutePath()) + "." + expTitle + ".peptideList.txt");
                if (!pepFile.exists()) {
                    UOBufferedWriter outPep = new UOBufferedWriter(pepFile);
                    for (ProteinSeq protein : sortedProteins) {
                        if (protein.peptidesByExp.get(expTitle) == null) continue;
                        outPep.writeLines(protein.peptidesByExp.get(expTitle).elementSet());
                    }
                    outPep.close();
                    continue;
                }
                System.err.println("ERROR: could not write peptide list to " + pepFile.getName() + ". File already exists!");
            }
        }
        if (outputDecoy != null) {
            System.out.println("INFO: calculating decoy protein matches...");
            HashMap<String, String> fastaOrig = Maps.newHashMap(fasta);
            for (Object e8 : fasta.entrySet()) {
                e8.setValue(((String)e8.getValue()).replace('I', '*').replace('L', '*'));
            }
            BufferedReader in = Utils.reader(inputDecoy);
            String line4 = in.readLine();
            ArrayList<String> header4 = Lists.newArrayList(Splitter.on("\t").split(line4));
            int i_peptide = header4.indexOf("peptide sequence");
            int i_proteins = header4.indexOf("proteins");
            int i_spectra = header4.indexOf("total spectra peptide");
            int i_psms = header4.indexOf("total PSM peptide");
            TreeMap<String, DecoyProteinGroup> decoyProteins = new TreeMap<String, DecoyProteinGroup>();
            while ((line4 = in.readLine()) != null) {
                ArrayList<String> elems = Lists.newArrayList(Splitter.on("\t").split(line4));
                String proteins = (String)elems.get(i_proteins);
                String peptide = (String)elems.get(i_peptide);
                if (!decoyProteins.containsKey(proteins)) {
                    decoyProteins.put(proteins, new DecoyProteinGroup(proteins));
                }
                DecoyProteinGroup p = (DecoyProteinGroup)decoyProteins.get(proteins);
                p.peptides.add(peptide);
                p.psms = p.psms + Integer.valueOf((String)elems.get(i_psms));
                p.spectra = p.spectra + Integer.valueOf((String)elems.get(i_spectra));
                String peptideIL = peptide.replace('I', '*').replace('L', '*');
                LinkedHashSet<String> hitIds = Sets.newLinkedHashSet();
                LinkedHashSet<String> hitPeps = Sets.newLinkedHashSet();
                for (Map.Entry<String, String> e9 : fasta.entrySet()) {
                    if (!e9.getValue().contains(peptideIL)) continue;
                    String id = e9.getKey();
                    hitIds.add(id);
                    int pos = e9.getValue().indexOf(peptideIL);
                    hitPeps.add(((String)fastaOrig.get(id)).substring(pos, pos + peptideIL.length()));
                }
                if (hitIds.size() != 0) continue;
                p.peptides_nonTarget.add(peptide);
                p.psms_nonTarget = p.psms_nonTarget + Integer.valueOf((String)elems.get(i_psms));
                p.spectra_nonTarget = p.spectra_nonTarget + Integer.valueOf((String)elems.get(i_spectra));
            }
            in.close();
            UOBufferedWriter outDec = new UOBufferedWriter(new FileWriter(outputDecoy));
            outDec.writeTsvLine("protein group", "peptides", "spectra", "psms", "peptide sequences", "non-target peptides", "non-target spectra", "non-target psms", "non-target peptide sequences");
            for (DecoyProteinGroup p : decoyProteins.values()) {
                outDec.writeTsvLine(p.ids, p.peptides.size(), p.spectra, p.psms, Joiner.on(",").join(p.peptides), p.peptides_nonTarget.size(), p.spectra_nonTarget, p.psms_nonTarget, Joiner.on(",").join(p.peptides_nonTarget));
            }
            outDec.close();
        }
        System.out.println("INFO: done!");
    }

    protected static class DecoyProteinGroup
    implements Comparable {
        String ids;
        Set<String> peptides;
        Integer spectra;
        Integer psms;
        Set<String> peptides_nonTarget;
        Integer spectra_nonTarget;
        Integer psms_nonTarget;

        public DecoyProteinGroup(String ids) {
            this.ids = ids;
            this.peptides = new LinkedHashSet<String>();
            this.spectra = 0;
            this.psms = 0;
            this.peptides_nonTarget = new LinkedHashSet<String>();
            this.spectra_nonTarget = 0;
            this.psms_nonTarget = 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.ids);
        }

        public boolean equals(Object obj) {
            DecoyProteinGroup that = (DecoyProteinGroup)obj;
            return Objects.equal(this.ids, that.ids);
        }

        public int compareTo(Object that) {
            return this.ids.compareTo(((DecoyProteinGroup)that).ids);
        }
    }

    public static class ProteinOld {
        public SortedSet<String> idSet;
        public List<String> idList;
        public int c_proteins;
        public String sequence;
        public Map<String, Integer> c_spectra = new HashMap<String, Integer>();
        public int c_psms_total = 0;
        public Map<String, Set<String>> peptides = new HashMap<String, Set<String>>();

        public ProteinOld(Iterable<String> ids, int countProteins, Map<String, String> fastaMap, List<String> experiments) throws Exception {
            this.c_proteins = countProteins;
            this.idList = Lists.newArrayList(ids);
            this.idSet = Sets.newTreeSet(ids);
            this.sequence = fastaMap.get(ids.iterator().next());
            if (this.sequence == null) {
                throw new Exception("Protein ID not found in FASTA database!");
            }
            if (countProteins != 1 || this.idList.size() <= 1) {
                for (String id : ids) {
                    if (Objects.equal(this.sequence, fastaMap.get(id))) continue;
                    throw new Exception("Protein IDs reference different sequences!");
                }
            }
            for (String experiment : experiments) {
                this.c_spectra.put(experiment, 0);
                this.peptides.put(experiment, new HashSet());
            }
        }

        public int countMapped(String experiment) {
            boolean[] m = new boolean[this.sequence.length()];
            for (String pep : this.peptides.get(experiment)) {
                int s = -1;
                while ((s = this.sequence.indexOf(pep, s + 1)) >= 0) {
                    int j = s;
                    while (j < s + pep.length()) {
                        m[j] = true;
                        ++j;
                    }
                }
            }
            int matching = 0;
            boolean[] blArray = m;
            int n = m.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = blArray[n2];
                if (b) {
                    ++matching;
                }
                ++n2;
            }
            return matching;
        }

        public double calcCoverage(String experiment) {
            return 1.0 * (double)this.countMapped(experiment) / (double)this.sequence.length();
        }

        public String getMappedSequence(String experiment) {
            String mappedSequence = new String(this.sequence).toLowerCase();
            for (String pep : this.peptides.get(experiment)) {
                int s = -1;
                while ((s = this.sequence.indexOf(pep, s + 1)) >= 0) {
                    mappedSequence = String.valueOf(mappedSequence.substring(0, s)) + mappedSequence.substring(s, s + pep.length()).toUpperCase() + mappedSequence.substring(s + pep.length());
                }
            }
            return mappedSequence;
        }

        public int hashCode() {
            return Objects.hashCode(this.idSet);
        }

        public boolean equals(Object o) {
            if (o instanceof ProteinOld) {
                return Objects.equal(((ProteinOld)o).idSet, this.idSet);
            }
            return false;
        }
    }

    public static class ProteinSeq {
        public String sequence;
        public SortedSet<String> idSet;
        public List<String> idList;
        public int c_proteins;
        public String primaryProteinType;
        public String primaryProteinReferenceId;
        public Map<String, Integer> c_spectraByExp = new HashMap<String, Integer>();
        public Map<String, Integer> c_PSMsByExp = new HashMap<String, Integer>();
        public int c_psms_total = 0;
        public Map<String, Multiset<String>> peptidesByExp = new HashMap<String, Multiset<String>>();
        public Map<String, Integer> c_spectraByExp_SigP = new HashMap<String, Integer>();
        public Map<String, Integer> c_spectraByExp_In = new HashMap<String, Integer>();
        public Map<String, Integer> c_spectraByExp_TM = new HashMap<String, Integer>();
        public Map<String, Integer> c_spectraByExp_Out = new HashMap<String, Integer>();
        public Set<String> insilicoUniquePeptides = new HashSet<String>();
        public Integer signalPepCleavage;
        public String tmhmmPrediction;
        public String combinedTopology;
        public Integer combinedTopologyTMcount;
        public IntervalTree<String> tmRegions;
        public IntervalTree<String> inRegions;
        public IntervalTree<String> outRegions;
        public String proteinClass;

        public ProteinSeq(String sequence, List<String> experiments) {
            this.sequence = sequence;
            this.idList = new ArrayList<String>();
            this.idSet = new TreeSet<String>();
            for (String experiment : experiments) {
                this.c_spectraByExp.put(experiment, 0);
                this.c_PSMsByExp.put(experiment, 0);
                HashMultiset pepSet = HashMultiset.create();
                this.peptidesByExp.put(experiment, pepSet);
                this.c_spectraByExp_SigP.put(experiment, 0);
                this.c_spectraByExp_In.put(experiment, 0);
                this.c_spectraByExp_TM.put(experiment, 0);
                this.c_spectraByExp_Out.put(experiment, 0);
            }
        }

        public void addId(String id) {
            this.idList.add(id);
            this.idSet.add(id);
        }

        public void addPeptide(String pep, Integer psms, Integer spectra, String experiment) {
            this.peptidesByExp.get(experiment).add(pep, spectra);
            this.c_PSMsByExp.put(experiment, this.c_PSMsByExp.get(experiment) + psms);
            this.c_spectraByExp.put(experiment, this.c_spectraByExp.get(experiment) + spectra);
            boolean intersectsSigPep = false;
            boolean intersectsTM = false;
            boolean intersectsIn = false;
            boolean intersectsOut = false;
            int i = 0;
            while ((i = 1 + this.sequence.indexOf(pep, i)) > 0) {
                int start = i;
                int end = i + pep.length() - 1;
                if (this.signalPepCleavage != null && !intersectsSigPep && i < this.signalPepCleavage) {
                    intersectsSigPep = true;
                }
                if (this.tmRegions != null && !intersectsTM && this.tmRegions.getIntervalsIntersect(start, end).size() > 0) {
                    intersectsTM = true;
                }
                if (this.inRegions != null && !intersectsIn && this.inRegions.getIntervalsIntersect(start, end).size() > 0) {
                    intersectsIn = true;
                }
                if (this.outRegions == null || intersectsOut || this.outRegions.getIntervalsIntersect(start, end).size() <= 0) continue;
                intersectsOut = true;
            }
            if (intersectsSigPep) {
                this.c_spectraByExp_SigP.put(experiment, this.c_spectraByExp_SigP.get(experiment) + spectra);
            }
            if (intersectsTM) {
                this.c_spectraByExp_TM.put(experiment, this.c_spectraByExp_TM.get(experiment) + spectra);
            }
            if (intersectsIn) {
                this.c_spectraByExp_In.put(experiment, this.c_spectraByExp_In.get(experiment) + spectra);
            }
            if (intersectsOut) {
                this.c_spectraByExp_Out.put(experiment, this.c_spectraByExp_Out.get(experiment) + spectra);
            }
        }

        public int countMapped(Iterable<String> peptides) {
            boolean[] m = new boolean[this.sequence.length()];
            for (String pep : peptides) {
                int s = -1;
                while ((s = this.sequence.indexOf(pep, s + 1)) >= 0) {
                    int j = s;
                    while (j < s + pep.length()) {
                        m[j] = true;
                        ++j;
                    }
                }
            }
            int matching = 0;
            boolean[] blArray = m;
            int n = m.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = blArray[n2];
                if (b) {
                    ++matching;
                }
                ++n2;
            }
            return matching;
        }

        public int countMapped(String experiment) {
            return this.countMapped(this.peptidesByExp.get(experiment).elementSet());
        }

        public double calcAbundance(String experiment) {
            int numerator = 0;
            for (Multiset.Entry<String> e : this.peptidesByExp.get(experiment).entrySet()) {
                numerator += e.getElement().length() * e.getCount();
            }
            if (correctionFactors != null) {
                double denominator = 0.0;
                for (String pep : this.insilicoUniquePeptides) {
                    denominator += (double)pep.length() * correctionFactors.get(pep.length());
                }
                if (denominator == 0.0) {
                    denominator = 15.0 * correctionFactors.get(15);
                }
                return 1.0 * (double)numerator / denominator;
            }
            double denominator = this.countMapped(this.insilicoUniquePeptides);
            if (denominator == 0.0) {
                return 1.0 * (double)numerator / 15.0;
            }
            return 1.0 * (double)numerator / denominator;
        }

        public double calcCoverage(String experiment) {
            return 1.0 * (double)this.countMapped(experiment) / (double)this.sequence.length();
        }

        public String getMappedSequence(String experiment) {
            String mappedSequence = new String(this.sequence).toLowerCase();
            for (String pep : this.peptidesByExp.get(experiment).elementSet()) {
                int s = -1;
                while ((s = this.sequence.indexOf(pep, s + 1)) >= 0) {
                    mappedSequence = String.valueOf(mappedSequence.substring(0, s)) + mappedSequence.substring(s, s + pep.length()).toUpperCase() + mappedSequence.substring(s + pep.length());
                }
            }
            return mappedSequence;
        }

        public Double getTmCoverage(String experiment) {
            if (this.tmRegions != null) {
                String mseq = this.getMappedSequence(experiment);
                int aa_tm = 0;
                int aa_tm_found = 0;
                for (Interval<String> i : this.tmRegions.getIntervals()) {
                    String subSeq = mseq.substring((int)i.getStart() - 1, (int)i.getEnd());
                    aa_tm += subSeq.length();
                    aa_tm_found += subSeq.replaceAll("[a-z]", "").length();
                }
                return 1.0 * (double)aa_tm_found / (double)aa_tm;
            }
            return null;
        }

        public Double getInCoverage(String experiment) {
            if (this.inRegions != null) {
                String mseq = this.getMappedSequence(experiment);
                int aa_in = 0;
                int aa_in_found = 0;
                for (Interval<String> i : this.inRegions.getIntervals()) {
                    String subSeq = mseq.substring((int)i.getStart() - 1, (int)i.getEnd());
                    aa_in += subSeq.length();
                    aa_in_found += subSeq.replaceAll("[a-z]", "").length();
                }
                return 1.0 * (double)aa_in_found / (double)aa_in;
            }
            return null;
        }

        public Double getOutCoverage(String experiment) {
            if (this.outRegions != null) {
                String mseq = this.getMappedSequence(experiment);
                int aa_out = 0;
                int aa_out_found = 0;
                for (Interval<String> i : this.outRegions.getIntervals()) {
                    String subSeq = mseq.substring((int)i.getStart() - 1, (int)i.getEnd());
                    aa_out += subSeq.length();
                    aa_out_found += subSeq.replaceAll("[a-z]", "").length();
                }
                return 1.0 * (double)aa_out_found / (double)aa_out;
            }
            return null;
        }

        public Double getSigPCoverage(String experiment) {
            if (this.signalPepCleavage != null) {
                String mseq = this.getMappedSequence(experiment);
                int spLen = this.signalPepCleavage - 1;
                int aa_sp_found = mseq.substring(0, spLen).replaceAll("[a-z]", "").length();
                return 1.0 * (double)aa_sp_found / (double)spLen;
            }
            return null;
        }

        public int hashCode() {
            return Objects.hashCode(this.sequence);
        }

        public boolean equals(Object o) {
            if (o instanceof ProteinSeq) {
                return Objects.equal(((ProteinSeq)o).sequence, this.sequence);
            }
            return false;
        }
    }
}

