/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.GenomicsUtil;
import iptgxdb.utils.Util;
import java.awt.Color;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class GenomeFeature {
    public String seqId;
    public String source;
    public String type;
    public GenomeLocation location;
    public Double score;
    public Integer phase;
    public AttributeMap atts;
    public static Comparator<GenomeFeature> comparatorLength = new Comparator<GenomeFeature>(){

        @Override
        public int compare(GenomeFeature gff1, GenomeFeature gff2) {
            return Integer.valueOf(gff1.location.length()).compareTo(gff2.location.length());
        }
    };

    public GenomeFeature() {
        this.atts = new AttributeMap();
    }

    public GenomeFeature(String seqId, String source, String type, GenomeLocation location, String id, Boolean pseudo) {
        this.seqId = seqId;
        this.source = source;
        this.type = type;
        this.location = location;
        this.atts = new AttributeMap();
        if (id != null) {
            this.atts.put("ID", id);
        }
        if (pseudo != null) {
            this.atts.put("pseudo", String.valueOf(pseudo));
        }
    }

    public GenomeFeature(String gffLine) throws Exception {
        String[] arr = gffLine.split("\t");
        this.seqId = arr[0];
        this.source = arr[1];
        this.type = arr[2];
        int from = Integer.valueOf(arr[3]);
        int to = Integer.valueOf(arr[4]);
        GenomeLocation.Strand strand = GenomeLocation.Strand.fromString(arr[6]);
        this.location = new GenomeLocation(from, to, strand, this.seqId);
        this.score = arr[5].equals(".") ? null : Double.valueOf(arr[5]);
        this.phase = arr[7].equals(".") ? null : Integer.valueOf(arr[7]);
        this.atts = new AttributeMap(arr[8]);
    }

    public GenomeFeature(String bedLine, String source) throws Exception {
        ArrayList<String> line = Lists.newArrayList(Splitter.on('\t').split(bedLine));
        this.seqId = (String)line.get(0);
        int from = Integer.parseInt((String)line.get(1)) + 1;
        int to = Integer.parseInt((String)line.get(2));
        GenomeLocation.Strand strand = GenomeLocation.Strand.fromString((String)line.get(5));
        this.location = new GenomeLocation(from, to, strand, this.seqId);
        this.atts = new AttributeMap((String)line.get(3));
        this.score = Double.valueOf((String)line.get(4));
        this.source = source;
    }

    public String toString() {
        return this.toGFFentry();
    }

    public String toGFFentry() {
        StringBuilder gff = new StringBuilder();
        gff.append(this.seqId != null ? this.seqId : "seqId").append("\t");
        gff.append(this.source != null ? this.source : "source").append("\t");
        gff.append(this.type).append("\t");
        gff.append(this.location.from).append("\t");
        gff.append(this.location.to).append("\t");
        gff.append(this.score != null ? this.score : ".").append("\t");
        gff.append((Object)this.location.strand).append("\t");
        gff.append(this.phase != null ? this.phase : ".").append("\t");
        gff.append(this.atts).append("\t");
        return gff.toString();
    }

    public String toFastaEntry(StringBuilder forwardSequence, boolean setInitiatorMethionine, boolean inclHeader) throws Exception {
        StringBuilder aa = GenomicsUtil.translate(this.location.getSequence(forwardSequence));
        if (aa.length() == 0) {
            System.out.println("WARN: no sequence generated for " + this.getID());
            return "";
        }
        if (setInitiatorMethionine) {
            aa.setCharAt(0, 'M');
        }
        if (aa.charAt(aa.length() - 1) == '*') {
            aa.deleteCharAt(aa.length() - 1);
        } else {
            System.out.println("WARN: no stop codon for " + this.getID());
        }
        if (aa.indexOf("*") > 0) {
            System.out.println("WARN: " + Util.countChar(aa, '*') + " internal stop codon(s) for " + this.getID());
        }
        StringBuilder res = new StringBuilder();
        if (inclHeader) {
            res.append(">").append(this.getID()).append(Util.nl);
        }
        res.append((CharSequence)aa);
        return res.toString();
    }

    public boolean hasAtt(String att) {
        return this.atts.containsKey(att);
    }

    public String getAtt(String att, String defaultValue) {
        return this.atts.get(att, defaultValue);
    }

    public String getAtt(String att) {
        return this.getAtt(att, null);
    }

    public String setAtt(String att, String value) {
        return this.atts.put(att, value);
    }

    public String getID() {
        return this.getAtt("ID");
    }

    public String setID(String id) {
        if (id.startsWith("\"") && id.endsWith("\"")) {
            id = id.substring(1, id.length() - 1);
        }
        return this.setAtt("ID", id);
    }

    public String setColor(Color color) {
        return this.atts.setColor(color);
    }

    public static class AttributeMap
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 4402328163996824120L;

        public AttributeMap() {
        }

        public AttributeMap(String attributes) {
            String[] atts;
            if (attributes.startsWith("#")) {
                return;
            }
            String[] stringArray = atts = attributes.split(";");
            int n = atts.length;
            int n2 = 0;
            while (n2 < n) {
                String att = stringArray[n2];
                if (att.split("=").length > 1) {
                    String key = att.split("=")[0];
                    String value = URLDecoder.decode(att.split("=")[1]);
                    this.put(key, value);
                }
                ++n2;
            }
        }

        @Override
        public String toString() {
            StringBuilder str = new StringBuilder();
            Iterator keyIterator = this.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                str.append(key);
                str.append("=");
                if (key.equals("color")) {
                    str.append((String)this.get(key));
                } else {
                    str.append(URLEncoder.encode((String)this.get(key)));
                }
                if (!keyIterator.hasNext()) continue;
                str.append(";");
            }
            return str.toString();
        }

        public String toString(boolean doNotEscape) {
            if (doNotEscape) {
                return super.toString();
            }
            return this.toString();
        }

        @Override
        public String put(String key, String value) {
            if (key == null) {
                System.err.println("no null attribute key allowed (" + key + "=" + value + ")");
                return null;
            }
            if (value == null) {
                System.err.println("no null attribute value allowed (" + key + "=" + value + ")");
                return super.put(key, "");
            }
            return super.put(key, value);
        }

        public String setColor(Color col) {
            return this.put("color", String.valueOf(col.getRed()) + "," + col.getGreen() + "," + col.getBlue());
        }

        public String get(String key, String defaultValue) {
            if (this.containsKey(key)) {
                return (String)this.get(key);
            }
            return defaultValue;
        }
    }

    public static interface IdManipulator {
        public String generateId(GenomeFeature var1);
    }
}

