/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import iptgxdb.utils.CLIUtils;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GenBank2Seq {
    public static Options options = new Options(){
        {
            this.addOption(CLIUtils.createArgOption("in", "genbank file", "a plain-text GenBank file", true, false));
            this.addOption(CLIUtils.createArgOption("out", "output file", "sequence as plain-text", true, false));
        }
    };

    public static void printUsageAndExit() {
        new HelpFormatter().printHelp("java -jar GenBank2Seq.jar", "GenBank Sequence Extractor by Ulrich Omasits", options, null, true);
        System.exit(0);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String line;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"-in", "C:/Ulrich/Studium/phd/Christian/Bartonella henselae/sequence/pDT024.gb", "-out", "C:/Ulrich/Studium/phd/Christian/Bartonella henselae/sequence/pDT024.fasta"};
        }
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            GenBank2Seq.printUsageAndExit();
        }
        File fIn = new File(cli.getOptionValue("in"));
        BufferedReader in = Utils.reader(fIn);
        File fOut = new File(cli.getOptionValue("out"));
        if (fOut.exists()) {
            System.err.println("ERROR: " + fOut.getName() + " already exists.");
            System.exit(0);
        }
        UOBufferedWriter out = new UOBufferedWriter(fOut);
        System.out.println("INFO: Parsing '" + fIn.getName() + "'...");
        int c_sequences = 0;
        String locus = null;
        String definition = null;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("LOCUS")) {
                locus = Iterators.get(Splitter.on(CharMatcher.WHITESPACE).omitEmptyStrings().split(line).iterator(), 1);
                continue;
            }
            if (line.startsWith("DEFINITION")) {
                definition = line.substring(12);
                while ((line = in.readLine()).startsWith("            ")) {
                    definition = String.valueOf(definition) + " " + line.substring(12);
                }
                continue;
            }
            if (!line.startsWith("ORIGIN")) continue;
            out.writeLine(">" + locus + (definition != null ? " " + definition : ""));
            locus = null;
            definition = null;
            while (!(line = in.readLine()).startsWith("//")) {
                out.write(line.substring(10).replaceAll(" ", "").toUpperCase());
            }
            out.writeLine("");
            ++c_sequences;
        }
        in.close();
        out.close();
        System.out.println("INFO: Parsing '" + fIn.getName() + "' done! " + c_sequences + " sequence(s) written to '" + fOut.getName() + "'.");
    }
}

