/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.util.HashMap;

public class EggNogParser {
    public static void main(String[] args) throws Exception {
        String line;
        String strInAnnotations = "/home/bioinf/bioinf_archive/32_scmi_storage/gamma_prot_eggnog/gproNOG.annotations.tsv/gproNOG.annotations.tsv";
        String strInNog = "/home/bioinf/bioinf_data/35_scke/agrhizo_pseudomon/3_Pseudomonas/eggnog/pseudomonas_out.txt";
        String strOut = "/home/bioinf/bioinf_data/35_scke/agrhizo_pseudomon/3_Pseudomonas/eggnog/pseudomonas_out.tsv";
        int c = 0;
        System.out.println("INFO: reading in " + new File(strInAnnotations).getName() + "...");
        HashMap<String, String> nogLevel = new HashMap<String, String>();
        HashMap<String, String> nogName = new HashMap<String, String>();
        HashMap<String, String> nogCategory = new HashMap<String, String>();
        BufferedReader inAnnotations = Utils.reader(strInAnnotations);
        while ((line = inAnnotations.readLine()) != null) {
            String key = line.split("\t")[1];
            nogLevel.put(key, line.split("\t")[0]);
            nogCategory.put(key, line.split("\t")[4]);
            nogName.put(key, line.split("\t")[5]);
            ++c;
        }
        inAnnotations.close();
        System.out.println("INFO: loaded " + c + " annotations");
        int cSuccess = 0;
        int cFail = 0;
        System.out.println("INFO: processing " + new File(strInNog).getName() + "...");
        UOBufferedWriter out = new UOBufferedWriter(strOut);
        out.writeTsvLine("protein", "NOG_level", "NOG_category", "NOG_evalue", "NOG_name");
        BufferedReader inNog = Utils.reader(strInNog);
        while ((line = inNog.readLine()) != null) {
            if (!line.startsWith("Query:")) continue;
            String protein = line.substring(13).split(" ")[0];
            line = inNog.readLine();
            if (line.startsWith("Description: ")) {
                line = inNog.readLine();
            }
            if (!line.startsWith("Scores ")) {
                throw new Exception("unexpected format");
            }
            if (!inNog.readLine().startsWith("   --- full sequence ---")) {
                throw new Exception("unexpected format");
            }
            if (!inNog.readLine().startsWith("    E-value ")) {
                throw new Exception("unexpected format");
            }
            if (!inNog.readLine().startsWith("    ------- ")) {
                throw new Exception("unexpected format");
            }
            line = inNog.readLine();
            if (line.length() == 0 || line.trim().startsWith("------ inclusion threshold ------")) {
                ++cFail;
                continue;
            }
            ++cSuccess;
            String eval = line.substring(2, 12).trim();
            String model = line.substring(60).split("\\.")[1];
            out.writeTsvLine(protein, nogLevel.get(model), nogCategory.get(model), eval, nogName.get(model));
        }
        inNog.close();
        out.close();
        System.out.println("INFO: written out top annotation for " + cSuccess + " proteins");
        System.out.println("INFO: no annotation for " + cFail + " proteins");
        System.out.println("INFO: done!");
    }
}

