/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class FastaCompare {
    public static void main(String[] args) throws IOException {
        File fA = new File("P:/33_omul/projects/bartonella_henselae/databases/NC_005956.1.fasta");
        File fB = new File("P:/33_omul/projects/bartonella_henselae/databases/NC_005956_1488.fasta");
        File fOut = new File("P:/33_omul/projects/bartonella_henselae/databases/NC_005956_1525-vs-1488.tsv");
        int maxMismatch = 0;
        System.out.println("INFO: reading '" + fA.getName() + "'...");
        HashMap<String, String> idsA = new HashMap<String, String>();
        TreeMap<String, String> fastaA = new TreeMap<String, String>(FastaReader.readFile(fA, FastaReader.headerUpToFirstWhitespace));
        for (Map.Entry e : fastaA.entrySet()) {
            String string = (String)e.getKey();
            String seq = (String)e.getValue();
            if (idsA.containsKey(seq)) {
                idsA.put(seq, String.valueOf((String)idsA.get(seq)) + ";" + string);
                continue;
            }
            idsA.put(seq, string);
        }
        System.out.println("INFO: reading '" + fB.getName() + "'...");
        HashMap<String, String> idsB = new HashMap<String, String>();
        TreeMap<String, String> fastaB = new TreeMap<String, String>(FastaReader.readFile(fB, FastaReader.headerUpToFirstWhitespace));
        for (Map.Entry entry : fastaB.entrySet()) {
            String id = (String)entry.getKey();
            String seq = (String)entry.getValue();
            if (idsB.containsKey(seq)) {
                idsB.put(seq, String.valueOf((String)idsB.get(seq)) + ";" + id);
                continue;
            }
            idsB.put(seq, id);
        }
        UOBufferedWriter uOBufferedWriter = new UOBufferedWriter(fOut);
        uOBufferedWriter.writeTsvLine("sequence", "length", "id(s) in A", "id(s) in B", "substring match in A", "substring match in B");
        System.out.println("INFO: merging sequences...");
        HashSet sequences = new HashSet();
        sequences.addAll(idsA.keySet());
        sequences.addAll(idsB.keySet());
        int c = 0;
        for (String seq : sequences) {
            System.out.println("INFO: " + ++c + "/" + sequences.size());
            String idA = "";
            if (idsA.containsKey(seq)) {
                idA = (String)idsA.get(seq);
            }
            String idB = "";
            if (idsB.containsKey(seq)) {
                idB = (String)idsB.get(seq);
            }
            ArrayList<String> subtringMatchesA = new ArrayList<String>();
            for (Map.Entry e : idsA.entrySet()) {
                if (((String)e.getValue()).equals(idA)) continue;
                for (Map.Entry<Integer, String> match : Utils.getStringMatches((String)e.getKey(), seq, maxMismatch).entrySet()) {
                    subtringMatchesA.add(String.valueOf((String)e.getValue()) + "[+" + match.getKey() + "]");
                }
                for (Map.Entry<Integer, String> match : Utils.getStringMatches(seq, (String)e.getKey(), maxMismatch).entrySet()) {
                    subtringMatchesA.add(String.valueOf((String)e.getValue()) + "[-" + match.getKey() + "]");
                }
            }
            ArrayList<String> subtringMatchesB = new ArrayList<String>();
            for (Map.Entry e : idsB.entrySet()) {
                if (((String)e.getValue()).equals(idB)) continue;
                for (Map.Entry<Integer, String> match : Utils.getStringMatches((String)e.getKey(), seq, maxMismatch).entrySet()) {
                    subtringMatchesB.add(String.valueOf((String)e.getValue()) + "[+" + match.getKey() + "]");
                }
                for (Map.Entry<Integer, String> match : Utils.getStringMatches(seq, (String)e.getKey(), maxMismatch).entrySet()) {
                    subtringMatchesB.add(String.valueOf((String)e.getValue()) + "[-" + match.getKey() + "]");
                }
            }
            uOBufferedWriter.writeTsvLine(seq, seq.length(), idA, idB, Joiner.on(';').join(subtringMatchesA), Joiner.on(';').join(subtringMatchesB));
        }
        uOBufferedWriter.close();
        System.out.println("INFO: done, goodbye!");
    }
}

