/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import iptgxdb.intervaltree.Interval;
import iptgxdb.intervaltree.IntervalTree;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;

public class GffOverlapsPairwise {
    public static void main(String[] args) throws Exception {
        String line;
        File fIn2 = new File("P:/33_omul/projects/bartonella_henselae/annotations/refseq/NC_005956_2015.proteins+pseudo.gff3");
        File fIn1 = new File("P:/33_omul/projects/bartonella_henselae/annotations/refseq/NC_005956_2013.proteins+pseudo.gff3");
        File fOut = new File("P:/33_omul/projects/bartonella_henselae/annotations/refseq/NC_005956_RefSeq2015vs2013.insersections.tsv");
        BufferedReader in2 = Utils.reader(fIn2);
        IntervalTree<GenomeFeature> gftree = new IntervalTree<GenomeFeature>();
        while ((line = in2.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("track name=")) continue;
            GenomeFeature gf = new GenomeFeature(line);
            gftree.addInterval(gf.location.from, gf.location.to, gf);
        }
        in2.close();
        UOBufferedWriter out = new UOBufferedWriter(fOut);
        out.writeTsvLine("idA - " + fIn1.getName(), "idB - " + fIn2.getName(), "length A", "length B", "length intersect");
        BufferedReader in1 = Utils.reader(fIn1);
        while ((line = in1.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("track name=")) continue;
            GenomeFeature gf = new GenomeFeature(line);
            for (Interval intersectInt : gftree.getIntervalsIntersect(gf.location.from, gf.location.to)) {
                GenomeFeature intersectGF = (GenomeFeature)intersectInt.getData();
                out.writeTsvLine(gf.getID(), intersectGF.getID(), gf.location.length(), intersectGF.location.length(), intersectInt.intersectionLength(gf.location.from, gf.location.to));
            }
        }
        in1.close();
        out.close();
    }
}

