/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.intervaltree;

import iptgxdb.intervaltree.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntervalNode<T> {
    private SortedMap<Interval<T>, List<Interval<T>>> intervals = new TreeMap<Interval<T>, List<Interval<T>>>();
    private long center;
    private IntervalNode<T> leftNode;
    private IntervalNode<T> rightNode;

    public IntervalNode() {
        this.center = 0L;
        this.leftNode = null;
        this.rightNode = null;
    }

    public IntervalNode(List<Interval<T>> intervalList) {
        TreeSet<Long> endpoints = new TreeSet<Long>();
        for (Interval<T> interval : intervalList) {
            endpoints.add(interval.getStart());
            endpoints.add(interval.getEnd());
        }
        if (intervalList.size() > 0) {
            long median;
            this.center = median = this.getMedian(endpoints).longValue();
            ArrayList<Interval<T>> left = new ArrayList<Interval<T>>();
            ArrayList<Interval<T>> right = new ArrayList<Interval<T>>();
            for (Interval<T> interval : intervalList) {
                if (interval.getEnd() < median) {
                    left.add(interval);
                    continue;
                }
                if (interval.getStart() > median) {
                    right.add(interval);
                    continue;
                }
                ArrayList<Interval<T>> posting = (ArrayList<Interval<T>>)this.intervals.get(interval);
                if (posting == null) {
                    posting = new ArrayList<Interval<T>>();
                    this.intervals.put(interval, posting);
                }
                posting.add(interval);
            }
            if (left.size() > 0) {
                this.leftNode = new IntervalNode<T>(left);
            }
            if (right.size() > 0) {
                this.rightNode = new IntervalNode<T>(right);
            }
        }
    }

    public List<Interval<T>> stab(long point) {
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry<Interval<T>, List<Interval<T>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().contains(point)) {
                for (Interval<T> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > point) break;
        }
        if (point < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.stab(point));
        } else if (point > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.stab(point));
        }
        return result;
    }

    public List<Interval<T>> queryIntersect(Interval<?> target) {
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry<Interval<T>, List<Interval<T>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(target)) {
                for (Interval<T> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > target.getEnd()) break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.queryIntersect(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.queryIntersect(target));
        }
        return result;
    }

    public List<Interval<T>> queryContained(Interval<?> target) {
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry<Interval<T>, List<Interval<T>>> entry : this.intervals.entrySet()) {
            if (target.contains(entry.getKey())) {
                for (Interval<T> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > target.getEnd()) break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.queryContained(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.queryContained(target));
        }
        return result;
    }

    public long getCenter() {
        return this.center;
    }

    public void setCenter(long center) {
        this.center = center;
    }

    public IntervalNode<T> getLeft() {
        return this.leftNode;
    }

    public void setLeft(IntervalNode<T> left) {
        this.leftNode = left;
    }

    public IntervalNode<T> getRight() {
        return this.rightNode;
    }

    public void setRight(IntervalNode<T> right) {
        this.rightNode = right;
    }

    private Long getMedian(SortedSet<Long> set) {
        int i = 0;
        int middle = set.size() / 2;
        for (Long point : set) {
            if (i == middle) {
                return point;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.center) + ": ");
        for (Map.Entry<Interval<T>, List<Interval<T>>> entry : this.intervals.entrySet()) {
            sb.append("[" + entry.getKey().getStart() + "," + entry.getKey().getEnd() + "]:{");
            for (Interval<T> interval : entry.getValue()) {
                sb.append("(" + interval.getStart() + "," + interval.getEnd() + "," + interval.getData() + ")");
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

