/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import iptgxdb.utils.GenomeFeatureSet;
import iptgxdb.utils.UOBufferedWriter;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class CLIUtils {
    static int value = 0;

    public static Option createArgOption(String option, String arg, String description, boolean required, boolean multiple) {
        if (multiple) {
            if (option == "ref") {
                return Option.builder(option).hasArgs().argName("tag> <input").valueSeparator(' ').required(required).desc(description).build();
            }
            return Option.builder(option).hasArgs().argName(arg).required(required).desc(description).build();
        }
        return Option.builder(option).hasArg().argName(arg).required(required).desc(description).build();
    }

    public static File getFileOption(CommandLine cli, String option, boolean errorOnExistance) {
        if (cli.hasOption(option)) {
            File f = new File(cli.getOptionValue(option));
            if (errorOnExistance && f.exists()) {
                System.err.println("ERROR: " + f.getName() + " already exists.");
                System.exit(0);
            }
            return f;
        }
        return null;
    }

    public static File[] getFileArray(CommandLine cli, String option) {
        if (!cli.hasOption(option)) {
            return null;
        }
        String[] arr = cli.getOptionValues(option);
        File[] files = new File[arr.length];
        int i = 0;
        while (i < arr.length) {
            files[i] = new File(arr[i]);
            ++i;
        }
        return files;
    }

    public static UOBufferedWriter getUOWriter(CommandLine cli, String option, boolean errorOnExistance) throws IOException {
        File f = CLIUtils.getFileOption(cli, option, errorOnExistance);
        if (f != null) {
            return new UOBufferedWriter(f);
        }
        return null;
    }

    public static boolean validateOptions(CommandLine cli) throws InvalidParameterException {
        HashMap<String, Integer> arguments_repeats = new HashMap<String, Integer>();
        Option[] optionArray = cli.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option opt = optionArray[n2];
            if (GenomeFeatureSet.AnnotationSource.byTag(opt.getOpt()) != null) {
                if (!arguments_repeats.containsKey(opt.getOpt())) {
                    arguments_repeats.put(opt.getOpt(), 0);
                }
                value = (Integer)arguments_repeats.get(opt.getOpt());
                value = value + 1;
                arguments_repeats.put(opt.getOpt(), value);
            }
            ++n2;
        }
        for (Map.Entry arg : arguments_repeats.entrySet()) {
            if ((Integer)arg.getValue() <= GenomeFeatureSet.AnnotationSource.byTag((String)((String)arg.getKey())).repeat) continue;
            throw new InvalidParameterException("ERROR: input argument " + GenomeFeatureSet.AnnotationSource.byTag((String)((String)arg.getKey())).defaultName + " is specified more than " + GenomeFeatureSet.AnnotationSource.byTag((String)((String)arg.getKey())).repeat + " time");
        }
        return true;
    }
}

