/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.GenomicsUtil;
import iptgxdb.utils.UOBufferedWriter;
import java.awt.Color;
import java.io.File;
import java.util.Map;

public abstract class AConverter {
    File[] fIn;
    File fOut;
    int countFeatures;
    UOBufferedWriter out;
    UOBufferedWriter outTab;
    String seqId;
    String source;
    boolean extensive;
    File fOutTab;
    Map<String, StringBuilder> seqs;
    Multiset<String> idsUsed = HashMultiset.create();
    final int streamExtension = 200;
    int featureExtension = 0;
    boolean autoFeatureExtension = false;

    protected abstract Color getColor();

    public static Color getColor(String featureType) {
        if (featureType.equalsIgnoreCase("CDS")) {
            return Color.BLUE;
        }
        if (featureType.equalsIgnoreCase("rRNA") || featureType.equalsIgnoreCase("mRNA") || featureType.equalsIgnoreCase("tRNA") || featureType.equalsIgnoreCase("ncRNA") || featureType.equalsIgnoreCase("miscRNA") || featureType.equalsIgnoreCase("tmRNA")) {
            return Color.RED;
        }
        if (featureType.equalsIgnoreCase("gene")) {
            return Color.GREEN;
        }
        return Color.GRAY.darker();
    }

    public void convert(String seqId, File[] fIn, File fOut, File fOutTab, File fSeq, boolean extensive, String featureExtension) throws Exception {
        this.seqId = seqId;
        this.fIn = fIn;
        this.fOut = fOut;
        this.fOutTab = fOutTab;
        if (featureExtension == null) {
            this.featureExtension = 0;
        } else if (featureExtension.equals("auto")) {
            this.autoFeatureExtension = true;
        } else {
            this.featureExtension = Integer.parseInt(featureExtension);
        }
        if (fSeq != null) {
            Map<String, String> fasta = FastaReader.readFile(fSeq, FastaReader.headerComplete);
            this.seqs = Maps.transformValues(fasta, new Function<String, StringBuilder>(){

                @Override
                public StringBuilder apply(String value) {
                    return new StringBuilder(value);
                }
            });
        }
        this.extensive = extensive;
        this.out = new UOBufferedWriter(fOut);
        String trackName = String.valueOf(fIn[0].getName()) + (fIn.length > 1 ? ".." + fIn[fIn.length - 1].getName() : "");
        this.out.writeLine(GenomicsUtil.createGFFheader(trackName, extensive ? null : this.getColor()));
        if (fOutTab != null) {
            this.outTab = new UOBufferedWriter(fOutTab);
            this.outTab.writeTsvLine("id", "type", "pseudo", "chromosome", "from", "to", "strand", "attributes", "sequence", "200nt upstream", "200nt downstream", "protein sequence");
        }
        this.countFeatures = 0;
        File[] fileArray = fIn;
        int n = fIn.length;
        int n2 = 0;
        while (n2 < n) {
            File inputFile = fileArray[n2];
            this.source = inputFile.getName();
            System.out.println("INFO: Parsing '" + inputFile.getName() + "'...");
            this.convert_internal(inputFile);
            ++n2;
        }
        this.out.close();
        if (this.outTab != null) {
            this.outTab.close();
        }
        System.out.println("INFO: Parsing done! Extracted " + this.countFeatures + " features to '" + fOut.getName() + "'.");
    }

    protected abstract void convert_internal(File var1) throws Exception;

    protected void addGenomeFeature(GenomeFeature gf) throws Exception {
        if (this.extensive) {
            gf.setColor(AConverter.getColor(gf.type));
        }
        if (this.featureExtension != 0) {
            gf.location = new GenomeLocation(gf.location.getSignedStart(), gf.location.getSignedEnd() + this.featureExtension, gf.location.chromosome);
        }
        if (gf.getID() != null) {
            this.idsUsed.add(gf.getID());
            if (this.idsUsed.count(gf.getID()) > 1) {
                gf.setID(String.valueOf(gf.getID()) + "-" + this.idsUsed.count(gf.getID()));
            }
        }
        if (this.seqs != null) {
            StringBuilder seqForward;
            block19: {
                StringBuilder stringBuilder = seqForward = this.seqs.size() == 1 ? this.seqs.values().iterator().next() : this.seqs.get(gf.seqId);
                if (gf.location.length() % 3 == 0) {
                    GenomeLocation lastCodon = new GenomeLocation(gf.location.getSignedEnd() - 2, gf.location.getSignedEnd(), gf.location.chromosome);
                    try {
                        GenomeLocation nextCodon = new GenomeLocation(gf.location.getSignedEnd() + 1, gf.location.getSignedEnd() + 3, gf.location.chromosome);
                        if (GenomicsUtil.translate(lastCodon.getSequence(seqForward)).toString().equals("*") || !GenomicsUtil.translate(nextCodon.getSequence(seqForward)).toString().equals("*")) break block19;
                        if (this.autoFeatureExtension) {
                            gf.location = new GenomeLocation(gf.location.getSignedStart(), gf.location.getSignedEnd() + 3, gf.location.chromosome);
                            break block19;
                        }
                        System.out.println("INFO: 3nt extension of " + gf.getID() + " would result in a stop-codon terminated sequence.");
                    }
                    catch (Exception nextCodon) {}
                } else {
                    int lastFullFrameCodon = gf.location.getSignedEnd() - gf.location.length() % 3 + 1;
                    try {
                        GenomeLocation extensionCodon = new GenomeLocation(lastFullFrameCodon, lastFullFrameCodon + 2, gf.location.chromosome);
                        if (GenomicsUtil.translate(extensionCodon.getSequence(seqForward)).toString().equals("*")) {
                            if (this.autoFeatureExtension) {
                                gf.location = new GenomeLocation(gf.location.getSignedStart(), lastFullFrameCodon + 2, gf.location.chromosome);
                            } else {
                                System.out.println("INFO: full-frame extension of " + gf.getID() + " would result in a stop-codon terminated sequence.");
                            }
                        }
                    }
                    catch (Exception extensionCodon) {
                        // empty catch block
                    }
                }
            }
            if (this.outTab != null) {
                GenomeLocation upstream = null;
                GenomeLocation downstream = null;
                if (gf.location.strand == GenomeLocation.Strand.PLUS) {
                    upstream = new GenomeLocation(gf.location.from - 200, gf.location.from - 1, gf.location.strand, gf.location.chromosome);
                    downstream = new GenomeLocation(gf.location.to + 1, gf.location.to + 200, gf.location.strand, gf.location.chromosome);
                } else if (gf.location.strand == GenomeLocation.Strand.MINUS) {
                    upstream = new GenomeLocation(gf.location.to + 1, gf.location.to + 200, gf.location.strand, gf.location.chromosome);
                    downstream = new GenomeLocation(gf.location.from - 200, gf.location.from - 1, gf.location.strand, gf.location.chromosome);
                }
                this.outTab.writeTsvLine(new Object[]{MoreObjects.firstNonNull(gf.getID(), ""), gf.type, gf.getAtt("pseudo", ""), gf.seqId, gf.location.from, gf.location.to, gf.location.strand, gf.atts.toString(true), gf.location.getSequence(seqForward), upstream.getSequence(seqForward), downstream.getSequence(seqForward), gf.toFastaEntry(seqForward, true, false)});
            }
        }
        this.out.writeLine(gf.toGFFentry());
        ++this.countFeatures;
    }
}

