/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.converter.AConverter;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Util;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ChemGenome2GFF
extends AConverter {
    @Override
    protected void convert_internal(File inputFile) throws Exception {
        String line;
        BufferedReader in = Utils.reader(inputFile);
        String currSeqId = this.seqId != null ? this.seqId : StringUtils.substringBeforeLast(inputFile.getName(), ".");
        while ((line = in.readLine()) != null) {
            if (line.equals("> -strand gene; start: 0 , end: 0") || !line.startsWith(">")) continue;
            if (Util.rx(line, "> ([+-])strand (\\w+); start: (\\d+) , end: (\\d+)")) {
                String type = Util.rxMatcher.group(2);
                GenomeLocation loc = new GenomeLocation(Integer.valueOf(Util.rxMatcher.group(3)), Integer.valueOf(Util.rxMatcher.group(4)), currSeqId);
                this.addGenomeFeature(new GenomeFeature(currSeqId, this.source, type, loc, loc.toString(), false));
                continue;
            }
            System.err.println("WARN: ignored non matching header line: " + line);
        }
        in.close();
    }

    @Override
    protected Color getColor() {
        return Color.YELLOW;
    }
}

