/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import iptgxdb.converter.AConverter;
import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Ensembl2GFF
extends AConverter {
    @Override
    protected void convert_internal(File inputFile) throws Exception {
        BufferedReader in = Utils.reader(inputFile);
        List<String> consideredTypes = Arrays.asList("CDS");
        String line = in.readLine();
        String currChromosome = null;
        LinkedHashMap<String, String> attributes = null;
        do {
            if (line.startsWith("FT                   /chromosome=")) {
                currChromosome = StringUtils.substringBetween(line, "/chromosome=\"", "\"");
                continue;
            }
            if (line.matches("FT   \\w.+")) {
                String type = line.substring(2, 21).trim();
                if (this.extensive || consideredTypes.contains(type) || consideredTypes.size() == 0) {
                    attributes = new LinkedHashMap<String, String>();
                    attributes.put("location", line.substring(21));
                    String key = null;
                    String value = null;
                    while ((line = in.readLine()).startsWith("FT                   ")) {
                        if (line.trim().startsWith("FT                   /")) {
                            int i;
                            if (key != null) {
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                attributes.put(key, value);
                            }
                            if ((i = line.trim().indexOf(61)) == -1) {
                                key = line.trim().substring(22);
                                value = "true";
                                continue;
                            }
                            key = line.trim().substring(22, i);
                            value = line.substring(i + 1);
                            continue;
                        }
                        value = String.valueOf(value) + " " + line.substring(21);
                    }
                    if (key != null) {
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        attributes.put(key, value);
                    }
                    GenomeFeature gf = new GenomeFeature(this.seqId, this.source, type, new GenomeLocation((String)attributes.get("location"), this.seqId), null, null);
                    if (this.extensive) {
                        gf.atts.putAll(attributes);
                    } else if (attributes.containsKey("pseudo")) {
                        gf.atts.put("pseudo", "true");
                    }
                    if (attributes.containsKey("locus_tag")) {
                        gf.setID((String)attributes.get("locus_tag"));
                    } else if (attributes.containsKey("gene")) {
                        gf.setID((String)attributes.get("gene"));
                    } else if (attributes.containsKey("ID")) {
                        gf.setID((String)attributes.get("ID"));
                    }
                    this.addGenomeFeature(gf);
                    continue;
                }
                line = in.readLine();
                continue;
            }
            line = in.readLine();
        } while (line != null && !line.startsWith("SQ   "));
        in.close();
    }

    @Override
    protected Color getColor() {
        return Color.CYAN;
    }
}

