/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.converter;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class GenBank2TSV {
    static final List<String> outputAttributes = Arrays.asList("location", "locus_tag", "gene", "note", "inference", "product", "function", "codon_start", "protein_id", "transl_table", "translation", "pseudo", "EC_number", "gene_synonym", "codon_recognized", "anticodon", "mol_type", "organism", "strain", "db_xref", "source", "operon", "anti-sense_operon_identifier", "promoter_type", "TSS", "TSS_category", "loc_tag", "gene_loc_tag", "sense_gene_loc_tag", "anti-sense_gene_loc_tag", "expression", "citation", "ncRNA_class");

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length > 0 && args[0].equals("debug")) {
            args = new String[]{"P:/33_omul/projects/ecoli_ATCC25922/database/ecoli_ATCC25922.assembly.prokka.gbk"};
        } else if (args.length == 0) {
            System.err.println("please provide a gbk file as input");
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(args[0]));
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("FEATURES")) continue;
            System.out.println("feature\t" + Joiner.on('\t').join(outputAttributes));
            String currFeature = null;
            HashMap<String, String> attributes = null;
            String currAttribute = null;
            String currValue = null;
            line = in.readLine();
            while (true) {
                String prefix = line.substring(5, 21).trim();
                String body = line.substring(21);
                if (prefix.length() > 0) {
                    currFeature = prefix;
                    currAttribute = "location";
                    currValue = body;
                    attributes = new HashMap<String, String>();
                } else if (body.startsWith("/")) {
                    int s = body.indexOf(61);
                    if (s > 0) {
                        currAttribute = body.substring(1, s);
                        currValue = body.substring(s + 1);
                    } else {
                        currAttribute = body.substring(1);
                        currValue = "true";
                    }
                } else {
                    currValue = currAttribute.equals("translation") ? String.valueOf(currValue) + body : String.valueOf(currValue) + " " + body;
                }
                line = in.readLine();
                prefix = line.length() > 21 ? line.substring(5, 21).trim() : "";
                String string = body = line.length() > 21 ? line.substring(21) : "";
                if (prefix.length() <= 0 && line.startsWith("     ") && !body.startsWith("/")) continue;
                if (currValue.startsWith("\"") && currValue.endsWith("\"")) {
                    currValue = currValue.substring(1, currValue.length() - 1);
                }
                if (!outputAttributes.contains(currAttribute)) {
                    System.err.println("WARN: ignoring unkown attribute '" + currAttribute + "' with value '" + currValue + "'");
                }
                if (attributes.containsKey(currAttribute)) {
                    attributes.put(currAttribute, String.valueOf((String)attributes.get(currAttribute)) + ";" + currValue);
                } else {
                    attributes.put(currAttribute, currValue);
                }
                if (prefix.length() <= 0 && line.startsWith("     ")) continue;
                String out = currFeature;
                for (String attribute : outputAttributes) {
                    out = String.valueOf(out) + '\t' + (attributes.containsKey(attribute) ? (String)attributes.get(attribute) : "");
                }
                System.out.println(out);
                if (!line.startsWith("     ")) break;
            }
        }
        in.close();
    }
}

