/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.executables;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import iptgxdb.utils.FastaReader;
import iptgxdb.utils.UOBufferedWriter;
import iptgxdb.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ProteinDecoy {
    public static void main(String[] args) throws IOException {
        File fastaFile = new File("/home/bioinf/bioinf_data/33_omul/projects/bjap_noemi_protease/p1665_db1_d_B_japonicum_wiad_ahch.fasta");
        File peptideFile = new File("/home/bioinf/bioinf_data/33_omul/projects/bjap_noemi_protease/analysis_fdr0.0005/peptidesDecoy_fdr0.0005.tsv");
        File outFile = new File("/home/bioinf/bioinf_data/33_omul/projects/bjap_noemi_protease/analysis_fdr0.0005/proteinsDecoy_fdr0.0005.tsv");
        Map<String, String> fasta = FastaReader.readFile(fastaFile, FastaReader.headerUpToFirstWhitespace);
        HashMap<String, String> fastaOrig = Maps.newHashMap(fasta);
        for (Map.Entry<String, String> e : fasta.entrySet()) {
            e.setValue(e.getValue().replace('I', '*').replace('L', '*'));
        }
        BufferedReader in = Utils.reader(peptideFile);
        String line = in.readLine();
        ArrayList<String> header = Lists.newArrayList(Splitter.on("\t").split(line));
        int i_peptide = header.indexOf("peptide sequence");
        int i_proteins = header.indexOf("proteins");
        int i_spectra = header.indexOf("total spectra peptide");
        int i_psms = header.indexOf("total PSM peptide");
        TreeMap<String, DecoyProteinGroup> decoyProteins = new TreeMap<String, DecoyProteinGroup>();
        while ((line = in.readLine()) != null) {
            ArrayList<String> elems = Lists.newArrayList(Splitter.on("\t").split(line));
            String proteins = (String)elems.get(i_proteins);
            String peptide = (String)elems.get(i_peptide);
            if (!decoyProteins.containsKey(proteins)) {
                decoyProteins.put(proteins, new DecoyProteinGroup(proteins));
            }
            DecoyProteinGroup p = (DecoyProteinGroup)decoyProteins.get(proteins);
            p.peptides.add(peptide);
            p.psms = p.psms + Integer.valueOf((String)elems.get(i_psms));
            p.spectra = p.spectra + Integer.valueOf((String)elems.get(i_spectra));
            String peptideIL = peptide.replace('I', '*').replace('L', '*');
            LinkedHashSet<String> hitIds = Sets.newLinkedHashSet();
            LinkedHashSet<String> hitPeps = Sets.newLinkedHashSet();
            for (Map.Entry<String, String> e : fasta.entrySet()) {
                if (!e.getValue().contains(peptideIL)) continue;
                String id = e.getKey();
                hitIds.add(id);
                int pos = e.getValue().indexOf(peptideIL);
                hitPeps.add(((String)fastaOrig.get(id)).substring(pos, pos + peptideIL.length()));
            }
            if (hitIds.size() != 0) continue;
            p.peptides_nonTarget.add(peptide);
            p.psms_nonTarget = p.psms_nonTarget + Integer.valueOf((String)elems.get(i_psms));
            p.spectra_nonTarget = p.spectra_nonTarget + Integer.valueOf((String)elems.get(i_spectra));
        }
        in.close();
        UOBufferedWriter out = new UOBufferedWriter(new FileWriter(outFile));
        out.writeTsvLine("protein group", "peptides", "spectra", "psms", "peptide sequences", "non-target peptides", "non-target spectra", "non-target psms", "non-target peptide sequences");
        for (DecoyProteinGroup p : decoyProteins.values()) {
            out.writeTsvLine(p.ids, p.peptides.size(), p.spectra, p.psms, Joiner.on(",").join(p.peptides), p.peptides_nonTarget.size(), p.spectra_nonTarget, p.psms_nonTarget, Joiner.on(",").join(p.peptides_nonTarget));
        }
        out.close();
        System.out.println("INFO: done!");
    }

    protected static class DecoyProteinGroup
    implements Comparable {
        String ids;
        Set<String> peptides;
        Integer spectra;
        Integer psms;
        Set<String> peptides_nonTarget;
        Integer spectra_nonTarget;
        Integer psms_nonTarget;

        public DecoyProteinGroup(String ids) {
            this.ids = ids;
            this.peptides = new LinkedHashSet<String>();
            this.spectra = 0;
            this.psms = 0;
            this.peptides_nonTarget = new LinkedHashSet<String>();
            this.spectra_nonTarget = 0;
            this.psms_nonTarget = 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.ids);
        }

        public boolean equals(Object obj) {
            DecoyProteinGroup that = (DecoyProteinGroup)obj;
            return Objects.equal(this.ids, that.ids);
        }

        public int compareTo(Object that) {
            return this.ids.compareTo(((DecoyProteinGroup)that).ids);
        }
    }
}

