/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;

public class QValueCalculator<N extends Number> {
    final TreeMap<N, Float> score2qval;

    public QValueCalculator(Collection<N> positives, Collection<N> falsePositives) {
        ArrayList<N> positiveValues = new ArrayList<N>(positives);
        ArrayList<N> falsePositiveValues = new ArrayList<N>(falsePositives);
        ArrayList<N> allValues = new ArrayList<N>();
        allValues.addAll(positiveValues);
        allValues.addAll(falsePositiveValues);
        Collections.sort(positiveValues, Collections.reverseOrder());
        Collections.sort(falsePositiveValues, Collections.reverseOrder());
        Collections.sort(allValues, Collections.reverseOrder());
        this.score2qval = new TreeMap();
        int posHits = 0;
        int negHits = 0;
        for (Number threshold : allValues) {
            while (posHits < positiveValues.size() && ((Comparable)positiveValues.get(posHits)).compareTo(threshold) >= 0) {
                ++posHits;
            }
            while (negHits < falsePositiveValues.size() && ((Comparable)falsePositiveValues.get(negHits)).compareTo(threshold) >= 0) {
                ++negHits;
            }
            float qval = (float)negHits / (float)posHits;
            this.score2qval.put(threshold, Float.valueOf(qval));
        }
    }

    public Float getQvalue(N threshold) {
        if (threshold == null) {
            return null;
        }
        return this.score2qval.ceilingEntry(threshold).getValue();
    }
}

