/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class Util {
    public static final String nl = System.getProperty("line.separator");
    public static Matcher rxMatcher;

    public static File loadFile(String title, boolean isMandatory) {
        File file = null;
        while ((file = Util.fileDialog(title, isMandatory, 0)) != null && !file.canRead()) {
            JOptionPane.showMessageDialog(null, "The selected file could not be accessed. Please select another file.");
        }
        return file;
    }

    public static File saveFile(String title, boolean isMandatory) {
        File file = Util.fileDialog(title, isMandatory, 1);
        return file;
    }

    private static File fileDialog(String title, boolean isMandatory, int fileDialogMode) {
        FileDialog fileDialog = new FileDialog(new Frame(), title, fileDialogMode);
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        if (fileName == null) {
            if (isMandatory) {
                System.exit(0);
            }
            return null;
        }
        return new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
    }

    public static <T> List<T> concatLists(List<T> ... lists) {
        ArrayList<T> concat = new ArrayList<T>();
        List<T>[] listArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> list = listArray[n2];
            concat.addAll(list);
            ++n2;
        }
        return concat;
    }

    public static <T> Set<T> mergeSets(Set<T> ... sets) {
        HashSet<T> merged = new HashSet<T>();
        Set<T>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<T> set = setArray[n2];
            merged.addAll(set);
            ++n2;
        }
        return merged;
    }

    public static <T> Set<T> mergeAndSortSets(Set<T> ... sets) {
        TreeSet<T> merged = new TreeSet<T>();
        Set<T>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<T> set = setArray[n2];
            merged.addAll(set);
            ++n2;
        }
        return merged;
    }

    public static boolean rx(CharSequence string, String regex) {
        rxMatcher = Pattern.compile(regex).matcher(string);
        return rxMatcher.find();
    }

    public static <E> String join(Iterable<E> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Iterator<E> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            E elem = iterator.next();
            if (elem != null) {
                b.append(elem);
            }
            if (!iterator.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static <E, C extends Iterable<E>> String joinToColumns(Collection<C> iterables, String separator, String nullValue) {
        boolean hasNextRow;
        StringBuilder out = new StringBuilder();
        ArrayList iterators = new ArrayList();
        for (Iterable iterable : iterables) {
            iterators.add(iterable.iterator());
        }
        do {
            hasNextRow = false;
            Iterator ii = iterators.iterator();
            while (ii.hasNext()) {
                Iterator iterator = (Iterator)ii.next();
                if (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (element == null) {
                        out.append(nullValue);
                    } else {
                        out.append(element.toString());
                    }
                    if (iterator.hasNext()) {
                        hasNextRow = true;
                    }
                }
                if (!ii.hasNext()) continue;
                out.append(separator);
            }
            out.append(nl);
        } while (hasNextRow);
        return out.toString();
    }

    public static int countChar(CharSequence haystack, char needle) {
        int count = 0;
        int i = 0;
        while (i < haystack.length()) {
            if (haystack.charAt(i) == needle) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static List<String> readFile(String filename) throws IOException {
        return Util.readFile(new File(filename));
    }

    public static List<String> readFile(File file) throws IOException {
        return Files.readLines(file, Charsets.UTF_8);
    }
}

